/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiApiInvokeService;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiCanvasResourceService;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.ExpressionEngineService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.despatcher.EaiLogicResourcesDiscover;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.canvas.support.service.EaiCanvasConnServiceImpl")
public class EaiCanvasResourceServiceImpl
extends EaiLogicResourcesDiscover
implements EaiCanvasResourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiCanvasResourceServiceImpl.class);
    private static final String ERROR_MSG = "\u672a\u67e5\u8be2\u5230\u8d44\u6e90\u4fe1\u606f";
    private static final String UNSUPPORT_MSG = "\u4e0d\u652f\u6301\u7684\u7c7b\u578b";
    private static final String METHOD_NAME = "getById";
    @Resource
    ICommonStructureService commonStructureService;
    @Resource
    IStructureVersionService structureVersionService;
    @Resource
    ExpressionEngineService expressionEngineService;

    public ApiResponse<Object> getById(String category, String type, Boolean isPublished, Long id) {
        Method method;
        Class clazz = this.getServiceClass(category, type, isPublished);
        if (clazz != null && !clazz.equals(EaiApiInvokeService.class) && (method = BeanUtils.findMethod((Class)clazz, (String)METHOD_NAME, (Class[])new Class[]{Serializable.class})) != null) {
            try {
                Object result = method.invoke(SpringContextUtil.getBean((Class)clazz), id);
                if (HussarUtils.isEmpty((Object)result)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(StructureVersion::getStructureId, (Object)id);
                    result = this.structureVersionService.getOne((Wrapper)wrapper);
                    if (HussarUtils.isEmpty((Object)result)) {
                        throw new BaseException(ERROR_MSG + EaiResourcesEnum.getByType((String)type) + "id:" + id);
                    }
                }
                if (EaiResourcesEnum.STRUCTURE.getType().equals(type)) {
                    result = this.filResult(result, isPublished);
                }
                return ApiResponse.success((Object)result);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("\u753b\u5e03\u8d44\u6e90\u83b7\u53d6\u65b9\u6cd5\u53cd\u5c04\u8c03\u7528\u5f02\u5e38 class={}, method={}, id={}", new Object[]{clazz, METHOD_NAME, id, e});
                Throwable target = e.getTargetException();
                if (target != null) {
                    throw new BaseException(ERROR_MSG, target);
                }
                throw new BaseException(ERROR_MSG, (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("\u753b\u5e03\u8d44\u6e90\u83b7\u53d6\u65b9\u6cd5\u53cd\u5c04\u8c03\u7528\u5f02\u5e38 class={}, method={}, id={}", new Object[]{clazz, METHOD_NAME, id, e});
                throw new BaseException(ERROR_MSG, (Throwable)e);
            }
        }
        throw new BaseException(UNSUPPORT_MSG);
    }

    public ApiResponse<Object> getById(String category, String type, Boolean isPublished, String id, String version) {
        return null;
    }

    private Object filResult(Object result, Boolean isPublish) {
        if (isPublish.booleanValue()) {
            StructureVersion structure = (StructureVersion)JSON.parseObject((String)JSON.toJSONString((Object)result), StructureVersion.class);
            String values = this.filStructureValues(structure.getStructureValues(), isPublish);
            structure.setStructureValues(values);
            return structure;
        }
        CommonStructure structure = (CommonStructure)JSON.parseObject((String)JSON.toJSONString((Object)result), CommonStructure.class);
        String values = this.filStructureValues(structure.getStructureValues(), isPublish);
        structure.setStructureValues(values);
        return structure;
    }

    private String filStructureValues(String value, Boolean isPulish) {
        if (HussarUtils.isEmpty((Object)value)) {
            return value;
        }
        List structureItems = JSON.parseArray((String)value, StructureItems.class);
        if (HussarUtils.isNotEmpty((Object)structureItems)) {
            for (StructureItems structureItem : structureItems) {
                if (!EaiDataType.DATA_TYPE_LIST.getTypeStr().equals(String.valueOf(structureItem.getType())) || !HussarUtils.isEmpty((Object)structureItem.getItems()) || !HussarUtils.isNotEmpty((Object)structureItem.getQuoteStructureId())) continue;
                Long id = Long.valueOf(structureItem.getQuoteStructureId());
                String itemValues = null;
                if (isPulish.booleanValue()) {
                    StructureVersion structureVersion = (StructureVersion)this.structureVersionService.getById((Serializable)id);
                    itemValues = structureVersion.getStructureValues();
                } else {
                    CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)id);
                    itemValues = commonStructure.getStructureValues();
                }
                List chidItems = JSON.parseArray((String)itemValues, StructureItems.class);
                structureItem.setItems(chidItems);
            }
        }
        return JSON.toJSONString((Object)structureItems);
    }

    public String getClassName(String category, String type, Boolean isPublished) {
        Class clazz = this.getServiceClass(category, type, isPublished);
        if (clazz == null) {
            throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7c7b\u540d");
        }
        return clazz.getName();
    }

    public ApiResponse<Object> getById(String type, Boolean isPublished, String id) {
        Object objectValue = null;
        switch (type) {
            case "constant": {
                objectValue = this.expressionEngineService.getEaiConstantById((Object)id, isPublished.booleanValue());
                return ApiResponse.success((Object)objectValue);
            }
            case "auth": {
                objectValue = this.expressionEngineService.getEaiAuthParamByIdFromCache((Object)id);
                return ApiResponse.success((Object)objectValue);
            }
        }
        throw new BaseException("\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\uff01");
    }
}

