/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.api.canvas.runtime.dto.EaiApiInvokeParams;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiApiInvokeService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.configuration.service.IEaiConfigurationBuildService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiLogicRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.manager.EaiResponseServiceManager;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.util.EaiApiPathUtil;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IConnectionVersionService;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonConfiguration;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationConvertUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl.EaiApiInvokeServiceImpl")
public class EaiApiInvokeServiceImpl
extends EaiResponseServiceManager
implements EaiApiInvokeService {
    @Resource
    IConnectionVersionService connectionVersionService;
    @Resource
    ICommonConnectionService commonConnectionService;
    private static final String AUTH_PARAMS = "authParams";
    private static final String AUTH_PARAMS_K = "paramsNameEn";
    private static final String AUTH_PARAMS_V = "paramsValue";
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private EaiLogicRuntimeService logicRunService;
    @Resource
    private NodeBusinessService nodeBusinessService;
    @Resource
    private ApiNamingService apiNamingService;
    @Resource
    private IApiVersionService apiVersionService;
    @Resource
    private EaiLogicRuntimeService eaiLogicRuntimeService;
    @Resource
    private EaiApiProperties eaiApiProperties;
    @Resource
    private IEaiApplicationAuthService eaiApplicationAuthService;
    @Resource
    private IEaiConfigurationBuildService eaiConfigurationBuildService;
    private static final String CONN_ERROR = "\u672a\u67e5\u8be2\u5230\u8fde\u63a5\u4fe1\u606f";
    @Resource
    IHttpAuthenticationService authenticationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Object> getResponse(EaiApiInvokeParams eaiApiInvokeParams) throws Exception {
        AssertUtil.isNotNull((Object)eaiApiInvokeParams, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3anull");
        AssertUtil.isNotNull((Object)eaiApiInvokeParams.getApiId(), (String)"\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getResourceRelationId, (Object)eaiApiInvokeParams.getApiId())).eq(EaiResourcesInfo::getDeleteState, (Object)"0");
        EaiResourcesInfo eaiResourcesInfo = (EaiResourcesInfo)this.eaiResourcesInfoService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)eaiResourcesInfo)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u63a5\u53e3\u4fe1\u606f");
        }
        List<EaiApplicationAuth> eaiApplicationAuths = this.getEaiApplicationAuth(eaiApiInvokeParams.getApplicationCode());
        if (1 == this.eaiApiProperties.getLogicType()) {
            Map<String, Object> auth = eaiApiInvokeParams.getHttpHeader();
            Long connId = eaiApiInvokeParams.getConnId();
            if (HussarUtils.isNotEmpty((Object)connId)) {
                Map<String, Object> authMap = this.getAuthMap(connId, eaiApiInvokeParams.getDebug());
                if (HussarUtils.isNotEmpty((Object)auth)) {
                    if (HussarUtils.isNotEmpty(authMap)) {
                        auth.putAll(authMap);
                    }
                } else {
                    auth = authMap;
                }
            }
            if (HussarUtils.isNotEmpty((Object)auth)) {
                this.authParamsConvert(eaiApplicationAuths, auth);
                TempHttpCode.setParams((Map)auth);
            }
            EaiApiVersion apiVersion = (EaiApiVersion)this.apiVersionService.getById((Serializable)eaiResourcesInfo.getResourceVersionId());
            JsonConfiguration jsonConfiguration = HussarIntegrationJsonUtils.Contextual.getConfigure();
            try {
                this.eaiConfigurationBuildService.buildJsonConfiguration(eaiApiInvokeParams.getApplicationCode(), apiVersion.getApiVersion());
                String apiPath = EaiApiPathUtil.getApiPath((String)eaiApiInvokeParams.getApplicationCode(), (String)apiVersion.getApiCode());
                String businessId = apiPath.startsWith("/") ? String.format("POST %s", apiPath) : String.format("POST /%s", apiPath);
                LambdaQueryWrapper queryWrapper1 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiNaming::getBusinessId, (Object)businessId);
                ApiNaming apiNaming = (ApiNaming)this.apiNamingService.getOne((Wrapper)queryWrapper1);
                if (HussarUtils.isEmpty((Object)apiNaming)) {
                    throw new BaseException("\u672a\u67e5\u8be2\u5230\u63a5\u53e3\u4fe1\u606f\u63a5\u53e3\u540d\u79f0\uff1a" + apiVersion.getApiName());
                }
                Object body = eaiApiInvokeParams.getHttpBody();
                LambdaQueryWrapper queryWrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(NodeBusiness::getNodeName, (Object)apiNaming.getServiceName());
                NodeBusiness nodeBusiness = (NodeBusiness)this.nodeBusinessService.getOne((Wrapper)queryWrapper2);
                if (HussarUtils.isEmpty((Object)nodeBusiness)) {
                    throw new BaseException("\u672a\u67e5\u8be2\u5230\u89e3\u6790\u5f15\u64ce\u5173\u8054\u4fe1\u606f");
                }
                String jsonParams = nodeBusiness.getJsonParams();
                Object[] logicParams = null;
                String className = null;
                if (HussarUtils.isNotEmpty((Object)jsonParams)) {
                    List array = (List)HussarIntegrationJsonUtils.parse((String)jsonParams, List.class);
                    className = (String)array.get(0);
                    if (body instanceof List) {
                        logicParams = ((List)body).toArray();
                    } else if (body instanceof Map) {
                        logicParams = this.logicParams(array, (Map)body);
                    } else {
                        Map map = (Map)HussarIntegrationJsonUtils.convert((Object)body, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        logicParams = this.logicParams(array, map);
                    }
                }
                ApiResponse apiResponse = this.eaiLogicRuntimeService.run(eaiApiInvokeParams.getCtx(), className, logicParams);
                return apiResponse;
            }
            finally {
                HussarIntegrationJsonUtils.Contextual.setConfigure((JsonConfiguration)jsonConfiguration);
            }
        }
        JsonConfiguration jsonConfiguration = HussarIntegrationJsonUtils.Contextual.getConfigure();
        try {
            Long connId;
            HttpAuthVerifyDto authVerifyDto = this.eaiParamsChangeService.getApiTestDto(eaiApiInvokeParams.getHttpBody(), String.valueOf(eaiResourcesInfo.getResourceVersionId()), true);
            if (HussarUtils.isEmpty((Object)authVerifyDto)) {
                throw new BaseException("\u672a\u67e5\u8be2\u5230\u63a5\u53e3\u4fe1\u606f");
            }
            ArrayList<EaiHttpParamsDto> authParams = new ArrayList<EaiHttpParamsDto>();
            Map headers = eaiApiInvokeParams.getHttpHeader();
            this.authParamsConvert(eaiApplicationAuths, headers);
            if (HussarUtils.isNotEmpty((Object)headers)) {
                authParams.addAll(this.toEaiHttpParamsDtos(headers));
            }
            if (HussarUtils.isNotEmpty((Object)(connId = eaiApiInvokeParams.getConnId()))) {
                Map<String, Object> authMap = this.getAuthMap(connId, eaiApiInvokeParams.getDebug());
                this.authParamsConvert(eaiApplicationAuths, authMap);
                authParams.addAll(this.toEaiHttpParamsDtos(authMap));
                authVerifyDto.setTokenVerifys(authParams);
            }
            authVerifyDto.setHasCache(HussarUtils.isEmpty((Object)eaiApiInvokeParams.getHasCache()) || eaiApiInvokeParams.getHasCache() != false);
            ApiResponse response = this.authenticationService.apiInvoke(authVerifyDto);
            ApiResponse<Object> apiResponse = this.getResp((ApiResponse<EaiApiResponseVo>)response, eaiApiInvokeParams.getApiId());
            return apiResponse;
        }
        finally {
            HussarIntegrationJsonUtils.Contextual.setConfigure((JsonConfiguration)jsonConfiguration);
        }
    }

    private Map<String, Object> getAuthMap(Long connId, boolean debug) {
        HashMap<String, Object> authMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)connId)) {
            String config;
            if (debug) {
                CommonConnection commonConnection = (CommonConnection)this.commonConnectionService.getById((Serializable)connId);
                if (HussarUtils.isEmpty((Object)commonConnection)) {
                    throw new BaseException(CONN_ERROR);
                }
                config = commonConnection.getConnectionConfig();
            } else {
                ConnectionVersion connectionVersion = (ConnectionVersion)this.connectionVersionService.getById((Serializable)connId);
                if (HussarUtils.isEmpty((Object)connectionVersion)) {
                    throw new BaseException(CONN_ERROR);
                }
                config = connectionVersion.getConnectionConfig();
            }
            Map map = (Map)HussarIntegrationJsonUtils.parse((String)config, (TypeReference)new TypeReference<Map<String, Object>>(){});
            List key = (List)HussarIntegrationConvertUtils.convert(map.get(AUTH_PARAMS), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            key.forEach(chlid -> authMap.put(String.valueOf(chlid.get(AUTH_PARAMS_K)), chlid.get(AUTH_PARAMS_V)));
        }
        return authMap;
    }

    private List<EaiHttpParamsDto> toEaiHttpParamsDtos(Map<String, Object> map) {
        ArrayList<EaiHttpParamsDto> list = new ArrayList<EaiHttpParamsDto>(map.size());
        map.forEach((k, v) -> {
            EaiHttpParamsDto dto = new EaiHttpParamsDto();
            dto.setParamsNameEn(k);
            dto.setKeyValue(v);
            list.add(dto);
        });
        return list;
    }

    public Object[] logicParams(List<String> array, Map<String, Object> realParams) {
        Object[] logicParams = null;
        if (array.size() > 1) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 1; i < array.size(); ++i) {
                boolean isNull = true;
                if (ToolUtil.isNotEmpty(realParams)) {
                    for (Map.Entry<String, Object> httpParamsDto : realParams.entrySet()) {
                        if (!array.get(i).equals(httpParamsDto.getKey())) continue;
                        list.add(httpParamsDto.getValue());
                        isNull = false;
                        break;
                    }
                }
                if (!isNull) continue;
                list.add(null);
            }
            logicParams = list.toArray();
        } else {
            logicParams = HussarUtils.isNotEmpty(realParams) ? new Object[]{realParams} : new Object[]{};
        }
        return logicParams;
    }

    private void authParamsConvert(List<EaiApplicationAuth> eaiApplicationAuths, Map<String, Object> auth) {
        if (HussarUtils.isNotEmpty(eaiApplicationAuths)) {
            for (EaiApplicationAuth eaiApplicationAuth : eaiApplicationAuths) {
                String key = eaiApplicationAuth.getParamsNameEn();
                if (!auth.containsKey(key)) continue;
                auth.put(key, ParamsConvertUtil.parseConstant((String)(auth.get(key) == null ? null : String.valueOf(auth.get(key))), (String)eaiApplicationAuth.getParamsType()));
            }
        }
    }

    private List<EaiApplicationAuth> getEaiApplicationAuth(String appCode) {
        LambdaQueryWrapper queryWrapper1 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)appCode);
        return this.eaiApplicationAuthService.list((Wrapper)queryWrapper1);
    }
}

