/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.configuration.service.IEaiConfigurationBuildService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiVerifyService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.logicresource.dto.CanvasDebugDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiLogicRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl.EaiLogicConfig;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.constant.logic.EaiLogicConstant;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.EaiCanvasParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.EaiCanvasUtil;
import com.jxdinfo.hussar.eai.common.util.EaiFormDataParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.EaiLogicSource;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ILogicSourceService;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.logic.engine.constants.SourceNamespace;
import com.jxdinfo.hussar.logic.engine.context.LogicExecutionContext;
import com.jxdinfo.hussar.logic.engine.context.LogicExecutionFieldNames;
import com.jxdinfo.hussar.logic.engine.context.impl.SimpleLogicExecutionContext;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.logic.generator.service.LogicGenerateService;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasComponent;
import com.jxdinfo.hussar.logic.structure.canvas.LogicCanvasMetadata;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateSource;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl.EaiCanvasRuntimeServiceImpl")
public class EaiCanvasRuntimeServiceImpl
implements EaiCanvasRuntimeService {
    @Resource
    private LogicGenerateService logicGenerateService;
    @Resource
    private EaiLogicConfig eaiLogicConfig;
    @Resource
    private EaiLogicRuntimeService eaiLogicRuntimeService;
    @Resource
    private EaiVerifyService eaiVerifyService;
    @Autowired
    SourceService sourceService;
    @Autowired
    ILogicSourceService logicSourceService;
    private static final Integer RANDOM_BOND = 999;
    @Resource
    private IEaiConfigurationBuildService eaiConfigurationBuildService;
    private static final String PARAMS = "params";
    private static final String FILES = "files";
    private static final String DEBUG_CLASS_NAME = "className";

    public ApiResponse<Object> runWithDebug(CanvasDebugDto canvasDebugDto) {
        return this.runWithDebug(canvasDebugDto, false);
    }

    public ApiResponse<Object> runWithDebug(CanvasDebugDto canvasDebugDto, boolean withFile) {
        String resourceEn = canvasDebugDto.getResourcesEnum();
        if (HussarUtils.isNotEmpty((Object)resourceEn)) {
            canvasDebugDto.setResourceEnum(EaiResourcesEnum.getByType((String)resourceEn.toLowerCase()));
        }
        String canvas = canvasDebugDto.getCanvas();
        canvasDebugDto.setCanvas(canvas);
        this.eaiConfigurationBuildService.debugJsonConfiguration(canvasDebugDto.getApplicationCode());
        Map<String, Object> map = this.generateCanvas(canvasDebugDto);
        if (HussarUtils.isEmpty(map)) {
            throw new BaseException("\u751f\u6210\u4ee3\u7801\u5f02\u5e38");
        }
        Object obj = map.get(FILES);
        if (HussarUtils.isEmpty((Object)obj)) {
            throw new BaseException("\u4ee3\u7801\u751f\u6210\u5f02\u5e38");
        }
        List list = (List)HussarIntegrationJsonUtils.convert((Object)obj, (TypeReference)new TypeReference<List<LogicGenerateFile>>(){});
        String debugClass = String.valueOf(map.get(DEBUG_CLASS_NAME));
        this.sourceService.saveOrUpdate(SourceNamespace.DEV, debugClass, ((LogicGenerateFile)list.get(0)).getContent());
        Object body = canvasDebugDto.getHttpBody();
        ApiResponse resp = null;
        HashMap<String, String> headerMap = canvasDebugDto.getHttpHeader();
        if (null == headerMap) {
            headerMap = new HashMap<String, String>();
        }
        String key = String.format("eai:api:debug:token:%s", canvasDebugDto.getApplicationCode());
        headerMap.put(key, String.format("%s:%s", key, debugClass));
        LogicExecutionContext ctx = this.configContext(canvasDebugDto.isMockEnabled());
        TempHttpCode.setParams(headerMap);
        if (HussarUtils.isNotEmpty((Object)body)) {
            Map<String, Object> bodyMap = this.initializeInParams(canvasDebugDto.getInParams(), body, withFile);
            List params = map.get(PARAMS) == null ? null : (List)map.get(PARAMS);
            ArrayList<Object> b = new ArrayList<Object>();
            if (HussarUtils.isNotEmpty((Object)params)) {
                for (String param : params) {
                    if (!bodyMap.containsKey(param)) continue;
                    b.add(bodyMap.get(param));
                }
            }
            resp = this.eaiLogicRuntimeService.debug(ctx, debugClass, b.toArray());
        } else {
            resp = this.eaiLogicRuntimeService.debug(ctx, debugClass, null);
        }
        TempHttpCode.removeAll();
        String cacheName = String.format("eai:api:debug:token:%s", canvasDebugDto.getApplicationCode());
        if (HussarCacheUtil.containKey((String)cacheName, (Object)cacheName)) {
            HussarCacheUtil.evict((String)cacheName, (Object)cacheName);
        }
        CompletableFuture.runAsync(() -> this.deleteDebugCode(debugClass));
        return resp;
    }

    private LogicExecutionContext configContext(boolean mockEnabled) {
        SimpleLogicExecutionContext ctx = new SimpleLogicExecutionContext();
        ctx.setField(LogicExecutionFieldNames.CONFIG_USE_MOCK, (Object)mockEnabled);
        return ctx;
    }

    private Map<String, Object> initializeInParams(EaiCanvasParamsConvertDto canvasParamsConvertDto, Object params, boolean withFile) {
        Map inMap = !withFile ? (Map)HussarIntegrationJsonUtils.convert((Object)params, (TypeReference)new TypeReference<Map<String, Object>>(){}) : (Map)params;
        if (canvasParamsConvertDto == null) {
            return inMap;
        }
        List body = canvasParamsConvertDto.getBody();
        if (!withFile) {
            EaiApiParams apiParams = ParamsConvertUtil.oEaiParamsItems((Object)inMap, (String)HussarIntegrationJsonUtils.toString((Object)body), (boolean)true, (boolean)false);
            return (Map)HussarIntegrationJsonUtils.convert((Object)apiParams.getBody(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        EaiApiParams apiParams = EaiFormDataParamsConvertUtil.formDataEaiParamsItems((Map)inMap, (String)HussarIntegrationJsonUtils.toString((Object)body), (boolean)false);
        return (Map)apiParams.getBody();
    }

    public void bodyMergeFile(CanvasDebugDto canvasDebugDto, MultipartHttpServletRequest request) {
        Map body = (Map)canvasDebugDto.getHttpBody();
        if (CollectionUtil.isEmpty((Map)body)) {
            body = Maps.newHashMapWithExpectedSize((int)5);
        }
        if (HussarUtils.isNotEmpty((Object)canvasDebugDto.getInParams()) && CollectionUtil.isNotEmpty((Collection)canvasDebugDto.getInParams().getBody())) {
            this.eaiVerifyService.getFileForBody(body, canvasDebugDto.getInParams().getBody(), request);
        }
        canvasDebugDto.setHttpBody((Object)body);
    }

    private void deleteDebugCode(String debugClass) {
        String nameSpace = EaiLogicConstant.getNameSpace((String)debugClass);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiLogicSource::getNamespace, (Object)"DEV")).like(EaiLogicSource::getSourceCode, (Object)nameSpace);
        this.logicSourceService.remove((Wrapper)queryWrapper);
    }

    private Map<String, Object> generateCanvas(CanvasDebugDto canvasDebugDto) {
        AssertUtil.isNotNull((Object)canvasDebugDto, (String)"\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        AssertUtil.isNotNull((Object)canvasDebugDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)canvasDebugDto.getCode(), (String)"\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        LogicCanvasComponent canvasComponent = (LogicCanvasComponent)HussarIntegrationJsonUtils.parse((String)canvasDebugDto.getCanvas(), LogicCanvasComponent.class);
        LogicGenerateSource generateSource = new LogicGenerateSource();
        generateSource.setRoot(canvasComponent);
        String apiCode = canvasDebugDto.getCode();
        SecureRandom rand = RandomUtil.getSecureRandom();
        Integer randNum = rand.nextInt(RANDOM_BOND);
        String v = String.format("debug_%s_%s", apiCode.toLowerCase(), randNum);
        List list = EaiCanvasUtil.setOpenModules((String)canvasDebugDto.getApplicationCode(), (String)canvasDebugDto.getResourceEnum().getType(), (String)v);
        generateSource.setModules(list);
        LogicCanvasMetadata canvasMetadata = new LogicCanvasMetadata();
        canvasMetadata.setId(String.valueOf(canvasDebugDto.getId()));
        canvasMetadata.setName(apiCode);
        canvasMetadata.setDesc(canvasDebugDto.getName());
        canvasMetadata.setVersion(v);
        generateSource.setMeta(canvasMetadata);
        LogicGenerateResult logicGenerateResult = this.logicGenerateService.generate(generateSource, this.eaiLogicConfig.initConfigure(true, canvasDebugDto.getApplicationCode(), v));
        if (HussarUtils.isNotEmpty((Object)logicGenerateResult)) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            List params = logicGenerateResult.getParameterNames();
            List files = logicGenerateResult.getFiles();
            map.put(PARAMS, params);
            map.put(FILES, files);
            String debugClass = EaiLogicConstant.getOpenPackageName((String)canvasDebugDto.getApplicationCode(), (EaiResourcesEnum)canvasDebugDto.getResourceEnum(), (String)canvasDebugDto.getCode(), (String)v);
            map.put(DEBUG_CLASS_NAME, debugClass);
            return map;
        }
        return null;
    }
}

