/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl;

import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiGenerateService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl.EaiStructureGenerateSourceManager;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.logic.engine.constants.SourceNamespace;
import com.jxdinfo.hussar.logic.engine.entity.LogicSourceEntity;
import com.jxdinfo.hussar.logic.engine.service.SourceService;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateConfigure;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateResult;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateSource;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureClassNameResolver;
import com.jxdinfo.hussar.logic.integration.eai.service.EaiStructureGenerateService;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl.EaiStructureClassResolverImpl")
public class EaiStructureClassResolverImpl
implements EaiStructureClassNameResolver {
    @Resource
    private EaiGenerateService eaiGenerateService;
    @Autowired
    SourceService sourceService;
    @Resource
    private EaiStructureGenerateSourceManager structureGenerateSourceManager;
    @Resource
    EaiStructureClassNameResolver eaiStructureClassNameResolver;
    @Resource
    private EaiStructureGenerateService eaiStructureGenerateService;
    private static final String COLON = ":";
    private static final String OPEN_COLON = ":open:";

    public String resolveStructureClassName(String structureId, EaiStructureGenerateConfigure configure) {
        String className;
        Boolean isPublish;
        String[] strings = structureId.trim().split(COLON);
        Boolean temp = isPublish = Boolean.valueOf(configure.getDebug() == false);
        String type = strings[0];
        Long id = Long.valueOf(strings[strings.length - 1]);
        if (strings.length == 1) {
            type = EaiResourcesEnum.STRUCTURE.getType();
        }
        if (structureId.startsWith(COLON)) {
            type = EaiResourcesEnum.STRUCTURE.getType();
            return this.eaiGenerateService.generatedClassName(configure.getEaiInfo().getEnvironmentCategory(), type, id, configure.getEaiInfo().getApplicationVersion(), isPublish);
        }
        if (structureId.contains(OPEN_COLON)) {
            type = EaiResourcesEnum.STRUCTURE.getType();
            temp = true;
        }
        if (!this.hasCode(className = this.eaiGenerateService.generatedClassName(configure.getEaiInfo().getEnvironmentCategory(), type, id, configure.getEaiInfo().getApplicationVersion(), temp), temp).booleanValue()) {
            LogicGenerateConfigure logicGenerateConfigure = new LogicGenerateConfigure();
            logicGenerateConfigure.setEaiInfo(configure.getEaiInfo());
            logicGenerateConfigure.setDebug(configure.getDebug());
            if (configure.getDebug().booleanValue()) {
                logicGenerateConfigure.setAllowCodeFormat(Boolean.valueOf(false));
            }
            EaiStructureGenerateSource eaiStructureGenerateSource = this.structureGenerateSourceManager.generateStructureCode(id, type, logicGenerateConfigure);
            EaiStructureGenerateConfigure structConfig = new EaiStructureGenerateConfigure();
            structConfig.setDebug(configure.getDebug());
            structConfig.setEaiInfo(configure.getEaiInfo());
            structConfig.setStructureResolver(this.eaiStructureClassNameResolver);
            structConfig.setPrefixPackage("com.jxdinfo.hussar.eai.generated");
            this.saveCode(className, "", isPublish);
            EaiStructureGenerateResult result = this.eaiStructureGenerateService.generateStructureCode(eaiStructureGenerateSource, structConfig);
            this.saveCode(className, result.getContent(), isPublish);
        }
        return className;
    }

    private void saveCode(String className, String result, Boolean isPublish) {
        this.sourceService.saveOrUpdate(isPublish != false ? SourceNamespace.PROD : SourceNamespace.DEV, className, result);
    }

    private Boolean hasCode(String className, Boolean isPublish) {
        LogicSourceEntity entity = this.sourceService.get(isPublish != false ? SourceNamespace.PROD : SourceNamespace.DEV, className);
        return entity != null;
    }
}

