/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddBodyListApiInfoDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.ApiCanvasInfo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.GenerateCanvasCommonInfoDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.EaiCanvasService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.IEaiGenerateCanvasTemplateService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasInfoService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.info.dto.HttpGenerateCanvasInfoDto;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IConnectionVersionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IEaiLogicVersionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl.EaiCanvasServiceImpl")
public class EaiCanvasServiceImpl
implements EaiCanvasService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiCanvasServiceImpl.class);
    private static final String ERROR = "\u4fdd\u5b58\u5931\u8d25";
    private static final String WEBSERVICE_APITYPE = "1";
    @Resource
    protected EaiApiProperties eaiApiProperties;
    @Resource
    IEaiCanvaParamsConvertService canvaParamsConvertService;
    @Resource
    protected IEaiApiInfoService apiInfoService;
    @Resource
    protected ICanvasInfoService canvasInfoService;
    @Resource
    protected EaiCanvasInfoService eaiCanvasInfoService;
    @Resource
    protected IEaiEditApiService iEaiEditApiService;
    @Resource
    protected IEaiGenerateCanvasTemplateService generateCanvasTemplateService;

    public Class getCommonConstantServiceName(boolean isPublished) {
        if (isPublished) {
            return IConstantVersionService.class;
        }
        return ICommonConstantService.class;
    }

    public Class getCommonStructureServiceName(boolean isPublished) {
        if (isPublished) {
            return IStructureVersionService.class;
        }
        return ICommonStructureService.class;
    }

    public Class getConnServiceName(boolean isPublished) {
        if (isPublished) {
            return IConnectionVersionService.class;
        }
        return ICommonConnectionService.class;
    }

    public Class getLogicServiceName(boolean isPublished) {
        if (isPublished) {
            return IEaiLogicVersionService.class;
        }
        return ICommonLogicService.class;
    }

    public Class getAuthServiceName(boolean isPublished) {
        return IEaiApplicationAuthService.class;
    }

    public void automaticConvertCanvas(AddApiInfoDto addApiInfoDto, EditApi editApi) {
        if (1 != this.eaiApiProperties.getLogicType()) {
            return;
        }
        if (HussarUtils.isEmpty((Object)editApi.getCanvasId())) {
            editApi.setCanvasId(EngineUtil.getId());
        }
        ArrayList paramsConvertList = Lists.newArrayListWithCapacity((int)5);
        if (null != addApiInfoDto.getInParams()) {
            this.getInParamsByHeaderAndQuery(addApiInfoDto.getInParams().getHeader(), paramsConvertList, addApiInfoDto.getInParams().getQuery());
            if (null != addApiInfoDto.getInParams().getBody()) {
                paramsConvertList.add(addApiInfoDto.getInParams().getBody());
            }
        }
        this.saveCanvasParams(paramsConvertList, addApiInfoDto.getApplicationCode(), addApiInfoDto.getApiCode(), addApiInfoDto.getId(), editApi);
        this.convertCanvasHandle(editApi, addApiInfoDto);
    }

    private void getInParamsByHeaderAndQuery(List<EaiParamsItems> addApiInfoDto, List<EaiParamsItems> paramsConvertList, List<EaiParamsItems> addApiInfoDto1) {
        if (CollectionUtil.isNotEmpty(addApiInfoDto)) {
            paramsConvertList.addAll(addApiInfoDto);
        }
        if (CollectionUtil.isNotEmpty(addApiInfoDto1)) {
            paramsConvertList.addAll(addApiInfoDto1);
        }
    }

    public void automaticConvertCanvas(AddBodyListApiInfoDto addApiInfoDto, EditApi editApi) {
        if (1 != this.eaiApiProperties.getLogicType()) {
            return;
        }
        if (HussarUtils.isEmpty((Object)editApi.getCanvasId())) {
            editApi.setCanvasId(EngineUtil.getId());
        }
        ArrayList paramsConvertList = Lists.newArrayListWithCapacity((int)5);
        if (null != addApiInfoDto.getListInParams()) {
            this.getInParamsByHeaderAndQuery(addApiInfoDto.getListInParams().getHeader(), paramsConvertList, addApiInfoDto.getListInParams().getQuery());
            if (null != addApiInfoDto.getListInParams().getBody()) {
                paramsConvertList.addAll(addApiInfoDto.getListInParams().getBody());
            }
        }
        this.saveCanvasParams(paramsConvertList, addApiInfoDto.getApplicationCode(), addApiInfoDto.getApiCode(), addApiInfoDto.getId(), editApi);
        this.convertCanvasHandle(editApi, addApiInfoDto);
    }

    private void saveCanvasParams(List<EaiParamsItems> paramsConvertList, String applicationCode, String apiCode, String apiId, EditApi editApi) {
        if (CollectionUtil.isNotEmpty(paramsConvertList)) {
            for (EaiParamsItems param : paramsConvertList) {
                param.setMapping(Integer.valueOf(1));
            }
            String inParams = this.canvaParamsConvertService.convertInParamsStr(applicationCode, apiCode, paramsConvertList);
            ApiInfo updateApiInfo = new ApiInfo();
            updateApiInfo.setId(Long.valueOf(apiId));
            updateApiInfo.setInParams(inParams);
            this.apiInfoService.updateById((Object)updateApiInfo);
            editApi.setContentType(EaiContentType.APPLICATION_JSON.getTypeStr());
            editApi.setId(HussarUtils.isEmpty((Object)editApi.getId()) ? EngineUtil.getId() : editApi.getId());
            editApi.setInParams(this.canvaParamsConvertService.convertEditOutBodyParamsStr(inParams));
            editApi.setHttpMethod(EaiRequestTypeEnum.POST.getType());
        }
    }

    public void automaticConvertCanvas(AddApiInfoDto addApiInfoDto, ApiInfo apiInfo, EditApi editApi) {
        if (1 != this.eaiApiProperties.getLogicType()) {
            return;
        }
        if (HussarUtils.isEmpty((Object)editApi.getCanvasId())) {
            editApi.setCanvasId(EngineUtil.getId());
        }
        ArrayList paramsConvertList = Lists.newArrayListWithCapacity((int)5);
        if (null != addApiInfoDto.getInParams()) {
            if (CollectionUtil.isNotEmpty((Collection)addApiInfoDto.getInParams().getHeader())) {
                paramsConvertList.addAll(addApiInfoDto.getInParams().getHeader());
            }
            if (CollectionUtil.isNotEmpty((Collection)addApiInfoDto.getInParams().getQuery())) {
                paramsConvertList.addAll(addApiInfoDto.getInParams().getQuery());
            }
            if (null != addApiInfoDto.getInParams().getBody()) {
                paramsConvertList.add(addApiInfoDto.getInParams().getBody());
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)paramsConvertList)) {
            for (EaiParamsItems param : paramsConvertList) {
                param.setMapping(Integer.valueOf(1));
            }
            String inParams = this.canvaParamsConvertService.convertInParamsStr(apiInfo.getApplicationCode(), apiInfo.getApiCode(), (List)paramsConvertList);
            apiInfo.setInParams(inParams);
            editApi.setContentType(EaiContentType.APPLICATION_JSON.getTypeStr());
            editApi.setId(HussarUtils.isEmpty((Object)editApi.getId()) ? EngineUtil.getId() : editApi.getId());
            editApi.setInParams(this.canvaParamsConvertService.convertEditOutBodyParamsStr(inParams));
            editApi.setHttpMethod(EaiRequestTypeEnum.POST.getType());
        }
        this.convertCanvasHandle(editApi, addApiInfoDto);
    }

    private void convertCanvasHandle(EditApi editApi, AddApiInfoDto addApiInfoDto) {
        HttpGenerateCanvasInfoDto httpGenerateCanvasInfo = new HttpGenerateCanvasInfoDto();
        BeanUtil.copy((Object)addApiInfoDto, (Object)((Object)httpGenerateCanvasInfo));
        ApiCanvasInfo apiCanvasInfo = this.generateCanvasTemplateService.convertCanvasInfo((GenerateCanvasCommonInfoDto)httpGenerateCanvasInfo, "0");
        this.saveCanvas(editApi, addApiInfoDto.getApiEventrelates(), apiCanvasInfo);
    }

    private void convertCanvasHandle(EditApi editApi, AddBodyListApiInfoDto addApiInfoDto) {
        HttpGenerateCanvasInfoDto httpGenerateCanvasInfo = new HttpGenerateCanvasInfoDto();
        BeanUtil.copy((Object)addApiInfoDto, (Object)((Object)httpGenerateCanvasInfo));
        ApiCanvasInfo apiCanvasInfo = this.generateCanvasTemplateService.convertCanvasInfo((GenerateCanvasCommonInfoDto)httpGenerateCanvasInfo, "0");
        this.saveCanvas(editApi, addApiInfoDto.getApiEventrelates(), apiCanvasInfo);
    }

    public ApiResponse automaticConvertCanvasCheck(Long apiId) {
        if (1 == this.eaiApiProperties.getLogicType()) {
            ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)apiId);
            if (HussarUtils.isEmpty((Object)apiInfo)) {
                return ApiResponse.fail((String)"\u672a\u67e5\u8be2\u5230\u8d44\u6e90\u4fe1\u606f!");
            }
            if (WEBSERVICE_APITYPE.equals(apiInfo.getApiType())) {
                return ApiResponse.success();
            }
            EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiId));
            boolean automaticConvertFlag = false;
            if (StringUtil.isEmpty((Object)editApi.getCanvasId())) {
                automaticConvertFlag = true;
            } else if (null == this.canvasInfoService.getById((Serializable)editApi.getCanvasId())) {
                automaticConvertFlag = true;
            }
            if (automaticConvertFlag) {
                LOGGER.info("{}\u9700\u8981\u81ea\u52a8\u8f6c\u6210\u753b\u5e03\u4fe1\u606f", (Object)apiInfo.getApiName());
                EditApi editApiUpdate = new EditApi();
                editApiUpdate.setId(editApi.getId());
                editApiUpdate.setCanvasId(EngineUtil.getId());
                editApi.setCanvasId(editApiUpdate.getCanvasId());
                this.iEaiEditApiService.updateById((Object)editApiUpdate);
                AddApiInfoDto addApiInfoDto = this.addApiInfoPackage(apiInfo, editApi);
                this.automaticConvertCanvas(addApiInfoDto, editApi);
                this.iEaiEditApiService.saveOrUpdate((Object)editApi);
            }
        }
        return ApiResponse.success();
    }

    private AddApiInfoDto addApiInfoPackage(ApiInfo apiInfo, EditApi editApi) {
        AddApiInfoDto addApiInfoDto = new AddApiInfoDto();
        addApiInfoDto.setId(String.valueOf(apiInfo.getId()));
        addApiInfoDto.setApiName(apiInfo.getApiName());
        addApiInfoDto.setApplicationCode(apiInfo.getApplicationCode());
        addApiInfoDto.setApiCode(apiInfo.getApiCode());
        addApiInfoDto.setApiPath(apiInfo.getApiPath());
        addApiInfoDto.setRemark(apiInfo.getRemark());
        addApiInfoDto.setTestState(apiInfo.getTestState());
        addApiInfoDto.setApiType(apiInfo.getApiType());
        addApiInfoDto.setPublicState(apiInfo.getPublicState());
        addApiInfoDto.setApiEditPath(editApi.getApiPath());
        addApiInfoDto.setHttpMethod(editApi.getHttpMethod());
        addApiInfoDto.setContentType(editApi.getContentType());
        EaiParamsConvertDto inParams = ParamsConvertUtil.toEaiParamsConvertDto((String)apiInfo.getInParams());
        addApiInfoDto.setInParams(inParams);
        EaiParamsConvertDto outParams = ParamsConvertUtil.toEaiParamsConvertDto((String)apiInfo.getOutParams());
        addApiInfoDto.setOutParams(outParams);
        return addApiInfoDto;
    }

    private void saveCanvas(EditApi editApi, Map<String, Integer> apiEventrelates, ApiCanvasInfo apiCanvasInfo) {
        boolean canvas;
        if (0 == this.eaiApiProperties.getLogicType()) {
            return;
        }
        this.eaiCanvasInfoService.deleteApiCanvasInfo(editApi);
        CanvasInfo canvasInfo = new CanvasInfo();
        canvasInfo.setId(editApi.getCanvasId());
        if (HussarUtils.isNotEmpty((Object)apiCanvasInfo)) {
            canvasInfo.setCanvasContent(JSON.toJSONString((Object)apiCanvasInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect}));
            canvasInfo.setCanvasResources(EaiCanvasServiceImpl.toJSONString(apiCanvasInfo.getRelateFiles()));
        }
        if (StringUtil.isNotEmpty(apiEventrelates)) {
            canvasInfo.setApiCodes(EaiCanvasServiceImpl.toJSONString(apiEventrelates));
        }
        if (!(canvas = this.canvasInfoService.save((Object)canvasInfo))) {
            throw new BaseException(ERROR);
        }
    }

    protected static String toJSONString(Object t) {
        return JSON.toJSONString((Object)JSON.toJSON((Object)t));
    }
}

