/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.publishresource.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.dto.EaiPublishCommonResources;
import com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.manager.CommonResourceManager;
import com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.publishresource.service.IEaiResourcePublishService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonStructureVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.StructureItemsVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.applicationrelease.publish.manager.impl.EaiResourcePublishServiceImpl")
public class EaiResourcePublishServiceImpl
extends CommonResourceManager
implements IEaiResourcePublishService {
    @Autowired
    IHttpAuthenticationService authenticationService;
    @Resource
    private ICommonConstantService commonConstantService;
    @Resource
    private ICommonStructureService commonStructureService;
    @Resource
    private EaiCommonStructureService eaiCommonStructureService;
    @Resource
    protected IEaiApiInfoService eaiApiInfoService;
    private static final int MAX_PAGE = 5000;
    private static final String cache_key = "eai_api_cache_key";
    @Resource
    ISysApplicationService applicationService;
    @Resource
    IEaiHttpTemplateService eaiHttpTemplateService;
    private static final String STRUCTURE_ERROR = "\u5f85\u53d1\u5e03\u7684\u6570\u636e\u7ed3\u6784\u914d\u7f6e\u4fe1\u606f\u5df2\u88ab\u5220\u9664\uff0c\u6570\u636e\u7ed3\u6784\u540d\u79f0:\u3010%s\u3011,\u6570\u636e\u7ed3\u6784\u6807\u8bc6\u3010%s\u3011";
    private static final String STRUCTURE_DELETED_ERROR = "\u5f85\u53d1\u5e03\u7684\u6570\u636e\u7ed3\u6784\u5df2\u88ab\u5220\u9664\uff0c\u6570\u636e\u7ed3\u6784id:\u3010%s\u3011";

    @Override
    public EaiPublishCommonResources getCommonResourcesByApi(Map<String, String> apiInfos, String applicationCode, String appVersion) {
        EaiPublishCommonResources eaiPublishCommonResources = new EaiPublishCommonResources();
        if (HussarUtils.isEmpty(apiInfos)) {
            return eaiPublishCommonResources;
        }
        ArrayList ids = new ArrayList();
        apiInfos.forEach((k, v) -> {
            List eaiParamsItems = ParamsConvertUtil.toEaiParamsItems((String)v);
            this.getIds(eaiParamsItems, ids);
        });
        if (HussarUtils.isNotEmpty(ids)) {
            List commonStructures = this.commonStructureService.listByIds(ids);
            ArrayList structureVersions = new ArrayList(commonStructures.size());
            commonStructures.forEach(commonStructure -> {
                StructureVersion structureVersion = this.commonStructureToVersion((CommonStructure)commonStructure, appVersion);
                structureVersions.add(structureVersion);
            });
            if (HussarUtils.isNotEmpty(structureVersions)) {
                Map<Long, Long> versiionIds = structureVersions.stream().collect(Collectors.toMap(StructureVersion::getStructureId, StructureVersion::getId));
                HashMap map = new HashMap();
                apiInfos.forEach((k, v) -> {
                    List eaiParamsItems = ParamsConvertUtil.toEaiParamsItems((String)v);
                    this.resetIds(eaiParamsItems, versiionIds);
                    map.put(k, ParamsConvertUtil.toJSONString((Object)eaiParamsItems));
                });
                eaiPublishCommonResources.setConvertParams(map);
                structureVersions.forEach(structureVersion -> versiionIds.forEach((k, v) -> {
                    if (k.equals(structureVersion.getStructureId())) {
                        structureVersion.setStructureValues(this.cheangNewIds(String.valueOf(k), versiionIds));
                    }
                }));
                eaiPublishCommonResources.setInsertStructures(structureVersions);
            }
        }
        return eaiPublishCommonResources;
    }

    private void resetIds(List<EaiParamsItems> eaiParamsItems, Map<Long, Long> ids) {
        eaiParamsItems.forEach(eaiParamsItem -> {
            String id = eaiParamsItem.getQuoteStructureId();
            if (HussarUtils.isNotEmpty((Object)id) && ids.containsKey(Long.valueOf(id))) {
                eaiParamsItem.setQuoteStructureId(String.valueOf(ids.get(Long.valueOf(id))));
            }
            if (HussarUtils.isNotEmpty((Object)eaiParamsItem.getItems())) {
                this.resetIds(eaiParamsItem.getItems(), ids);
            }
        });
    }

    private void getIds(List<EaiParamsItems> eaiParamsItems, List<Long> ids) {
        eaiParamsItems.forEach(eaiParamsItem -> {
            if (HussarUtils.isNotEmpty((Object)eaiParamsItem.getQuoteStructureId()) && !ids.contains(Long.valueOf(eaiParamsItem.getQuoteStructureId()))) {
                ids.add(Long.valueOf(eaiParamsItem.getQuoteStructureId()));
            }
            if (HussarUtils.isNotEmpty((Object)eaiParamsItem.getItems())) {
                this.getIds(eaiParamsItem.getItems(), ids);
            }
        });
    }

    @Override
    public EaiPublishCommonResources getCommonResourcesByEventId(List<Long> eventId, String appVersion) {
        EaiPublishCommonResources eaiPublishCommonResources = new EaiPublishCommonResources();
        return eaiPublishCommonResources;
    }

    @Override
    public EaiPublishCommonResources getCommonResourcesByAuthHttp(EaiHttpAuthDto eaiHttpAuthDto, String appVersion) {
        List eaiParamsPositions;
        EaiPublishCommonResources eaiPublishCommonResources = new EaiPublishCommonResources();
        List eaiHttpVerifyDtos = eaiHttpAuthDto.getEaiHttpVerifyDtos();
        HashMap list = new HashMap(8);
        if (HussarUtils.isNotEmpty((Object)eaiHttpVerifyDtos)) {
            eaiHttpVerifyDtos.forEach(eaiHttpVerifyDto -> {
                List eaiHttpParams = eaiHttpVerifyDto.getHttpParams();
                this.addToList(eaiHttpParams, list);
                eaiHttpVerifyDto.setHttpParams(eaiHttpParams);
            });
        }
        if (HussarUtils.isNotEmpty((Object)(eaiParamsPositions = eaiHttpAuthDto.getEaiParamsPosition()))) {
            eaiParamsPositions.forEach(paramsPosition -> {
                List httpParams;
                String eaiHttpParams = paramsPosition.getEffective();
                if (HussarUtils.isNotEmpty((Object)eaiHttpParams) && HussarUtils.isNotEmpty((Object)(httpParams = JSON.parseArray((String)eaiHttpParams, EaiHttpParams.class)))) {
                    httpParams.forEach(httpParam -> {
                        if ("1".equals(httpParam.getParamsFrom())) {
                            Long oldId = Long.valueOf(httpParam.getParamsValue());
                            Long newId = IdGenerateUtils.getId();
                            if (!list.containsKey(oldId)) {
                                httpParam.setParamsValue(String.valueOf(newId));
                                list.put(oldId, newId);
                            } else {
                                httpParam.setParamsValue(String.valueOf(list.get(oldId)));
                            }
                        }
                    });
                    paramsPosition.setEffective(JSON.toJSONString((Object)httpParams));
                }
            });
            eaiHttpAuthDto.setEaiParamsPosition(eaiParamsPositions);
        }
        if (HussarUtils.isNotEmpty(list)) {
            List commonConstants = this.commonConstantService.listByIds(new ArrayList(list.keySet()));
            ArrayList constantVersions = new ArrayList();
            commonConstants.forEach(commonConstant -> {
                ConstantVersion version = this.commonConstantsToVersion((CommonConstant)commonConstant, appVersion, list);
                constantVersions.add(version);
            });
            eaiPublishCommonResources.setInsertConstants(constantVersions);
        }
        eaiPublishCommonResources.setAuthParams(eaiHttpAuthDto);
        return eaiPublishCommonResources;
    }

    @Override
    public EaiPublishCommonResources getCommonResourcesByAuthCode(String applicationCode, String appVersion) {
        EaiPublishCommonResources eaiPublishCommonResources = new EaiPublishCommonResources();
        ApiResponse response = this.authenticationService.selectHttpTemplateInfos(applicationCode, false);
        EaiHttpAuthDto templateVo = (EaiHttpAuthDto)response.getData();
        if (HussarUtils.isNotEmpty((Object)templateVo)) {
            HashMap list = new HashMap(8);
            List list2 = templateVo.getEaiHttpVerifyDtos();
        }
        return eaiPublishCommonResources;
    }

    @Override
    public Map<String, List<ApiInfo>> apiInfoList(String applicationCode, boolean isAudit) {
        List list;
        HashMap<String, List<ApiInfo>> map = new HashMap<String, List<ApiInfo>>();
        LambdaQueryWrapper apiWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)applicationCode)).ne(ApiInfo::getDraftState, (Object)"1")).eq(ApiInfo::getPublicState, (Object)"1");
        if (isAudit) {
            apiWrapper.eq(ApiInfo::getApplyState, (Object)"1");
        }
        long i = this.eaiApiInfoService.count((Wrapper)apiWrapper);
        map.put("insert", new ArrayList(0));
        if (i > 0L) {
            int initialCapacity = i > 5000L ? 5000 : 64;
            List apiInfos = new ArrayList(initialCapacity);
            if (i > 0L && i <= 5000L) {
                apiInfos = this.eaiApiInfoService.list((Wrapper)apiWrapper);
            } else {
                long k = i / 5000L;
                if (i % 5000L > 0L) {
                    ++k;
                }
                int j = 0;
                while ((long)j < k) {
                    IPage list2 = this.eaiApiInfoService.page((IPage)new Page((long)(j * 5000), 5000L), (Wrapper)apiWrapper);
                    apiInfos.addAll(list2.getRecords());
                    ++j;
                }
            }
            map.put("insert", apiInfos);
        }
        LambdaQueryWrapper apiWrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)apiWrapper2.eq(ApiInfo::getApplicationCode, (Object)applicationCode)).eq(ApiInfo::getApiState, (Object)"1")).eq(ApiInfo::getPublicState, (Object)"0");
        if (isAudit) {
            apiWrapper2.eq(ApiInfo::getApplyState, (Object)"1");
        }
        if (HussarUtils.isNotEmpty((Object)(list = this.eaiApiInfoService.list((Wrapper)apiWrapper2)))) {
            map.put("update", list);
        }
        return map;
    }

    @Override
    @HussarTransactional(rollbackFor={Exception.class})
    public boolean unlocked(List<Long> apiIds, List<Long> eventIds, String applicationCode) {
        this.changeState(apiIds, eventIds, applicationCode, false);
        return true;
    }

    @Override
    @HussarTransactional(rollbackFor={Exception.class})
    public boolean locked(List<Long> apiIds, List<Long> eventIds, String applicationCode) {
        this.changeState(apiIds, eventIds, applicationCode, true);
        return true;
    }

    private void changeState(List<Long> apiIds, List<Long> eventIds, String applicationCode, boolean locked) {
        this.changeState(apiIds, eventIds, applicationCode, locked, "1");
    }

    @Override
    @HussarTransactional(rollbackFor={Exception.class})
    public void reJectChangeState(List<Long> apiIds, List<Long> eventIds, String applicationCode) {
        this.changeState(apiIds, eventIds, applicationCode, false, "0");
    }

    private void changeState(List<Long> apiIds, List<Long> eventIds, String applicationCode, boolean locked, String templateType) {
        LambdaUpdateWrapper updateWrapper;
        String apiState = "1";
        String appState = "2";
        if (!locked) {
            apiState = "0";
            appState = "1";
            LambdaUpdateWrapper queryWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).isNotNull(EaiHttpTemplate::getTemplateType)).set(EaiHttpTemplate::getTemplateType, (Object)templateType);
            this.eaiHttpTemplateService.update((Object)new EaiHttpTemplate(), (Wrapper)queryWrapper);
        }
        if (HussarUtils.isNotEmpty((Object)applicationCode) && apiIds == null) {
            List<ApiInfo> apiInfos;
            apiIds = new ArrayList<Long>();
            StringBuffer sb = new StringBuffer(24);
            sb.append(cache_key).append(":").append(applicationCode);
            String key = sb.toString();
            Map<String, List<ApiInfo>> apiInfosMap = HussarCacheUtil.containKey((String)cache_key, (Object)key) ? (Map<String, List<ApiInfo>>)HussarCacheUtil.get((String)cache_key, (Object)key) : this.apiInfoList(applicationCode, !locked);
            if (HussarUtils.isNotEmpty(apiInfosMap.get("insert")) && HussarUtils.isNotEmpty(apiInfos = apiInfosMap.get("insert"))) {
                apiIds.addAll(apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList()));
            }
            if (HussarUtils.isNotEmpty(apiInfosMap.get("update")) && HussarUtils.isNotEmpty(apiInfos = apiInfosMap.get("update"))) {
                apiIds.addAll(apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList()));
            }
        }
        if (HussarUtils.isNotEmpty((Object)applicationCode)) {
            LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).set(SysApplication::getAppStatus, (Object)appState);
            this.applicationService.update((Wrapper)wrapper);
        }
        if (HussarUtils.isNotEmpty(apiIds)) {
            updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ApiInfo::getApplyState, (Object)apiState)).in(ApiInfo::getId, apiIds);
            this.eaiApiInfoService.update((Wrapper)updateWrapper);
            StringBuffer sb = new StringBuffer(24);
            sb.append(cache_key).append(":").append(applicationCode);
            String key = sb.toString();
            HussarCacheUtil.evict((String)cache_key, (Object)key);
        } else if (!locked && HussarUtils.isNotEmpty((Object)applicationCode)) {
            updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ApiInfo::getApplyState, (Object)apiState)).eq(ApiInfo::getApplicationCode, (Object)applicationCode);
            this.eaiApiInfoService.update((Wrapper)updateWrapper);
        }
    }

    private void fillStructureItem(List<StructureItemsVo> list, Map<Long, Long> versiionIds) {
        list.forEach(item -> {
            item.setNowStructureId(null);
            versiionIds.forEach((k, v) -> {
                if (String.valueOf(k).equals(item.getQuoteStructureId())) {
                    item.setQuoteStructureId(String.valueOf(v));
                }
            });
            if (HussarUtils.isNotEmpty((Object)item.getItems())) {
                this.fillStructureItem(item.getItems(), versiionIds);
            }
        });
    }

    private String cheangNewIds(String structureId, Map<Long, Long> versiionIds) {
        CommonStructureVo commonStructureVo = this.eaiCommonStructureService.getById(structureId);
        if (HussarUtils.isEmpty((Object)commonStructureVo)) {
            throw new BaseException(String.format(STRUCTURE_DELETED_ERROR, structureId));
        }
        List list = commonStructureVo.getStructureValues();
        if (HussarUtils.isEmpty((Object)list)) {
            throw new BaseException(String.format(STRUCTURE_ERROR, commonStructureVo.getStructureName(), commonStructureVo.getStructureCode()));
        }
        this.fillStructureItem(list, versiionIds);
        return JSON.toJSONString((Object)list);
    }

    private StructureVersion commonStructureToVersion(CommonStructure commonStructure, String appVersion) {
        StructureVersion structureVersion = new StructureVersion();
        structureVersion.setId(IdGenerateUtils.getId());
        structureVersion.setStructureId(commonStructure.getId());
        structureVersion.setStructureClassify(commonStructure.getStructureClassify());
        structureVersion.setStructureCode(commonStructure.getStructureCode());
        structureVersion.setStructureName(commonStructure.getStructureName());
        structureVersion.setStructureVersion(appVersion);
        structureVersion.setApplicationCode(commonStructure.getApplicationCode());
        structureVersion.setParamsType(commonStructure.getParamsType());
        structureVersion.setRemark(commonStructure.getRemark());
        structureVersion.setCreateBy(commonStructure.getCreateBy());
        structureVersion.setEditBy(commonStructure.getEditBy());
        structureVersion.setCreateTime(commonStructure.getCreateTime());
        structureVersion.setCreator(commonStructure.getCreator());
        structureVersion.setLastEditor(commonStructure.getLastEditor());
        structureVersion.setLastTime(commonStructure.getLastTime());
        return structureVersion;
    }

    private ConstantVersion commonConstantsToVersion(CommonConstant commonConstant, String appVersion, Map<Long, Long> list) {
        ConstantVersion constantVersion = new ConstantVersion();
        Long id = commonConstant.getId();
        list.forEach((k, v) -> {
            if (k.equals(id)) {
                constantVersion.setId(v);
            }
        });
        constantVersion.setConstantId(id);
        constantVersion.setConstantClassify(commonConstant.getConstantClassify());
        constantVersion.setConstantName(commonConstant.getConstantName());
        constantVersion.setConstantNameEn(commonConstant.getConstantNameEn());
        constantVersion.setConstantValue(commonConstant.getConstantValue());
        constantVersion.setConstantVersion(appVersion);
        constantVersion.setApplicationCode(commonConstant.getApplicationCode());
        constantVersion.setCreateBy(commonConstant.getCreateBy());
        constantVersion.setCreateTime(commonConstant.getCreateTime());
        constantVersion.setCreator(commonConstant.getCreator());
        constantVersion.setLastEditor(commonConstant.getLastEditor());
        constantVersion.setLastTime(commonConstant.getLastTime());
        return constantVersion;
    }
}

