/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.manager;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.dto.EaiPublishApiInfos;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.dto.EaiPublishCommonResources;
import com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.apiresource.service.IEaiApiResourceService;
import com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.publishresource.service.IEaiResourcePublishService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApply;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApplyRecord;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyRecordService;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.common.util.EaiVersionUtil;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IConnectionVersionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IEaiLogicVersionService;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.choreo.api.dto.ApiNamingDto;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiPm;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.integration.plugin.rmi.enums.RequestTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;

public class EaiPublishManager {
    @Resource
    protected IEaiHttpTemplateService eaiHttpTemplateService;
    @Resource
    protected ISysApplicationService applicationService;
    @Resource
    protected EngineBussnessdataConfigService engineBussnessdataConfigService;
    @Resource
    protected IEaiResourcePublishService eaiResourcePublishService;
    @Resource
    protected IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    protected IEaiApplyService applyService;
    @Resource
    protected IEaiApiInfoService eaiApiInfoService;
    @Resource
    protected IEaiApiResourceService eaiApiResourceService;
    protected static final String cache_key = "eai_api_cache_key";
    @Resource
    private IConstantVersionService constantVersionService;
    @Resource
    IConnectionVersionService connectionVersionService;
    @Resource
    private IStructureVersionService eaiStructureVersionService;
    @Resource
    IEaiLogicVersionService logicVersionService;
    @Resource
    protected IHttpAuthenticationService authenticationService;
    @Resource
    private IApiVersionService apiVersionService;
    @Resource
    IEaiApplyRecordService applyRecordService;
    @Resource
    IApiCallSpecificationInfoService callSpecificationInfoService;

    protected SysApplication lockApp(String applicationCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).eq(SysApplication::getAppStatus, (Object)"1");
        SysApplication sysApplication = (SysApplication)this.applicationService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)sysApplication)) {
            throw new BaseException("\u53d1\u5e03\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u68c0\u67e5\u6743\u9650\u540e\u91cd\u8bd5");
        }
        if ("2".equals(sysApplication.getAppStatus())) {
            throw new BaseException("\u53d1\u5e03\u5931\u8d25\uff01\u5e94\u7528\u5b58\u5728\u672a\u7ed3\u675f\u6d41\u7a0b");
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).eq(EaiHttpTemplate::getTemplateType, (Object)"0")).isNotNull(EaiHttpTemplate::getTemplateType)).set(EaiHttpTemplate::getTemplateType, (Object)"2");
        this.eaiHttpTemplateService.update((Object)new EaiHttpTemplate(), (Wrapper)updateWrapper);
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).set(SysApplication::getAppStatus, (Object)"2");
        this.applicationService.update((Wrapper)wrapper);
        return sysApplication;
    }

    protected String initPublish(String applicationCode) {
        AssertUtil.isNotEmpty((String)applicationCode, (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper versionQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)applicationCode);
        SysApplication sysApplication = (SysApplication)this.applicationService.getOne((Wrapper)versionQueryWrapper);
        String appVersion = EaiVersionUtil.getInstance().getNewVersion(sysApplication.getAppVersion());
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).set(SysApplication::getAppVersion, (Object)appVersion);
        this.applicationService.update((Wrapper)updateWrapper);
        return appVersion;
    }

    protected List<Boolean> authCheck(String applicationCode) {
        ArrayList<Boolean> list = new ArrayList<Boolean>(2);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.eq(EaiHttpTemplate::getTemplateType, (Object)"2");
        });
        EaiHttpTemplate eaiHttpTemplate = (EaiHttpTemplate)this.eaiHttpTemplateService.getOne((Wrapper)queryWrapper);
        boolean withAuth = false;
        boolean updateAuth = false;
        boolean isLogic = false;
        if (HussarUtils.isNotEmpty((Object)eaiHttpTemplate) && eaiHttpTemplate.getTemplateId() > 0L) {
            isLogic = "4".equals(eaiHttpTemplate.getTemplateType());
            withAuth = true;
            LambdaQueryWrapper hasPublishedWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).isNull(EaiHttpTemplate::getTemplateType);
            EaiHttpTemplate template = (EaiHttpTemplate)this.eaiHttpTemplateService.getOne((Wrapper)hasPublishedWrapper);
            if (HussarUtils.isNotEmpty((Object)template) && template.getTemplateId() > 0L) {
                updateAuth = true;
            }
        }
        list.add(withAuth);
        list.add(updateAuth);
        list.add(isLogic);
        return list;
    }

    protected EaiPublishApiInfos publishApiInfos(String applicationCode) {
        StringBuffer sb = new StringBuffer(24);
        sb.append(cache_key).append(":").append(applicationCode);
        String key = sb.toString();
        Map<String, List<ApiInfo>> apiInfosMap = HussarCacheUtil.containKey((String)cache_key, (Object)key) ? (Map<String, List<ApiInfo>>)HussarCacheUtil.get((String)cache_key, (Object)key) : this.eaiResourcePublishService.apiInfoList(applicationCode, true);
        List<ApiInfo> apiInfos = apiInfosMap.get("insert");
        List<ApiInfo> apiInfosUpdate = apiInfosMap.get("update");
        EaiPublishApiInfos eaiPublishApiInfos = new EaiPublishApiInfos();
        eaiPublishApiInfos.setApiInfos(apiInfos);
        eaiPublishApiInfos.setApiInfosUpdate(apiInfosUpdate);
        eaiPublishApiInfos.setKey(key);
        return eaiPublishApiInfos;
    }

    protected void changeApiStateToOnGround(List<Long> apiIds) {
        LambdaUpdateWrapper updateApiState = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(ApiInfo::getId, apiIds)).set(ApiInfo::getDraftState, (Object)"1")).set(ApiInfo::getApiState, (Object)"1");
        this.eaiApiInfoService.update((Wrapper)updateApiState);
    }

    protected void changeApiStateToOffGround(List<Long> apiIds) {
        LambdaUpdateWrapper updateApiState = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(ApiInfo::getId, apiIds)).set(ApiInfo::getApiState, (Object)"0");
        this.eaiApiInfoService.update((Wrapper)updateApiState);
    }

    protected void publishConstants(List<ConstantVersion> commonConstants, String appVersion) {
        if (HussarUtils.isNotEmpty(commonConstants)) {
            commonConstants.forEach(constant -> constant.setConstantVersion(appVersion));
            this.constantVersionService.saveBatch(commonConstants);
        }
    }

    protected void publishConnectionVersions(List<ConnectionVersion> connectionVersions, String appVersion) {
        if (HussarUtils.isNotEmpty(connectionVersions)) {
            connectionVersions.forEach(connectionVersion -> connectionVersion.setConnVersion(appVersion));
            this.connectionVersionService.saveBatch(connectionVersions);
        }
    }

    protected void publishStructs(List<StructureVersion> commonStructures, String appVersion) {
        if (HussarUtils.isNotEmpty(commonStructures)) {
            commonStructures.forEach(commonStructure -> commonStructure.setStructureVersion(appVersion));
            this.eaiStructureVersionService.saveBatch(commonStructures);
        }
    }

    protected void publishLogicVersions(List<LogicVersion> logicVersions, String appVersion) {
        if (HussarUtils.isNotEmpty(logicVersions)) {
            logicVersions.forEach(logicVersion -> logicVersion.setLogicVersion(appVersion));
            this.logicVersionService.saveBatch(logicVersions);
        }
    }

    protected EaiPublishCommonResources authWithTemplete(String applicationCode, Boolean withAuth, Boolean updateAuth, String appVersion) {
        EaiPublishCommonResources authResources = null;
        if (withAuth.booleanValue()) {
            ApiResponse response = this.authenticationService.selectHttpTemplateInfosPublishingWithNewIds(applicationCode);
            EaiHttpAuthDto publishing = (EaiHttpAuthDto)response.getData();
            authResources = this.eaiResourcePublishService.getCommonResourcesByAuthHttp(publishing, appVersion);
            if (HussarUtils.isNotEmpty((Object)publishing)) {
                publishing = authResources.getAuthParams();
                publishing.getEaiHttpTemplate().setTemplateType(null);
                if (updateAuth.booleanValue()) {
                    this.authenticationService.updateHttpTemplateInfos(publishing);
                } else {
                    this.authenticationService.saveHttpTemplateInfos(publishing);
                }
            }
        }
        return authResources;
    }

    protected void changeAppState(String applicationCode, List<Long> allIds, String key, Boolean withAuth) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).set(SysApplication::getReleaseStatus, (Object)"1");
        this.applicationService.update((Wrapper)wrapper);
        this.eaiResourcePublishService.unlocked(allIds, null, applicationCode);
        if (HussarUtils.isNotEmpty((Object)key)) {
            HussarCacheUtil.evict((String)cache_key, (Object)key);
        }
        if (withAuth.booleanValue()) {
            HussarCacheUtil.evict((String)applicationCode, (Object)applicationCode);
        }
    }

    protected EaiPublishApiInfos publishApi(List<ApiInfo> apiInfos, String applicationCode, String appVersion, Map<String, String> idMappings) {
        EaiPublishApiInfos publishApiInfos = new EaiPublishApiInfos();
        ArrayList apiVersions = new ArrayList(apiInfos.size());
        HashMap editIds = new HashMap(apiInfos.size());
        ArrayList eaiResourcesInfos = new ArrayList(apiInfos.size());
        apiInfos.forEach(apiInfo -> {
            Long versionId = IdGenerateUtils.getId();
            EaiApiVersion eaiApiVersion = this.toEaiApiVersion(versionId, applicationCode, appVersion, (ApiInfo)apiInfo, idMappings);
            apiVersions.add(eaiApiVersion);
            editIds.put(apiInfo.getId(), versionId);
            EaiResourcesInfo eaiResourcesInfo = this.toEaiResourcesInfo(applicationCode, appVersion, eaiApiVersion);
            eaiResourcesInfo.setResourceId(IdGenerateUtils.getId());
            eaiResourcesInfos.add(eaiResourcesInfo);
        });
        this.eaiApiResourceService.saveResourceFromApi(apiInfos, applicationCode);
        if (HussarUtils.isNotEmpty(apiVersions)) {
            this.apiVersionService.saveBatch(apiVersions);
        }
        publishApiInfos.setEditIds(editIds);
        publishApiInfos.setEaiResourcesInfos(eaiResourcesInfos);
        publishApiInfos.setApiVersions(apiVersions);
        return publishApiInfos;
    }

    protected void publishResourcesInfo(List<EaiResourcesInfo> eaiResourcesInfos, List<Long> apiIds, List<ApiInfo> apiInfosUpdate, String appVersion) {
        LambdaQueryWrapper eQueryWrapper;
        List eaiApplyRecords;
        ArrayList update = new ArrayList();
        ArrayList<EaiResourcesInfo> insert = new ArrayList<EaiResourcesInfo>();
        if (HussarUtils.isNotEmpty(apiIds)) {
            LambdaQueryWrapper queryWrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"0")).in(EaiResourcesInfo::getResourceRelationId, apiIds);
            List published = this.eaiResourcesInfoService.list((Wrapper)queryWrapper1);
            if (HussarUtils.isNotEmpty((Object)published)) {
                eaiResourcesInfos.forEach(eaiResourcesInfo -> {
                    boolean isInsert = true;
                    for (EaiResourcesInfo publish : published) {
                        if (!publish.getResourceRelationId().equals(eaiResourcesInfo.getResourceRelationId())) continue;
                        eaiResourcesInfo.setResourceId(publish.getResourceId());
                        eaiResourcesInfo.setApplicationVersion(appVersion);
                        eaiResourcesInfo.setDeleteState("0");
                        update.add(eaiResourcesInfo);
                        isInsert = false;
                        break;
                    }
                    if (isInsert) {
                        eaiResourcesInfo.setResourceId(IdGenerateUtils.getId());
                        eaiResourcesInfo.setApplicationVersion(appVersion);
                        eaiResourcesInfo.setDeleteState("0");
                        insert.add((EaiResourcesInfo)eaiResourcesInfo);
                    }
                });
            } else {
                eaiResourcesInfos.forEach(eaiResourcesInfo -> {
                    eaiResourcesInfo.setApplicationVersion(appVersion);
                    eaiResourcesInfo.setDeleteState("0");
                });
                insert.addAll(eaiResourcesInfos);
            }
        }
        if (HussarUtils.isNotEmpty(insert)) {
            this.eaiResourcesInfoService.saveBatch(insert);
        }
        ArrayList restIds = new ArrayList();
        if (HussarUtils.isNotEmpty(apiInfosUpdate)) {
            ArrayList delIds = new ArrayList(apiInfosUpdate.size());
            apiInfosUpdate.forEach(apiInfo -> delIds.add(apiInfo.getId()));
            restIds.addAll(delIds);
            LambdaUpdateWrapper delWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"0")).in(EaiResourcesInfo::getResourceRelationId, delIds)).set(EaiResourcesInfo::getDeleteState, (Object)"1");
            this.eaiResourcesInfoService.update((Wrapper)delWrapper);
        }
        if (HussarUtils.isNotEmpty(update)) {
            this.eaiResourcesInfoService.updateBatchById(update);
            restIds.addAll(update.stream().map(EaiResourcesInfo::getResourceRelationId).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty(restIds) && HussarUtils.isNotEmpty((Object)(eaiApplyRecords = this.applyRecordService.list((Wrapper)(eQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiApplyRecord::getResourceId, restIds)))))) {
            List applyIds = eaiApplyRecords.stream().map(EaiApplyRecord::getRecordId).collect(Collectors.toList());
            LambdaUpdateWrapper applyWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(EaiApply::getResourceId, applyIds)).eq(EaiApply::getResourceStatus, (Object)"0")).set(EaiApply::getApproveRemark, (Object)"\u60a8\u7533\u8bf7\u7684\u63a5\u53e3\u5df2\u4e0b\u67b6")).set(EaiApply::getResourceStatus, (Object)"2");
            this.applyService.update((Wrapper)applyWrapper);
        }
    }

    protected void publishResourcesInfoQddt(List<EaiResourcesInfo> eaiResourcesInfos, List<Long> apiIds, List<ApiInfo> apiInfosUpdate, String appVersion) {
        ArrayList update = new ArrayList();
        ArrayList<EaiResourcesInfo> insert = new ArrayList<EaiResourcesInfo>();
        if (HussarUtils.isNotEmpty(apiIds)) {
            LambdaQueryWrapper queryWrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"0")).in(EaiResourcesInfo::getResourceRelationId, apiIds);
            List published = this.eaiResourcesInfoService.list((Wrapper)queryWrapper1);
            if (HussarUtils.isNotEmpty((Object)published)) {
                eaiResourcesInfos.forEach(eaiResourcesInfo -> {
                    boolean isInsert = true;
                    for (EaiResourcesInfo publish : published) {
                        if (!publish.getResourceRelationId().equals(eaiResourcesInfo.getResourceRelationId())) continue;
                        eaiResourcesInfo.setResourceId(publish.getResourceId());
                        eaiResourcesInfo.setApplicationVersion(appVersion);
                        eaiResourcesInfo.setDeleteState("0");
                        update.add(eaiResourcesInfo);
                        isInsert = false;
                        break;
                    }
                    if (isInsert) {
                        eaiResourcesInfo.setResourceId(IdGenerateUtils.getId());
                        eaiResourcesInfo.setApplicationVersion(appVersion);
                        eaiResourcesInfo.setDeleteState("0");
                        insert.add((EaiResourcesInfo)eaiResourcesInfo);
                    }
                });
            } else {
                eaiResourcesInfos.forEach(eaiResourcesInfo -> {
                    eaiResourcesInfo.setApplicationVersion(appVersion);
                    eaiResourcesInfo.setDeleteState("0");
                });
                insert.addAll(eaiResourcesInfos);
            }
        }
        if (HussarUtils.isNotEmpty(insert)) {
            this.eaiResourcesInfoService.saveBatch(insert);
        }
        if (HussarUtils.isNotEmpty(apiInfosUpdate)) {
            ArrayList delIds = new ArrayList(apiInfosUpdate.size());
            apiInfosUpdate.forEach(apiInfo -> delIds.add(apiInfo.getId()));
            LambdaUpdateWrapper delWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"0")).in(EaiResourcesInfo::getResourceRelationId, delIds)).set(EaiResourcesInfo::getDeleteState, (Object)"1");
            this.eaiResourcesInfoService.update((Wrapper)delWrapper);
        }
        if (HussarUtils.isNotEmpty(update)) {
            this.eaiResourcesInfoService.updateBatchById(update);
        }
    }

    protected void pushEngine(List<EaiApiVersion> apiVersions, String appVersion) {
        this.pushEngine(apiVersions, appVersion, null);
    }

    protected void pushEngine(List<EaiApiVersion> apiVersions, String appVersion, Map<Long, String> maps) {
        PushBackCtx pushBackCtx = new PushBackCtx();
        apiVersions.forEach(apiInfo -> {
            ApiNamingDto apiNamingDto = this.toApiNamingDto(appVersion, (EaiApiVersion)apiInfo);
            pushBackCtx.addApiNaming(apiNamingDto);
            NodeBusiness nodeBusiness = null;
            nodeBusiness = maps != null && maps.containsKey(apiInfo.getApiVersionId()) ? this.toNodeBusiness((EaiApiVersion)apiInfo, (String)maps.get(apiInfo.getApiVersionId())) : this.toNodeBusiness((EaiApiVersion)apiInfo);
            pushBackCtx.addNodeBusiness(nodeBusiness);
        });
        this.engineBussnessdataConfigService.pushApi(pushBackCtx);
    }

    protected void saveBaseCallInfo(List<EaiApiVersion> apiVersions) {
        List apiIds = apiVersions.stream().map(EaiApiVersion::getApiId).collect(Collectors.toList());
        List callInfos = this.callSpecificationInfoService.selectCallInfoListByApiIds(apiIds);
        Map<Long, List<ApiCallSpecificationInfo>> callInfosMap = callInfos.stream().collect(Collectors.groupingBy(ApiCallSpecificationInfo::getApiId));
        Map apiVersionMap = apiVersions.stream().collect(Collectors.toMap(EaiApiVersion::getApiId, Function.identity()));
        ArrayList infoAll = Lists.newArrayListWithCapacity((int)10);
        for (Map.Entry<Long, List<ApiCallSpecificationInfo>> entry : callInfosMap.entrySet()) {
            List<ApiCallSpecificationInfo> infoDtosT = entry.getValue();
            infoDtosT.forEach(info -> {
                info.setApiId(((EaiApiVersion)apiVersionMap.get(entry.getKey())).getApiVersionId());
                info.setSpecificatId(Long.valueOf(IdWorker.getId((Object)new ApiCallSpecificationInfo())));
            });
            infoAll.addAll(infoDtosT);
        }
        this.callSpecificationInfoService.saveBatch((Collection)infoAll);
    }

    protected NodeBusiness toNodeBusiness(EaiApiVersion apiInfo) {
        return this.toNodeBusiness(apiInfo, null);
    }

    protected NodeBusiness toNodeBusiness(EaiApiVersion apiInfo, String parse) {
        NodeBusiness nodeBusiness = new NodeBusiness();
        nodeBusiness.setNodeType(NodeTypeEnum.API.getValue());
        nodeBusiness.setNodeName(apiInfo.getApiCode());
        nodeBusiness.setNodeClass("com.jxdinfo.hussar.eai.common.server.applicationrelease.applicationauth.service.impl.IEaiHttpTemplateAuthServiceImpl");
        nodeBusiness.setActionName("apiInvoke");
        nodeBusiness.setDataServiceActionName("com.jxdinfo.hussar.eai.server.enginegain.service.impl.EaiGainParamsChangeServiceImpl");
        nodeBusiness.setDataServiceCode(String.valueOf(apiInfo.getApiVersionId()));
        nodeBusiness.setNodeId(apiInfo.getApiId());
        if (HussarUtils.isNotEmpty((Object)parse)) {
            nodeBusiness.setJsonParams(parse);
        }
        return nodeBusiness;
    }

    protected ApiNamingDto toApiNamingDto(String appVersion, EaiApiVersion apiInfo) {
        ApiNamingDto apiNamingDto = new ApiNamingDto();
        ApiPm apiPm = new ApiPm();
        apiPm.setParameterId(IdGenerateUtils.getId());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(RequestTypeEnum.POST.getType()).append(" ").append(apiInfo.getApiPath());
        apiPm.setBusinessId(stringBuilder.toString());
        apiPm.setHpeVersion(Integer.valueOf(Integer.parseInt(appVersion.substring(1))));
        apiPm.setCreateTime(apiInfo.getCreateTime());
        apiPm.setCreator(apiInfo.getCreator());
        apiPm.setLastEditor(apiInfo.getLastEditor());
        apiPm.setLastTime(apiInfo.getLastTime());
        apiNamingDto.setApiPm(apiPm);
        apiNamingDto.setBusinessName(apiInfo.getApiName());
        apiNamingDto.setId(IdGenerateUtils.getId());
        apiNamingDto.setBusinessId(stringBuilder.toString());
        apiNamingDto.setNewVersion(appVersion);
        apiNamingDto.setServiceId(apiInfo.getApiVersionId());
        apiNamingDto.setBusinessType("HTTP");
        apiNamingDto.setServiceName(apiInfo.getApiCode());
        return apiNamingDto;
    }

    protected EaiResourcesInfo toEaiResourcesInfo(String applicationCode, String appVersion, EaiApiVersion eaiApiVersion) {
        EaiResourcesInfo eaiResourcesInfo = new EaiResourcesInfo();
        eaiResourcesInfo.setApplicationCode(applicationCode);
        eaiResourcesInfo.setApplicationVersion(appVersion);
        eaiResourcesInfo.setResourceCode(eaiApiVersion.getApiCode());
        eaiResourcesInfo.setResourceRelationId(eaiApiVersion.getApiId());
        eaiResourcesInfo.setResourceVersionId(eaiApiVersion.getApiVersionId());
        eaiResourcesInfo.setResourceName(eaiApiVersion.getApiName());
        eaiResourcesInfo.setResourceType("1");
        eaiResourcesInfo.setCreator(eaiApiVersion.getCreator());
        eaiResourcesInfo.setCreateTime(eaiApiVersion.getCreateTime());
        eaiResourcesInfo.setLastEditor(eaiApiVersion.getLastEditor());
        eaiResourcesInfo.setLastTime(eaiApiVersion.getLastTime());
        return eaiResourcesInfo;
    }

    protected EaiApiVersion toEaiApiVersion(Long versionId, String applicationCode, String appVersion, ApiInfo apiInfo, Map<String, String> map) {
        return this.toEaiApiVersion(versionId, applicationCode, appVersion, apiInfo, null, map);
    }

    protected EaiApiVersion toEaiApiVersion(Long versionId, String applicationCode, String appVersion, ApiInfo apiInfo, List<EaiApplicationAuth> eaiApplicationAuth, Map<String, String> map) {
        EaiApiVersion eaiApiVersion = new EaiApiVersion();
        eaiApiVersion.setApiVersionId(versionId);
        eaiApiVersion.setApiId(apiInfo.getId());
        eaiApiVersion.setApiCode(apiInfo.getApiCode());
        eaiApiVersion.setApiName(apiInfo.getApiName());
        eaiApiVersion.setApiVersion(appVersion);
        String path = apiInfo.getApiPath();
        if (!path.startsWith("/")) {
            path = String.format("/%s", path);
        }
        eaiApiVersion.setApiPath(path);
        eaiApiVersion.setApplicationCode(applicationCode);
        eaiApiVersion.setDataFormat(apiInfo.getDataFormat());
        eaiApiVersion.setEncodingType(apiInfo.getEncodingType());
        String inKey = this.getKeyIn(apiInfo.getId());
        String outKey = this.getKeyOut(apiInfo.getId());
        if (HussarUtils.isNotEmpty(map) && map.containsKey(inKey)) {
            eaiApiVersion.setInParams(map.get(inKey));
        } else {
            eaiApiVersion.setInParams(apiInfo.getInParams());
        }
        if (HussarUtils.isNotEmpty(map) && map.containsKey(outKey)) {
            eaiApiVersion.setOutParams(map.get(outKey));
        } else {
            eaiApiVersion.setOutParams(apiInfo.getOutParams());
        }
        eaiApiVersion.setRemark(apiInfo.getRemark());
        eaiApiVersion.setRequestType(apiInfo.getRequestType());
        eaiApiVersion.setLastEditor(apiInfo.getLastEditor());
        eaiApiVersion.setLastTime(apiInfo.getLastTime());
        eaiApiVersion.setCreator(apiInfo.getCreator());
        eaiApiVersion.setCreateTime(apiInfo.getCreateTime());
        return eaiApiVersion;
    }

    private String getKeyIn(Long id) {
        return String.format("%s_%s", id, "I");
    }

    private String getKeyOut(Long id) {
        return String.format("%s_%s", id, "O");
    }

    protected void listParams(List<ApiInfo> apiInfos, Map<String, String> map) {
        apiInfos.forEach(apiInfo -> {
            if (HussarUtils.isNotEmpty((Object)apiInfo.getInParams())) {
                map.put(this.getKeyIn(apiInfo.getId()), apiInfo.getInParams());
            }
            if (HussarUtils.isNotEmpty((Object)apiInfo.getOutParams())) {
                map.put(this.getKeyOut(apiInfo.getId()), apiInfo.getOutParams());
            }
        });
    }

    protected void unlockApp(String applicationCode, boolean isDraft) {
        String authType = "1";
        if (isDraft) {
            authType = "0";
        }
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).isNotNull(EaiHttpTemplate::getTemplateType)).set(EaiHttpTemplate::getTemplateType, (Object)authType);
        this.eaiHttpTemplateService.update((Object)new EaiHttpTemplate(), (Wrapper)updateWrapper);
        LambdaUpdateWrapper queryWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).set(SysApplication::getAppStatus, (Object)"1");
        this.applicationService.update((Wrapper)queryWrapper);
    }

    protected void checkApply(String applicationCode) {
        LambdaQueryWrapper appQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApply::getApplyCode, (Object)applicationCode)).eq(EaiApply::getResourceStatus, (Object)"0");
        EaiApply eaiApply = (EaiApply)this.applyService.getOne((Wrapper)appQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)eaiApply)) {
            throw new BaseException("\u53d1\u5e03\u5931\u8d25\uff01\u5e94\u7528\u5b58\u5728\u672a\u7ed3\u675f\u6d41\u7a0b");
        }
    }

    protected String publishType(ApiInfo apiInfo, List<Long> update) {
        if ("0".equals(apiInfo.getPublicState()) && "1".equals(apiInfo.getApiState())) {
            return "3";
        }
        if (HussarUtils.isNotEmpty(update) && update.contains(apiInfo.getId())) {
            return "2";
        }
        return "1";
    }

    protected String formatTestInfo(String name, String nameEn) {
        if (!nameEn.startsWith("/")) {
            return String.format("%s(/%s)", name, nameEn);
        }
        return String.format("%s(%s)", name, nameEn);
    }
}

