/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.publish.servce.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.service.IEaiPublishBaseService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.dto.EaiPublishDto;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.vo.EaiPublishTestListVo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeAppStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.IEaiPublishApplicationService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.PublishStepService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EaiPublishCommonServiceImpl
implements IEaiPublishBaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiPublishCommonServiceImpl.class);
    @Resource
    protected PublishStepService publishStepService;
    @Resource
    private IEaiPublishApplicationService eaiPublishApplicationService;
    @Resource
    private EaiChangeAppStateService eaiUnlockAppService;
    @Resource
    protected IEaiEditApiService eaiEditApiService;

    public ApiResponse<Boolean> unpublishing(String applicationCode) {
        this.publishStepService.initPublish(applicationCode);
        this.publishStepService.unPublish();
        return ApiResponse.success((Object)true);
    }

    @HussarTransactional(rollbackFor={BaseException.class})
    public ApiResponse<EaiPublishTestListVo> publishApply(String applicationCode) {
        AssertUtil.isNotEmpty((String)applicationCode, (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        EaiPublishTestListVo eaiPublishTestListVo = new EaiPublishTestListVo();
        try {
            this.publishStepService.initPublish(applicationCode);
            this.publishStepService.checkAuth();
            this.publishStepService.checkApply();
            this.publishStepService.lockedApp();
            this.publishStepService.lockedAuth();
            this.publishStepService.newAppVersion();
            eaiPublishTestListVo = this.publishStepService.toPublishApiInfo();
        }
        catch (BaseException ex) {
            throw new BaseException(ex.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("publishApply exception", (Throwable)e);
            throw new BaseException("\u83b7\u53d6\u5f85\u53d1\u5e03\u4fe1\u606f\u5f02\u5e38");
        }
        return ApiResponse.success((Object)eaiPublishTestListVo);
    }

    @HussarTransactional(rollbackFor={BaseException.class})
    public boolean publishApp(String applicationCode) {
        try {
            this.publishStepService.initPublish(applicationCode);
            this.publishStepService.appVersionAndUpdate();
            this.publishStepService.publishConfiguration();
            this.publishStepService.publishAuth();
            this.publishStepService.publishApi();
            this.publishStepService.publishApiCallSpecification();
            this.publishStepService.publishExtra();
            this.publishStepService.publishCanvas();
            this.publishStepService.publishEditApi();
            this.publishStepService.rejectApply();
            this.publishStepService.publishEngine();
            this.publishStepService.unlockApp();
            return true;
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("publish error", (Throwable)e);
            throw new BaseException("\u53d1\u5e03\u5931\u8d25,\u672a\u77e5\u5f02\u5e38");
        }
    }

    public boolean publishApp(String applicationCode, List<ApiInfo> apiInfo, Boolean isPublish) {
        throw new BaseException("the method has not defined for this version");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public boolean savePublishInfo(EaiPublishDto eaiPublishDto) {
        try {
            eaiPublishDto.getEaiApply().setResourceStatus("0");
            eaiPublishDto.getEaiApply().setApplyType("08");
            this.eaiPublishApplicationService.savePublishInfo(eaiPublishDto);
        }
        catch (Exception e) {
            this.publishStepService.unPublish();
            throw new BaseException("\u6dfb\u52a0\u53d1\u5e03\u7533\u8bf7\u5931\u8d25");
        }
        return true;
    }
}

