/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.appinfo.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.adapter.appinfo.api.service.ICommonApplicationManagementCallBackService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiClassificationService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonConstantService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.common.api.common.dto.DeleteEaiAppDto;
import com.jxdinfo.hussar.eai.common.service.IEaiDeleteAppService;
import com.jxdinfo.hussar.eai.logs.api.applogs.service.IApplicationResourcesService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.adapter.appinfo.server.service.impl.CommonApplicationManagementCallBackServiceImpl")
public class CommonApplicationManagementCallBackServiceImpl
implements ICommonApplicationManagementCallBackService {
    public static final String APP_TYPE_EAI = "6";
    @Resource
    private IReleaseApiService iEaiReleaseApiService;
    @Resource
    private IApiVersionService iEaiApiVersionService;
    @Resource
    private EaiCommonStructureService iEaiCommonStructureService;
    @Resource
    private IStructureVersionService iEaiStructureVersionService;
    @Resource
    private EaiCommonConstantService iCommonConstantService;
    @Resource
    private IConstantVersionService iEaiConstantVersionService;
    @Resource
    private IHttpAuthenticationService iHttpAuthenticationService;
    @Resource
    private IApplicationResourcesService iApplicationResourcesService;
    @Resource
    private IEaiApiClassificationService eaiApiClassificationService;
    @Autowired
    protected IEaiApiInfoService apiInfoService;
    @Autowired
    private List<IEaiDeleteAppService> servieList;
    @Autowired
    private ISysResourcesService sysResourcesService;

    public String getAppType() {
        return APP_TYPE_EAI;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void commonDeleteRecycleApp(SysAppRecycle appRecycle) {
        if (HussarUtils.isEmpty((Object)appRecycle)) {
            throw new HussarException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper apiWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)appRecycle.getAppCode());
        List apiInfos = this.apiInfoService.list((Wrapper)apiWrapper);
        List apiIds = apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList());
        LambdaQueryWrapper apiVersionWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiVersion::getApplicationCode, (Object)appRecycle.getAppCode());
        List apiVersionInfos = this.iEaiApiVersionService.list((Wrapper)apiVersionWrapper);
        List apiVersionIds = apiVersionInfos.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList());
        DeleteEaiAppDto deleteEaiAppDto = new DeleteEaiAppDto();
        deleteEaiAppDto.setAppCode(appRecycle.getAppCode());
        deleteEaiAppDto.setApiIds(apiIds);
        deleteEaiAppDto.setApiVersionIds(apiVersionIds);
        for (IEaiDeleteAppService service : this.servieList) {
            service.deleteAppResource(deleteEaiAppDto);
        }
        LambdaQueryWrapper removeApiWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)appRecycle.getAppCode());
        this.apiInfoService.remove((Wrapper)removeApiWrapper);
        LambdaQueryWrapper removeApiersionWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiVersion::getApplicationCode, (Object)appRecycle.getAppCode());
        this.iEaiApiVersionService.remove((Wrapper)removeApiersionWrapper);
        ArrayList<String> urlList = new ArrayList<String>();
        for (EaiApiVersion eaiApiVersion : apiVersionInfos) {
            urlList.add(eaiApiVersion.getApiPath());
        }
        if (ToolUtil.isNotEmpty(urlList)) {
            this.sysResourcesService.remove((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysResources::getUrlNames, urlList));
        }
        this.iEaiCommonStructureService.deleteByAppCode(appRecycle.getAppCode());
        this.iEaiStructureVersionService.deleteByAppCode(appRecycle.getAppCode());
        this.iCommonConstantService.deleteByAppCode(appRecycle.getAppCode());
        this.iEaiConstantVersionService.deleteByAppCode(appRecycle.getAppCode());
        this.iHttpAuthenticationService.deleteAuthParamsByAppcode(appRecycle.getAppCode());
        this.iApplicationResourcesService.deleteResourceByAppCode(appRecycle.getAppCode());
        this.eaiApiClassificationService.deleteByAppCode(appRecycle.getAppCode());
    }
}

