/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.applydefault.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.adapter.applydefault.api.service.IWorktableService;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.service.IEaiPublishBaseService;
import com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.publishresource.service.IEaiResourcePublishService;
import com.jxdinfo.hussar.eai.appinfo.api.model.ApplicationResources;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiApplicationResourceService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiSysApplicationService;
import com.jxdinfo.hussar.eai.applyinfo.api.dto.EaiApplyDto;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiAppData;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApply;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApplyRecord;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiAppDataService;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyRecordService;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyService;
import com.jxdinfo.hussar.eai.applyinfo.api.vo.EaiApplyVo;
import com.jxdinfo.hussar.eai.logs.api.applogs.service.IEaiResourcesPublishService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="com.jxdinfo.hussar.eai.server.applicationactiviti.worktable.service.impl.WorktableServiceServiceImpl")
public class WorktableServiceServiceImpl
implements IWorktableService {
    @Resource
    private IEaiApplyService eaiApplyService;
    @Resource
    private IEaiAppDataService eaiAppDataService;
    @Resource
    private IEaiApplyRecordService applyRecordService;
    @Resource
    private IEaiApplicationResourceService applicationResourceService;
    @Resource
    private IEaiPublishBaseService eaiPublishService;
    @Resource
    private IEaiResourcePublishService eaiResourcePublishService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private IApplicationManagementService applicationManagementService;
    @Resource
    private IEaiResourcesPublishService iEaiResourcesPublishService;
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private IEaiSysApplicationService eaiSysApplicationService;

    public ApiResponse<Page<EaiApplyVo>> applyPageList(Page<EaiApplyVo> pageInfo, EaiApplyDto applyDto) {
        Object eaiApplyVoPage = null;
        return ApiResponse.success(eaiApplyVoPage);
    }

    public ApiResponse<EaiApplyVo> applyDetail(Long applyId, Long relationId, String applyType) {
        if ("01".equals(applyType) || "02".equals(applyType)) {
            return ApiResponse.success((Object)this.eaiApplyService.applyDetail(applyId, relationId));
        }
        return ApiResponse.success((Object)this.eaiApplyService.applyLogDetail(applyId, relationId));
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> updateStatus(Long applyId, String resourceStatus, String approveRemark) {
        EaiApply applyQuery = (EaiApply)this.eaiApplyService.getById((Serializable)applyId);
        this.appVerifyOperation(applyQuery, resourceStatus);
        if ("1".equals(resourceStatus)) {
            EaiAppData appData;
            if ("01".equals(applyQuery.getApplyType()) || "02".equals(applyQuery.getApplyType())) {
                EaiResourcesInfo eaiResourcesInfo = this.getEaiResourcesInfo(applyQuery);
                ApplicationResources applicationResources = new ApplicationResources();
                applicationResources.setResourceId(eaiResourcesInfo.getResourceId());
                applicationResources.setApplicationCode(applyQuery.getApplyCode());
                if ("01".equals(applyQuery.getApplyType())) {
                    applicationResources.setResourceType("1");
                } else if ("02".equals(applyQuery.getApplyType())) {
                    applicationResources.setResourceType("0");
                }
                this.applicationResourceService.save((Object)applicationResources);
            } else if ("07".equals(applyQuery.getApplyType()) || "05".equals(applyQuery.getApplyType()) || "06".equals(applyQuery.getApplyType())) {
                appData = (EaiAppData)this.eaiAppDataService.getById((Serializable)Long.valueOf(applyQuery.getResourceId()));
                if (HussarUtils.isEmpty((Object)appData.getRecordData())) {
                    throw new HussarException("\u8d44\u6e90\u4fee\u6539\u5185\u5bb9\u4e0d\u5b58\u5728\uff01");
                }
                SysApplicationDto dto = (SysApplicationDto)JSONObject.parseObject((String)appData.getRecordData(), SysApplicationDto.class);
                if ("06".equals(applyQuery.getApplyType())) {
                    dto.setReleaseStatus("0");
                    this.rejectApply(applyQuery.getApplyCode());
                }
                if ("05".equals(applyQuery.getApplyType())) {
                    dto.setReleaseStatus("1");
                }
                this.eaiSysApplicationService.updateApp(dto);
                if ("06".equals(applyQuery.getApplyType())) {
                    this.iEaiResourcesPublishService.updateDeleteStateByAppCode(dto.getAppCode(), "1");
                }
                if ("05".equals(applyQuery.getApplyType())) {
                    this.iEaiResourcesPublishService.updateDeleteStateByAppCode(dto.getAppCode(), "0");
                }
            } else if ("04".equals(applyQuery.getApplyType())) {
                appData = (EaiAppData)this.eaiAppDataService.getById((Serializable)Long.valueOf(applyQuery.getResourceId()));
                if (HussarUtils.isNotEmpty((Object)appData.getRecordData())) {
                    SysApplicationDto dto = (SysApplicationDto)JSONObject.parseObject((String)appData.getRecordData(), SysApplicationDto.class);
                    this.sysApplicationService.deleteApp(dto.getId());
                }
            } else if ("08".equals(applyQuery.getApplyType())) {
                this.eaiPublishService.publishApp(applyQuery.getApplyCode());
            }
        } else if ("08".equals(applyQuery.getApplyType())) {
            this.eaiResourcePublishService.reJectChangeState(null, null, applyQuery.getApplyCode());
        }
        EaiApply apply = new EaiApply();
        apply.setApplyId(applyId);
        apply.setResourceStatus(resourceStatus);
        apply.setApproveRemark(approveRemark);
        this.eaiApplyService.updateById((Object)apply);
        return ApiResponse.success();
    }

    private void appVerifyOperation(EaiApply applyQuery, String resourceStatus) {
        List<String> overFlow = Arrays.asList("3", "2", "1");
        if (overFlow.contains(resourceStatus) && !"0".equals(applyQuery.getResourceStatus())) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u68c0\u67e5\u6743\u9650\u540e\u91cd\u8bd5");
        }
    }

    private EaiResourcesInfo getEaiResourcesInfo(EaiApply applyQuery) {
        EaiApplyRecord applyRecord = (EaiApplyRecord)this.applyRecordService.getById((Serializable)((Object)applyQuery.getResourceId()));
        return (EaiResourcesInfo)this.eaiResourcesInfoService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getResourceRelationId, (Object)applyRecord.getResourceId())).eq(EaiResourcesInfo::getApplicationVersion, (Object)applyRecord.getLogVersion())).eq(EaiResourcesInfo::getDeleteState, (Object)"0"));
    }

    private void rejectApply(String applyCode) {
        List eaiApplyVos = this.eaiApplyService.getApplyByResourceBelongingToAppCode(applyCode, "0");
        if (HussarUtils.isNotEmpty((Object)eaiApplyVos)) {
            List applyIds = eaiApplyVos.stream().map(EaiApplyVo::getApplyId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.set(EaiApply::getResourceStatus, (Object)"2")).set(EaiApply::getApproveRemark, (Object)"\u63a5\u53e3\u5df2\u4e0b\u67b6");
            updateWrapper.in(EaiApply::getApplyId, applyIds);
            this.eaiApplyService.update((Object)new EaiApply(), (Wrapper)updateWrapper);
        }
    }

    public ApiResponse<Page<EaiApplyVo>> approvePageList(Page<EaiApplyVo> pageInfo, EaiApplyDto applyDto) {
        Page eaiApplyVoPage = null;
        if (applyDto.getHasViewHistory()) {
            if (HussarUtils.isNotEmpty((Object)applyDto.getResourceStatus())) {
                applyDto.setResourceStatusList(Arrays.asList(applyDto.getResourceStatus()));
            }
            eaiApplyVoPage = this.eaiApplyService.applyPageListAll(pageInfo, applyDto, true);
        } else {
            applyDto.setResourceStatus("0");
            if (HussarUtils.isNotEmpty((Object)applyDto.getResourceStatus())) {
                applyDto.setResourceStatusList(Arrays.asList(applyDto.getResourceStatus()));
            } else {
                applyDto.setResourceStatusList(Arrays.asList("0"));
            }
            eaiApplyVoPage = this.eaiApplyService.applyPageListAll(pageInfo, applyDto, true);
        }
        return ApiResponse.success((Object)eaiApplyVoPage);
    }
}

