/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.applydefault.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.adapter.applydefault.api.service.IWorktableService;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.service.IEaiPublishBaseService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appinfo.api.model.ApplicationResources;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiApplicationResourceService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiSysApplicationService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.applyinfo.api.dto.EaiApplyDto;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiAppData;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApply;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApplyRecord;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiAppDataService;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyRecordService;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyService;
import com.jxdinfo.hussar.eai.applyinfo.api.vo.EaiApplyVo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeAppStateService;
import com.jxdinfo.hussar.eai.logs.api.applogs.service.IEaiResourcesPublishService;
import com.jxdinfo.hussar.iam.client.dto.ClientPermissionDto;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientPermissionService;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.applicationactiviti.worktable.service.impl.WorktableServiceServiceImpl")
public class WorktableServiceServiceImpl
implements IWorktableService {
    @Resource
    private IEaiApplyService eaiApplyService;
    @Resource
    private IEaiAppDataService eaiAppDataService;
    @Resource
    private IEaiApplyRecordService applyRecordService;
    @Resource
    private IEaiApplicationResourceService applicationResourceService;
    @Resource
    private IEaiPublishBaseService eaiPublishService;
    @Resource
    private EaiChangeAppStateService eaiChangeAppStateService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private IApplicationManagementService applicationManagementService;
    @Resource
    private IEaiResourcesPublishService iEaiResourcesPublishService;
    @Resource
    private ISysAppClientService sysAppClientService;
    @Resource
    private IHussarIamClientPermissionService iamClientPermissionService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysClientModelService sysClientModelService;
    @Resource
    private IApiVersionService apiVersionService;
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private IEaiSysApplicationService eaiSysApplicationService;

    public ApiResponse<Page<EaiApplyVo>> applyPageList(Page<EaiApplyVo> pageInfo, EaiApplyDto applyDto) {
        Page eaiApplyVoPage = null;
        List<Object> applyCodesCurrent = Lists.newArrayListWithCapacity((int)10);
        List byCurrentUser = this.applicationManagementService.getByCurrentUser("");
        if (HussarUtils.isEmpty((Object)byCurrentUser)) {
            return ApiResponse.success();
        }
        if (HussarUtils.isNotEmpty((Object)byCurrentUser)) {
            applyCodesCurrent = byCurrentUser.stream().map(ApplicationManageVo::getAppCode).collect(Collectors.toList());
        }
        applyDto.setApplyCodeList((List)applyCodesCurrent);
        applyDto.setApplyName(SqlQueryUtil.transferSpecialChar((String)applyDto.getApplyName()));
        applyDto.setEscapeSymbol(SqlQueryUtil.ESCAPE_SYMBOL);
        if (applyDto.getHasViewHistory()) {
            if (HussarUtils.isNotEmpty((Object)applyDto.getResourceStatus())) {
                applyDto.setResourceStatusList(Arrays.asList(applyDto.getResourceStatus()));
            }
            eaiApplyVoPage = this.eaiApplyService.applyPageListAll(pageInfo, applyDto, false);
        } else if (HussarUtils.isNotEmpty((Object)applyDto.getResourceStatus())) {
            applyDto.setResourceStatusList(Arrays.asList(applyDto.getResourceStatus()));
            if ("0".equals(applyDto.getResourceStatus())) {
                eaiApplyVoPage = this.eaiApplyService.applyPageListAll(pageInfo, applyDto, false);
            } else {
                LocalDateTime endtTime = LocalDateTime.now();
                applyDto.setCreateEndTime(endtTime);
                applyDto.setCreateStartTime(endtTime.plusDays(-3L));
                eaiApplyVoPage = this.eaiApplyService.applyPageListAll(pageInfo, applyDto, false);
            }
        } else {
            eaiApplyVoPage = this.eaiApplyService.applyPageListUnion(pageInfo, applyDto);
        }
        return ApiResponse.success((Object)eaiApplyVoPage);
    }

    public ApiResponse<EaiApplyVo> applyDetail(Long applyId, Long relationId, String applyType) {
        if ("01".equals(applyType) || "02".equals(applyType)) {
            return ApiResponse.success((Object)this.eaiApplyService.applyDetail(applyId, relationId));
        }
        return ApiResponse.success((Object)this.eaiApplyService.applyLogDetail(applyId, relationId));
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> updateStatus(Long applyId, String resourceStatus, String approveRemark) {
        EaiApply applyQuery = (EaiApply)this.eaiApplyService.getById((Serializable)applyId);
        this.appVerifyOperation(applyQuery, resourceStatus);
        if ("1".equals(resourceStatus)) {
            EaiAppData appData;
            if ("01".equals(applyQuery.getApplyType()) || "02".equals(applyQuery.getApplyType())) {
                EaiResourcesInfo eaiResourcesInfo = this.getEaiResourcesInfo(applyQuery);
                ApplicationResources applicationResources = new ApplicationResources();
                applicationResources.setResourceId(eaiResourcesInfo.getResourceId());
                applicationResources.setApplicationCode(applyQuery.getApplyCode());
                if ("01".equals(applyQuery.getApplyType())) {
                    applicationResources.setResourceType("1");
                } else if ("02".equals(applyQuery.getApplyType())) {
                    applicationResources.setResourceType("0");
                }
                this.applicationResourceService.save((Object)applicationResources);
                if ("01".equals(applyQuery.getApplyType())) {
                    ArrayList<ClientPermissionDto> addList = new ArrayList<ClientPermissionDto>();
                    SysResources sysResources = this.getResource(eaiResourcesInfo);
                    SysClientModel sysClientModel = this.getClientModel(applyQuery);
                    if (ToolUtil.isNotEmpty((Object)sysResources) && ToolUtil.isNotEmpty((Object)sysClientModel)) {
                        ClientPermissionDto clientPermissionDto = new ClientPermissionDto();
                        clientPermissionDto.setClientId(sysClientModel.getClientId());
                        clientPermissionDto.setResourceId(sysResources.getId());
                        addList.add(clientPermissionDto);
                        this.iamClientPermissionService.addOrDelClientPermission(addList, new ArrayList());
                    }
                }
            } else if ("07".equals(applyQuery.getApplyType()) || "05".equals(applyQuery.getApplyType()) || "06".equals(applyQuery.getApplyType())) {
                appData = (EaiAppData)this.eaiAppDataService.getById((Serializable)Long.valueOf(applyQuery.getResourceId()));
                if (HussarUtils.isEmpty((Object)appData.getRecordData())) {
                    throw new HussarException("\u8d44\u6e90\u4fee\u6539\u5185\u5bb9\u4e0d\u5b58\u5728\uff01");
                }
                SysApplicationDto dto = (SysApplicationDto)JSONObject.parseObject((String)appData.getRecordData(), SysApplicationDto.class);
                if ("06".equals(applyQuery.getApplyType())) {
                    dto.setReleaseStatus("0");
                    this.rejectApply(applyQuery.getApplyCode());
                }
                if ("05".equals(applyQuery.getApplyType())) {
                    dto.setReleaseStatus("1");
                }
                this.eaiSysApplicationService.updateApp(dto);
                if ("06".equals(applyQuery.getApplyType())) {
                    this.iEaiResourcesPublishService.updateDeleteStateByAppCode(dto.getAppCode(), "2", "0");
                }
                if ("05".equals(applyQuery.getApplyType())) {
                    this.iEaiResourcesPublishService.updateDeleteStateByAppCode(dto.getAppCode(), "0", "2");
                }
            } else if ("04".equals(applyQuery.getApplyType())) {
                appData = (EaiAppData)this.eaiAppDataService.getById((Serializable)Long.valueOf(applyQuery.getResourceId()));
                if (HussarUtils.isNotEmpty((Object)appData.getRecordData())) {
                    SysApplicationDto dto = (SysApplicationDto)JSONObject.parseObject((String)appData.getRecordData(), SysApplicationDto.class);
                    this.sysApplicationService.deleteApp(dto.getId());
                }
            } else if ("08".equals(applyQuery.getApplyType())) {
                this.eaiPublishService.publishApp(applyQuery.getApplyCode());
            }
        } else if ("08".equals(applyQuery.getApplyType())) {
            this.eaiChangeAppStateService.unPublishing(null, null, applyQuery.getApplyCode());
        }
        EaiApply apply = new EaiApply();
        apply.setApplyId(applyId);
        apply.setResourceStatus(resourceStatus);
        apply.setApproveRemark(approveRemark);
        this.eaiApplyService.updateById((Object)apply);
        return ApiResponse.success();
    }

    private void appVerifyOperation(EaiApply applyQuery, String resourceStatus) {
        List<String> overFlow = Arrays.asList("3", "2", "1");
        if (overFlow.contains(resourceStatus) && !"0".equals(applyQuery.getResourceStatus())) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u68c0\u67e5\u6743\u9650\u540e\u91cd\u8bd5");
        }
    }

    private EaiResourcesInfo getEaiResourcesInfo(EaiApply applyQuery) {
        EaiApplyRecord applyRecord = (EaiApplyRecord)this.applyRecordService.getById((Serializable)((Object)applyQuery.getResourceId()));
        return (EaiResourcesInfo)this.eaiResourcesInfoService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getResourceRelationId, (Object)applyRecord.getResourceId())).eq(EaiResourcesInfo::getApplicationVersion, (Object)applyRecord.getLogVersion())).eq(EaiResourcesInfo::getDeleteState, (Object)"0"));
    }

    private void rejectApply(String applyCode) {
        List eaiApplyVos = this.eaiApplyService.getApplyByResourceBelongingToAppCode(applyCode, "0");
        if (HussarUtils.isNotEmpty((Object)eaiApplyVos)) {
            List applyIds = eaiApplyVos.stream().map(EaiApplyVo::getApplyId).collect(Collectors.toList());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.set(EaiApply::getResourceStatus, (Object)"2")).set(EaiApply::getApproveRemark, (Object)"\u63a5\u53e3\u5df2\u4e0b\u67b6");
            updateWrapper.in(EaiApply::getApplyId, applyIds);
            this.eaiApplyService.update((Object)new EaiApply(), (Wrapper)updateWrapper);
        }
    }

    public ApiResponse<Page<EaiApplyVo>> approvePageList(Page<EaiApplyVo> pageInfo, EaiApplyDto applyDto) {
        Page eaiApplyVoPage = null;
        applyDto.setApplyName(SqlQueryUtil.transferSpecialChar((String)applyDto.getApplyName()));
        applyDto.setEscapeSymbol(SqlQueryUtil.ESCAPE_SYMBOL);
        if (applyDto.getHasViewHistory()) {
            if (HussarUtils.isNotEmpty((Object)applyDto.getResourceStatus())) {
                applyDto.setResourceStatusList(Arrays.asList(applyDto.getResourceStatus()));
            }
            eaiApplyVoPage = this.eaiApplyService.applyPageListAll(pageInfo, applyDto, true);
        } else {
            applyDto.setResourceStatus("0");
            if (HussarUtils.isNotEmpty((Object)applyDto.getResourceStatus())) {
                applyDto.setResourceStatusList(Arrays.asList(applyDto.getResourceStatus()));
            } else {
                applyDto.setResourceStatusList(Arrays.asList("0"));
            }
            eaiApplyVoPage = this.eaiApplyService.applyPageListAll(pageInfo, applyDto, true);
        }
        return ApiResponse.success((Object)eaiApplyVoPage);
    }

    private SysResources getResource(EaiResourcesInfo eaiResourcesInfo) {
        EaiApiVersion eaiApiVersion = (EaiApiVersion)this.apiVersionService.getById((Serializable)eaiResourcesInfo.getResourceVersionId());
        if (ToolUtil.isNotEmpty((Object)eaiApiVersion)) {
            return (SysResources)this.sysResourcesService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)eaiApiVersion.getApiPath()));
        }
        return null;
    }

    private SysClientModel getClientModel(EaiApply applyQuery) {
        SysAppClient sysAppClient;
        ApplicationManageVo applicationManageVo = this.applicationManagementService.getByAppCode(applyQuery.getApplyCode());
        if (ToolUtil.isNotEmpty((Object)applicationManageVo) && ToolUtil.isNotEmpty((Object)(sysAppClient = (SysAppClient)this.sysAppClientService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)applicationManageVo.getId()))))) {
            return (SysClientModel)this.sysClientModelService.getById((Serializable)sysAppClient.getClientModelId());
        }
        return null;
    }
}

