/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.EaiReleaseApiWithLogicService;
import com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl.ApiCommonManager;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiTestDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.EaiApiCanvasConvertService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasApiReleaseService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.IApiGenerateCanvasService;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl.EaiReleaseApiWithLogicServiceImpl")
public class EaiReleaseApiWithLogicServiceImpl
extends ApiCommonManager
implements EaiReleaseApiWithLogicService {
    private static Logger logger = LoggerFactory.getLogger(EaiReleaseApiWithLogicServiceImpl.class);
    private static final String ERROR = "\u4fdd\u5b58\u5931\u8d25";
    @Resource
    protected IApiGenerateCanvasService apiGenerateCanvasService;
    @Resource
    ICanvasInfoService canvasInfoService;
    @Resource
    EaiApiCanvasConvertService eaiApiCanvasConvertService;
    @Resource
    EaiCanvasApiReleaseService eaiCanvasApiReleaseService;

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean saveApiInfo(AddApiInfoDto addApiInfoDto) {
        boolean edit;
        addApiInfoDto.setId(String.valueOf(IdGenerateUtils.getId()));
        Boolean api = super.saveApiInfo(addApiInfoDto);
        if (!api.booleanValue()) {
            throw new BaseException(ERROR);
        }
        addApiInfoDto.setCreateCanvasFlag(true);
        EditApi editApi = this.fillEditApi(addApiInfoDto);
        if (HussarUtils.isEmpty((Object)editApi.getCanvasId())) {
            editApi.setCanvasId(IdGenerateUtils.getId());
        }
        if (!(edit = this.iEaiEditApiService.save((Object)editApi))) {
            throw new BaseException(ERROR);
        }
        if (1 == this.eaiApiProperties.getLogicType()) {
            this.apiGenerateCanvasService.convertCanvasInfoStr(addApiInfoDto);
            this.saveCanvas(editApi, addApiInfoDto);
        }
        EaiAppEditManager.getInstance().call(addApiInfoDto.getApplicationCode());
        return true;
    }

    public Boolean deleteById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (HussarUtils.equals((Object)apiInfo.getApiState(), (Object)"1")) {
            throw new HussarException("\u5df2\u4e0a\u67b6\u63a5\u53e3\u4e0d\u80fd\u5220\u9664");
        }
        this.apiInfoService.removeById((Serializable)((Object)id));
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)id);
        EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)editApi)) {
            this.iEaiEditApiService.deleteByApiId(id);
            if (HussarUtils.isNotEmpty((Object)editApi.getCanvasId())) {
                this.canvasInfoService.removeById((Serializable)editApi.getCanvasId());
            }
        }
        EaiAppEditManager.getInstance().call(apiInfo.getApplicationCode());
        return true;
    }

    public ApiResponse<EaiApiResponseVo> verifyApi(ApiTestDto apiTestDto) {
        HttpAuthVerifyDto authVerifyDto = this.fillAuthVerify(apiTestDto);
        if (HussarUtils.isNotEmpty((Object)apiTestDto.getApiId()) && 1 == this.eaiApiProperties.getLogicType()) {
            return this.eaiApiCanvasConvertService.convetTest(apiTestDto, authVerifyDto);
        }
        return super.verifyApi(apiTestDto);
    }

    private void saveCanvas(EditApi editApi, AddApiInfoDto addApiInfoDto) {
        boolean canvas;
        if (0 == this.eaiApiProperties.getLogicType()) {
            return;
        }
        if (StringUtil.isNotEmpty((Object)editApi.getCanvasId())) {
            this.canvasInfoService.removeById((Serializable)editApi.getCanvasId());
        }
        CanvasInfo canvasInfo = new CanvasInfo();
        canvasInfo.setId(editApi.getCanvasId());
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getCanvasInfo())) {
            canvasInfo.setCanvasContent(addApiInfoDto.getCanvasInfo());
        }
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getApiEventrelates())) {
            canvasInfo.setApiCodes(EaiReleaseApiWithLogicServiceImpl.toJSONString((Object)addApiInfoDto.getApiEventrelates()));
        }
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getRelateFiles())) {
            canvasInfo.setCanvasResources(EaiReleaseApiWithLogicServiceImpl.toJSONString((Object)addApiInfoDto.getRelateFiles()));
        }
        if (!(canvas = this.canvasInfoService.save((Object)canvasInfo))) {
            throw new BaseException(ERROR);
        }
    }

    @Override
    public Long saveLogicApiBaseInfo(AddApiInfoDto addApiInfoDto) {
        Long apiId = this.saveApiBaseInfo(addApiInfoDto);
        addApiInfoDto.setId(String.valueOf(apiId));
        addApiInfoDto.setHttpMethod(EaiRequestTypeEnum.POST.getRequestTypeStr());
        addApiInfoDto.setContentType(EaiContentType.APPLICATION_JSON.getTypeStr());
        addApiInfoDto.setCanvasInfo("{\n  \"instanceKey\": \"hussar_0\",\n  \"instanceDecoration\": \"hussar_0\",\n  \"temporaryKey\": \"\",\n  \"parentInstanceKey\": \"\",\n  \"slotName\": \"default\",\n  \"name\": \"com.jxdinfo.logic.BackendRoot\",\n  \"label\": \"\",\n  \"alias\": \"\",\n  \"isContainer\": true,\n  \"hasError\": true,\n  \"instanceErrors\": {},\n  \"x\": 0,\n  \"y\": 0,\n  \"top\": 0,\n  \"left\": 0,\n  \"bottom\": \"auto\",\n  \"right\": \"auto\",\n  \"width\": 1146,\n  \"height\": 600,\n  \"_width\": null,\n  \"_height\": null,\n  \"scale\": 1,\n  \"props\": {},\n  \"propsErrors\": {},\n  \"t\": 0,\n  \"tb\": 300,\n  \"b\": 600,\n  \"l\": 0,\n  \"lr\": 573,\n  \"r\": 1146,\n  \"narrowDragInfo\": [{\n    \"slotName\": [\"default\"],\n    \"isFillFloatLeftAndRight\": true\n  }],\n  \"isNarrowContainer\": false,\n  \"offset\": [0, 0, 0, 0],\n  \"zIndex\": 100,\n  \"borderWidth\": [0, 0, 0, 0],\n  \"goInPathes\": [],\n  \"goOutPathes\": [],\n  \"innerStyles\": {},\n  \"layout\": \"relative\",\n  \"position\": \"relative\",\n  \"params\": [],\n  \"variables\": [],\n  \"result\": [],\n  \"referencesIndex\": {},\n  \"resReferencesIndex\": {},\n  \"maxInstanceCount\": 3,\n  \"relateFiles\": {},\n  \"variableSets\": {\n    \"variables\": [],\n    \"params\": [],\n    \"result\": [],\n    \"componentVariables\": []\n  },\n  \"slots\": {\n    \"default\": [{\n      \"instanceKey\": \"backendStart_1\",\n      \"instanceDecoration\": \"backendStart_1\",\n      \"temporaryKey\": \"\",\n      \"parentInstanceKey\": \"hussar_0\",\n      \"slotName\": \"default\",\n      \"name\": \"com.jxdinfo.logic.BackendStart\",\n      \"label\": \"\",\n      \"alias\": \"\",\n      \"isContainer\": false,\n      \"hasError\": false,\n      \"instanceErrors\": {},\n      \"x\": 532,\n      \"y\": 45,\n      \"top\": 45,\n      \"left\": 532,\n      \"bottom\": \"auto\",\n      \"right\": \"auto\",\n      \"width\": 82,\n      \"height\": 40,\n      \"_width\": null,\n      \"_height\": null,\n      \"scale\": 1,\n      \"props\": {\n        \"notAllowDelete\": true,\n        \"notAllowCopy\": true,\n        \"topLevel\": true\n      },\n      \"propsErrors\": {},\n      \"t\": 45,\n      \"tb\": 65,\n      \"b\": 85,\n      \"l\": 532,\n      \"lr\": 573,\n      \"r\": 614,\n      \"narrowDragInfo\": [{\n        \"slotName\": [\"default\"],\n        \"isFillFloatLeftAndRight\": true\n      }],\n      \"isNarrowContainer\": false,\n      \"offset\": [0, 0, 0, 0],\n      \"zIndex\": 101,\n      \"borderWidth\": [0, 0, 0, 0],\n      \"goInPathes\": [],\n      \"goOutPathes\": [\"hussar_path_3\"],\n      \"innerStyles\": {},\n      \"layout\": \"absolute\",\n      \"position\": \"absolute\",\n      \"isStart\": true\n    }, {\n      \"instanceKey\": \"backendEnd_2\",\n      \"instanceDecoration\": \"backendEnd_2\",\n      \"temporaryKey\": \"\",\n      \"parentInstanceKey\": \"hussar_0\",\n      \"slotName\": \"default\",\n      \"name\": \"com.jxdinfo.logic.BackendEnd\",\n      \"label\": \"\",\n      \"alias\": \"\",\n      \"isContainer\": false,\n      \"hasError\": false,\n      \"instanceErrors\": {},\n      \"x\": 532,\n      \"y\": 175,\n      \"top\": 175,\n      \"left\": 532,\n      \"bottom\": \"auto\",\n      \"right\": \"auto\",\n      \"width\": 82,\n      \"height\": 40,\n      \"_width\": null,\n      \"_height\": null,\n      \"scale\": 1,\n      \"props\": {\n        \"notAllowDelete\": true,\n        \"notAllowCopy\": true,\n        \"topLevel\": true\n      },\n      \"propsErrors\": {},\n      \"t\": 175,\n      \"tb\": 195,\n      \"b\": 215,\n      \"l\": 532,\n      \"lr\": 573,\n      \"r\": 614,\n      \"narrowDragInfo\": [{\n        \"slotName\": [\"default\"],\n        \"isFillFloatLeftAndRight\": true\n      }],\n      \"isNarrowContainer\": false,\n      \"offset\": [0, 0, 0, 0],\n      \"zIndex\": 102,\n      \"borderWidth\": [0, 0, 0, 0],\n      \"goInPathes\": [\"hussar_path_3\"],\n      \"goOutPathes\": [],\n      \"innerStyles\": {},\n      \"layout\": \"absolute\",\n      \"position\": \"absolute\",\n      \"isEnd\": true\n    }],\n    \"path\": [{\n      \"instanceKey\": \"hussar_path_3\",\n      \"instanceDecoration\": \"hussar_path_3\",\n      \"temporaryKey\": \"\",\n      \"parentInstanceKey\": \"hussar_0\",\n      \"slotName\": \"path\",\n      \"name\": \"com.jxdinfo.logic.JxdLogicPath\",\n      \"label\": \"\",\n      \"alias\": \"\",\n      \"isContainer\": false,\n      \"hasError\": false,\n      \"instanceErrors\": {},\n      \"x\": 0,\n      \"y\": 0,\n      \"top\": 0,\n      \"left\": 0,\n      \"bottom\": \"auto\",\n      \"right\": \"auto\",\n      \"width\": null,\n      \"height\": null,\n      \"_width\": null,\n      \"_height\": null,\n      \"scale\": 1,\n      \"props\": {},\n      \"propsErrors\": {},\n      \"t\": 0,\n      \"tb\": 0,\n      \"b\": 0,\n      \"l\": 0,\n      \"lr\": 0,\n      \"r\": 0,\n      \"narrowDragInfo\": [{\n        \"slotName\": [\"default\"],\n        \"isFillFloatLeftAndRight\": true\n      }],\n      \"isNarrowContainer\": false,\n      \"offset\": [0, 0, 0, 0],\n      \"zIndex\": 100,\n      \"borderWidth\": [0, 0, 0, 0],\n      \"goInPathes\": [],\n      \"goOutPathes\": [],\n      \"innerStyles\": {},\n      \"layout\": \"absolute\",\n      \"position\": \"absolute\",\n      \"start\": {\n        \"key\": \"backendStart_1\",\n        \"port\": \"B\"\n      },\n      \"end\": {\n        \"key\": \"backendEnd_2\",\n        \"port\": \"T\"\n      },\n      \"points\": [{\n        \"x\": 573,\n        \"y\": 85,\n        \"type\": \"start\"\n      }, {\n        \"x\": 573,\n        \"y\": 175,\n        \"type\": \"end\"\n      }],\n      \"d\": \"M573 85 L573 175 \",\n      \"pathSlotName\": \"default\",\n      \"transform\": \"\"\n    }]\n  }\n}");
        Boolean canvas = this.eaiCanvasApiReleaseService.saveApiCanvasInfo(addApiInfoDto);
        return apiId;
    }
}

