/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl.ApiCommonManager;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddBodyListApiInfoDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.EaiCanvasService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl.EaiReleaseApiWithLogicServiceImpl")
public class EaiReleaseApiWithLogicServiceImpl
extends ApiCommonManager
implements IReleaseApiService {
    private static Logger logger = LoggerFactory.getLogger(EaiReleaseApiWithLogicServiceImpl.class);
    private static final String ERROR = "\u4fdd\u5b58\u5931\u8d25";
    @Resource
    protected IEaiApiInfoService apiInfoService;
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    protected EaiCanvasService eaiCanvasService;
    @Resource
    ICanvasInfoService canvasInfoService;
    @Resource
    EaiCanvasInfoService eaiCanvasInfoService;

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean saveApiInfo(AddApiInfoDto addApiInfoDto) {
        addApiInfoDto.setId(String.valueOf(EngineUtil.getId()));
        Boolean api = super.saveApiInfo(addApiInfoDto);
        if (!api.booleanValue()) {
            throw new BaseException(ERROR);
        }
        addApiInfoDto.setCreateCanvasFlag(true);
        EditApi editApi = this.fillEditApi(addApiInfoDto);
        this.eaiCanvasService.automaticConvertCanvas(addApiInfoDto, editApi);
        boolean edit = this.iEaiEditApiService.save((Object)editApi);
        if (!edit) {
            throw new BaseException(ERROR);
        }
        return true;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean saveFormDataApiInfo(AddBodyListApiInfoDto addApiInfoDto) {
        addApiInfoDto.setId(String.valueOf(EngineUtil.getId()));
        Boolean api = super.saveFormDataApiInfo(addApiInfoDto);
        if (!api.booleanValue()) {
            throw new BaseException(ERROR);
        }
        addApiInfoDto.setCreateCanvasFlag(true);
        EditApi editApi = this.fillEditApi(addApiInfoDto);
        this.eaiCanvasService.automaticConvertCanvas(addApiInfoDto, editApi);
        boolean edit = this.iEaiEditApiService.save((Object)editApi);
        if (!edit) {
            throw new BaseException(ERROR);
        }
        return true;
    }

    public Boolean deleteById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ApplicationManageVo applicationManageVo = this.iApplicationManagementService.getByAppCode(apiInfo.getApplicationCode());
        if (HussarUtils.isEmpty((Object)applicationManageVo)) {
            throw new HussarException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        if (HussarUtils.equals((Object)applicationManageVo.getAppStatus(), (Object)"0")) {
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"2")).eq(EaiResourcesInfo::getResourceRelationId, (Object)Long.valueOf(id))).set(EaiResourcesInfo::getDeleteState, (Object)"1");
            this.eaiResourcesInfoService.update((Wrapper)updateWrapper);
        } else if (HussarUtils.equals((Object)apiInfo.getApiState(), (Object)"1")) {
            throw new HussarException("\u5df2\u4e0a\u67b6\u63a5\u53e3\u4e0d\u80fd\u5220\u9664");
        }
        this.apiInfoService.removeById((Serializable)((Object)id));
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)id);
        EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)editApi)) {
            this.iEaiEditApiService.deleteByApiId(id);
            this.eaiCanvasInfoService.deleteApiCanvasInfo(editApi);
        }
        EaiAppEditManager.getInstance().call(apiInfo.getApplicationCode());
        return true;
    }

    public boolean deleteByAppCode(String appCode) {
        LambdaQueryWrapper apiWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)appCode);
        List apiInfos = this.apiInfoService.list((Wrapper)apiWrapper);
        if (HussarUtils.isNotEmpty((Object)apiInfos)) {
            this.apiInfoService.remove((Wrapper)apiWrapper);
            List ids = apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList());
            LambdaQueryWrapper editWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EditApi::getApiId, ids);
            List editApis = this.iEaiEditApiService.list((Wrapper)editWrapper);
            if (HussarUtils.isNotEmpty((Object)editApis)) {
                this.iEaiEditApiService.remove((Wrapper)editWrapper);
                this.eaiCanvasInfoService.deleteApiCanvasInfos(editApis);
            }
        }
        EaiAppEditManager.getInstance().call(appCode);
        return true;
    }
}

