/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apiinfolowcode.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl.ApiCommonManager;
import com.jxdinfo.hussar.eai.adapter.apiinfolowcode.server.service.LowCodeEaiReleaseApiService;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.service.IEaiPublishBaseService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.CheckApiCodeDto;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiPm;
import com.jxdinfo.hussar.support.choreo.api.service.ApiNamingService;
import com.jxdinfo.hussar.support.choreo.api.service.ApiPmService;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.lowcode.server.applicationrelease.releaseapi.service.impl.LowCodeEaiReleaseApiServiceImpl")
public class LowCodeEaiReleaseApiServiceImpl
extends ApiCommonManager
implements LowCodeEaiReleaseApiService {
    private static Logger logger = LoggerFactory.getLogger(LowCodeEaiReleaseApiServiceImpl.class);
    @Resource
    IEaiPublishBaseService lowCodePublishService;
    @Resource
    IEaiResourcesInfoService resourcesInfoService;
    @Resource
    ApiNamingService apiNamingService;
    @Resource
    NodeBusinessService nodeBusinessService;
    @Resource
    ApiPmService pmService;

    @HussarTransactional
    public Boolean saveApiInfo(AddApiInfoDto addApiInfoDto) {
        boolean flag;
        AssertUtil.isNotNull((Object)addApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        CheckApiCodeDto checkApiCodeDto = new CheckApiCodeDto();
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)checkApiCodeDto);
        if (!this.checkApiCode(checkApiCodeDto).booleanValue()) {
            throw new HussarException("\u63a5\u53e3\u6807\u8bc6\u4e0d\u552f\u4e00");
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getAddCommonStructureList()) && !(flag = this.eaiCommonStructureService.saveBatchStructure(addApiInfoDto.getAddCommonStructureList()).booleanValue())) {
            throw new HussarException("\u65b0\u589e\u5931\u8d25");
        }
        if (HussarUtils.equals((Object)EaiContentType.NONE.getTypeStr(), (Object)addApiInfoDto.getContentType())) {
            EaiParamsConvertDto dto = addApiInfoDto.getInParams();
            dto.setBody(null);
            addApiInfoDto.setInParams(dto);
        }
        ApiInfo apiInfo = new ApiInfo();
        this.fillApiInfo(addApiInfoDto, apiInfo);
        addApiInfoDto.setId(String.valueOf(apiInfo.getId()));
        this.saveCallInfo(addApiInfoDto, apiInfo);
        addApiInfoDto.setCreateCanvasFlag(true);
        EditApi editApi = this.fillEditApi(addApiInfoDto);
        this.iEaiEditApiService.save((Object)editApi);
        ArrayList<ApiInfo> apiInfos = new ArrayList<ApiInfo>(1);
        apiInfos.add(apiInfo);
        this.lowCodePublishService.publishApp(addApiInfoDto.getApplicationCode(), apiInfos, Boolean.valueOf(true));
        return true;
    }

    @HussarTransactional
    public Boolean deleteById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper q = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getResourceRelationId, (Object)Long.valueOf(id))).eq(EaiResourcesInfo::getDeleteState, (Object)"0");
        EaiResourcesInfo eaiResourcesInfo = (EaiResourcesInfo)this.resourcesInfoService.getOne((Wrapper)q);
        if (HussarUtils.isNotEmpty((Object)eaiResourcesInfo)) {
            this.removwEngine(eaiResourcesInfo.getResourceVersionId());
            ArrayList<ApiInfo> list = new ArrayList<ApiInfo>(1);
            list.add(apiInfo);
            this.lowCodePublishService.publishApp(eaiResourcesInfo.getApplicationCode(), list, Boolean.valueOf(false));
        }
        this.apiInfoService.removeById((Serializable)((Object)id));
        this.iEaiEditApiService.deleteByApiId(id);
        return true;
    }

    private void removwEngine(Long versionId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiNaming::getBusinessType, (Object)"HTTP")).eq(ApiNaming::getServiceId, (Object)versionId);
        ApiNaming apiNaming = (ApiNaming)this.apiNamingService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)apiNaming)) {
            LambdaQueryWrapper delWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiNaming::getServiceId, (Object)versionId);
            this.apiNamingService.remove((Wrapper)delWrapper);
            LambdaQueryWrapper pmQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiPm::getBusinessId, (Object)apiNaming.getBusinessId());
            this.pmService.remove((Wrapper)pmQueryWrapper);
            LambdaQueryWrapper nQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(NodeBusiness::getDataServiceCode, (Object)String.valueOf(versionId));
            this.nodeBusinessService.remove((Wrapper)nQueryWrapper);
        }
    }

    @Override
    @HussarTransactional
    public Boolean updateDetail(AddApiInfoDto addApiInfoDto) {
        boolean flag;
        AssertUtil.isNotNull((Object)addApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)addApiInfoDto.getId(), (String)"\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)addApiInfoDto.getId()));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (StringUtil.equals((CharSequence)"1", (CharSequence)apiInfo.getApplyState())) {
            throw new HussarException("\u63a5\u53e3\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        LambdaQueryWrapper q = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getResourceRelationId, (Object)apiInfo.getId())).eq(EaiResourcesInfo::getDeleteState, (Object)"0");
        EaiResourcesInfo eaiResourcesInfo = (EaiResourcesInfo)this.resourcesInfoService.getOne((Wrapper)q);
        if (HussarUtils.isNotEmpty((Object)eaiResourcesInfo)) {
            this.removwEngine(eaiResourcesInfo.getResourceVersionId());
        }
        AssertUtil.isNotEmpty((String)addApiInfoDto.getApiCode(), (String)"\u63a5\u53e3\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)apiInfo.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        CheckApiCodeDto checkApiCodeDto = new CheckApiCodeDto();
        checkApiCodeDto.setId(apiInfo.getId().toString());
        checkApiCodeDto.setApiCode(addApiInfoDto.getApiCode());
        checkApiCodeDto.setApplicationCode(apiInfo.getApplicationCode());
        if (!super.checkApiCode(checkApiCodeDto).booleanValue()) {
            throw new HussarException("\u63a5\u53e3\u6807\u8bc6\u4e0d\u552f\u4e00");
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getAddCommonStructureList()) && !(flag = this.eaiCommonStructureService.saveBatchStructure(addApiInfoDto.getAddCommonStructureList()).booleanValue())) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u7ed3\u6784\u4fdd\u5b58\u5931\u8d25");
        }
        if (HussarUtils.equals((Object)EaiContentType.NONE.getTypeStr(), (Object)addApiInfoDto.getContentType())) {
            EaiParamsConvertDto dto = addApiInfoDto.getInParams();
            dto.setBody(null);
            addApiInfoDto.setInParams(dto);
        }
        this.fillApiInfo4Update(addApiInfoDto, apiInfo);
        this.iEaiEditApiService.deleteByApiId(apiInfo.getId().toString());
        EditApi editApi = this.fillEditApi(addApiInfoDto);
        this.iEaiEditApiService.save((Object)editApi);
        this.saveCallInfo(addApiInfoDto, apiInfo);
        ArrayList<ApiInfo> list = new ArrayList<ApiInfo>(1);
        list.add(apiInfo);
        this.lowCodePublishService.publishApp(addApiInfoDto.getApplicationCode(), list, Boolean.valueOf(true));
        return true;
    }

    @HussarTransactional
    public Boolean importSwagger(byte[] content, String appCode) {
        String data = this.deserialize(content);
        List addApiInfos = this.dealInfo(data, appCode);
        if (HussarUtils.isEmpty((Object)addApiInfos)) {
            throw new HussarException("json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        List apiInfos = this.saveBatchApiInfos(addApiInfos);
        if (HussarUtils.isNotEmpty((Object)addApiInfos)) {
            this.lowCodePublishService.publishApp(appCode, apiInfos, Boolean.valueOf(true));
        }
        return true;
    }
}

