/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.server.enginegain.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiengine.api.service.IEaiGainParamsChangeService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.IEaiParamsChangeService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasEngineService;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.enginecommon.server.dto.CommonInitDto;
import com.jxdinfo.hussar.eai.enginecommon.server.service.CommonGainDataGhService;
import com.jxdinfo.hussar.eai.enginecommon.server.util.ApiLogManagement;
import com.jxdinfo.hussar.eai.server.enginegain.service.impl.LogicRunService;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.model.GhDataDto;
import com.jxdinfo.hussar.support.engine.api.model.GhDataInOutDto;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineIntercepts;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.core.annotations.SolidService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@SolidService(value="com.jxdinfo.hussar.eai.server.enginegain.service.impl.EaiGainParamsChangeServiceImpl", type=NodeTypeEnum.API, des="\u89e3\u6790\u5f15\u64ce\u53c2\u6570\u8f6c\u6362")
public class EaiGainParamsChangeServiceImpl
extends CommonGainDataGhService
implements IEaiGainParamsChangeService {
    @Resource
    private IEaiParamsChangeService iEaiParamsChangeService;
    @Resource
    private ApiLogManagement apiLogManagement;
    @Resource
    private ISysClientModelService sysClientModelService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysAppClientService sysAppClientService;
    @Resource
    private EaiCanvasEngineService eaiCanvasEngineService;
    @Resource
    EaiApiProperties properties;
    @Resource
    LogicRunService logicRunService;
    private EngineIntercepts engineIntercepts;

    public Object[] getParam(String methodName, List<GhDataInOutDto> inList, Object ... arg) {
        HussarException.throwBy((arg.length < 2 || !(arg[1] instanceof NodeBusinessVo) ? 1 : 0) != 0, (Integer)EngineExceptionEnum.PARAM_FAIL.getExceptionCode(), (String)EngineExceptionEnum.PARAM_FAIL.getMessage());
        NodeBusinessVo nodeBusinessVo = (NodeBusinessVo)arg[1];
        Object[] objects = new Object[1];
        if (1 == this.properties.getLogicType() && ((Boolean)arg[2]).booleanValue()) {
            HttpAuthVerifyDto obj = this.iEaiParamsChangeService.getAuthVerifyDtoBody(arg[0], nodeBusinessVo.getDataServiceCode());
            objects[0] = obj;
        } else {
            HttpAuthVerifyDto obj = this.iEaiParamsChangeService.getApiTestDto(arg[0], nodeBusinessVo.getDataServiceCode());
            objects[0] = obj;
        }
        return objects;
    }

    public Object startInvoke(NodeBusinessVo nodeBusinessVo, Map<String, Object> params) {
        Long start = System.currentTimeMillis();
        String appCode = nodeBusinessVo.getDataServiceCode();
        SysApplication application = this.checkApplicationCaller();
        boolean hasAuth = true;
        if (ToolUtil.isNotEmpty((Object)application) && "0".equals(application.getAppStatus())) {
            hasAuth = false;
        }
        CommonInitDto commonInitDto = super.initInvoke(nodeBusinessVo, params, application, start, Boolean.valueOf(hasAuth));
        GhDataDto ghDataDto = commonInitDto.getGhDataDto();
        String methodName = commonInitDto.getMethodName();
        Object ownerBean = commonInitDto.getOwnerBean();
        this.intercept(nodeBusinessVo, params, 1);
        String jsonParams = nodeBusinessVo.getJsonParams();
        Object[] invokeParams = this.getParam(methodName, ghDataDto.getIns(), params, nodeBusinessVo, HussarUtils.isNotEmpty((Object)jsonParams));
        if (HussarUtils.isNotEmpty((Object)jsonParams) && 1 == this.properties.getLogicType()) {
            return this.logicRunService.logicInvoke(application, params, jsonParams, invokeParams[0], nodeBusinessVo, start);
        }
        if (HussarUtils.isNotEmpty((Object)nodeBusinessVo.getCallBackMethodName())) {
            this.apiLogManagement.formatErrorApiLogs(HussarUtils.isEmpty((Object)ownerBean), application, appCode, params, start, EngineExceptionEnum.IN_PARAMS_ERROR.getExceptionCode(), EngineExceptionEnum.IN_PARAMS_ERROR.getMessage());
            int length = invokeParams.length;
            invokeParams = Arrays.copyOf(invokeParams, length + 1);
            invokeParams[length] = nodeBusinessVo.getCallBackMethodName();
        }
        this.intercept(nodeBusinessVo, invokeParams, 2);
        return this.methodInvoke(nodeBusinessVo, params, commonInitDto, application, invokeParams, start);
    }

    private void intercept(NodeBusinessVo nodeBusinessVo, Object result, int type) {
        try {
            if (this.engineIntercepts != null && HussarUtils.isNotEmpty((Object)this.engineIntercepts.getParamHandlers())) {
                for (EngineParamHandler handler : this.engineIntercepts.getParamHandlers()) {
                    if (type == 1) {
                        handler.pmHandling((Map)result, nodeBusinessVo);
                        continue;
                    }
                    if (type == 2) {
                        handler.ghPmHandling((Object[])result, nodeBusinessVo);
                        continue;
                    }
                    if (type != 3) continue;
                    handler.resultHandling(result, nodeBusinessVo);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SysApplication checkApplicationCaller() {
        SysAppClient sysAppClient;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        String clientId = "";
        if (ToolUtil.isNotEmpty((Object)request)) {
            clientId = request.getHeader("client-id");
        }
        if (ToolUtil.isEmpty((Object)clientId)) {
            return null;
        }
        SysClientModel clientModel = (SysClientModel)this.sysClientModelService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysClientModel::getClientId, (Object)clientId));
        SysApplication application = null;
        if (ToolUtil.isNotEmpty((Object)clientModel) && ToolUtil.isNotEmpty((Object)(sysAppClient = (SysAppClient)this.sysAppClientService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getClientModelId, (Object)clientModel.getId()))))) {
            application = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)sysAppClient.getAppId()));
        }
        return application;
    }
}

