/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.enginecommon.server.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.IEaiParamsChangeService;
import com.jxdinfo.hussar.eai.logs.api.runtimelogs.model.ApiLogs;
import com.jxdinfo.hussar.eai.logs.api.runtimelogs.service.IEaiApiLogsService;
import com.jxdinfo.hussar.platform.core.utils.ExceptionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.common.server.logsruntime.util.ApiLogManagement")
public class ApiLogManagement {
    @Resource
    IEaiApiLogsService eaiApiLogsService;
    @Resource
    IEaiParamsChangeService iEaiParamsChangeService;
    private static final String FAIL = "1";
    private static final Logger log = LoggerFactory.getLogger(ApiLogManagement.class);
    private static final String ERROR = "\u672a\u4f20\u9012client-id";
    @Resource
    ISysApplicationService sysApplicationService;
    private static final Long minute = 60000L;
    private static final Long second = 1000L;
    private static final String second_str = "\u79d2";
    private static final String ms_str = "\u6beb\u79d2";
    private static final String minute_str = "\u5206";

    public void formatErrorApiLogs(boolean isError, SysApplication application, String appCode, Object params, Long start, Integer code, String msg) {
        if (isError) {
            HussarException hussarException = new HussarException(code, msg);
            this.formatErrorApiLogs(appCode, application, params, null, start, hussarException);
            throw hussarException;
        }
    }

    public void formatErrorApiLogs(String apiCode, SysApplication application, Object inparams, Object inParamsReal, Long start, Throwable err) {
        this.formatApiLogs(apiCode, application, inparams, null, inParamsReal, null, FAIL, start, err);
    }

    public void formatApiLogs(String apiCode, SysApplication application, Object inparams, Object outParamsReal, Object inParamsReal, Object outParams, String state, Long start, Throwable err) {
        Long end = System.currentTimeMillis();
        String time = this.getTimeStr(start, end);
        EaiApiVersion eaiApiVersion = this.iEaiParamsChangeService.getApiVersionInfo(apiCode);
        ApiLogs apiLogs = new ApiLogs();
        apiLogs.setApiCode(apiCode);
        apiLogs.setApiName(eaiApiVersion.getApiName());
        apiLogs.setApiPath(eaiApiVersion.getApiPath());
        if (HussarUtils.isNotEmpty((Object)err)) {
            apiLogs.setConnError(ExceptionUtil.stacktraceToString((Throwable)err, (int)100000));
        }
        apiLogs.setConnState(state);
        apiLogs.setId(EngineUtil.getId());
        if (HussarUtils.isNotEmpty((Object)inparams)) {
            apiLogs.setInParams(JSON.toJSONString((Object)inparams));
        }
        if (HussarUtils.isNotEmpty((Object)inParamsReal)) {
            apiLogs.setInParamsReal(this.toString(inParamsReal));
        }
        if (HussarUtils.isNotEmpty((Object)outParams)) {
            apiLogs.setOutParams(this.toString(outParams));
        }
        if (HussarUtils.isNotEmpty((Object)outParamsReal)) {
            apiLogs.setOutParamsReal(this.toString(outParamsReal));
        }
        if (application != null) {
            apiLogs.setFromAppName(application.getAppName());
            apiLogs.setFromAppCode(application.getAppCode());
        } else {
            try {
                Map map = this.iEaiParamsChangeService.getFromHeader();
                apiLogs.setFromAppName(String.format("\u672a\u77e5\u5ba2\u6237\u7aef:%s", map.get("client-id")));
            }
            catch (Exception e) {
                log.error(ERROR);
            }
        }
        String versionCode = eaiApiVersion.getApplicationCode();
        apiLogs.setToAppCode(versionCode);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)versionCode);
        SysApplication toApplication = (SysApplication)this.sysApplicationService.getOne((Wrapper)queryWrapper);
        apiLogs.setToAppName(toApplication.getAppName());
        apiLogs.setConnDuration(time);
        apiLogs.setHostIp(IpUtils.getIp());
        try {
            this.eaiApiLogsService.save((Object)apiLogs);
            if (ERROR.equals(state)) {
                log.error(JSON.toJSONString((Object)apiLogs));
            }
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38:", (Throwable)e);
        }
    }

    private String toString(Object obj) {
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        return JSON.toJSONString((Object)obj);
    }

    public String getTimeStr(Long start, Long end) {
        Long time = end - start;
        StringBuilder sb = new StringBuilder();
        if (time > minute) {
            sb.append(time / minute).append(minute_str).append(time % minute / second).append(second_str);
        } else if (time > second) {
            sb.append(time / second).append(second_str).append(time % second).append(ms_str);
        } else {
            sb.append(time).append(ms_str);
        }
        return sb.toString();
    }
}

