/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.enginecommon.server.service;

import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.IEaiParamsChangeService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.enginecommon.server.util.ApiLogManagement;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.enginecommon.server.service.CommonResultFormatService")
public class CommonResultFormatService {
    @Resource
    private ApiLogManagement apiLogManagement;
    @Resource
    private IEaiParamsChangeService eaiParamsChangeService;
    private static final String SUCCESS = "0";
    private static final String FAIL = "1";
    private static final String API_ERROR = "\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38";
    private static final String ERROR_CONVERT = "\u65e0\u6cd5\u8f6c\u6362\u63a5\u53e3\u8fd4\u56de\u503c,\u8bf7\u68c0\u67e5\u63a5\u53e3\u8fd4\u56de\u503c\u914d\u7f6e";
    private static final String UNKNOWN = "unknown";

    public Object result(Object obj, SysApplication application, NodeBusinessVo nodeBusinessVo, Map<String, Object> params, Object[] invokeParams, Long start) {
        Object old = obj;
        Object body = null;
        if (HussarUtils.isNotEmpty((Object)obj)) {
            if (obj instanceof ApiResponse) {
                ApiResponse result = ApiResponse.success();
                if (!((ApiResponse)obj).isSuccess()) {
                    result = ApiResponse.fail((String)((ApiResponse)obj).getMsg());
                }
                if ((body = ((ApiResponse)obj).getData()) instanceof EaiApiResponseVo) {
                    EaiApiResponse eaiApiResponse = ((EaiApiResponseVo)body).getOuturlResponse();
                    if (HussarUtils.isEmpty((Object)eaiApiResponse)) {
                        this.apiLogManagement.formatApiLogs(nodeBusinessVo.getDataServiceCode(), application, params, eaiApiResponse, invokeParams[0], result, FAIL, start, new Throwable(((ApiResponse)obj).getMsg()));
                        return result;
                    }
                    body = this.eaiParamsChangeService.getResponseResult(eaiApiResponse.getBody(), nodeBusinessVo.getDataServiceCode());
                    if (HussarUtils.isNotEmpty((Object)body) && body instanceof EaiApiParams) {
                        this.apiLogManagement.formatApiLogs(nodeBusinessVo.getDataServiceCode(), application, params, eaiApiResponse, invokeParams[0], ((EaiApiParams)body).getBody(), FAIL, start, new Throwable(ERROR_CONVERT));
                        return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)((EaiApiParams)body).getBody(), (String)ERROR_CONVERT);
                    }
                    result.setData(body);
                    String state = result.isSuccess() ? SUCCESS : FAIL;
                    this.apiLogManagement.formatApiLogs(nodeBusinessVo.getDataServiceCode(), application, params, eaiApiResponse, invokeParams[0], result, state, start, null);
                    return result;
                }
            } else {
                obj = ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)obj, (String)API_ERROR);
                this.apiLogManagement.formatApiLogs(nodeBusinessVo.getDataServiceCode(), application, params, old, invokeParams[0], obj, FAIL, start, new Throwable(API_ERROR));
            }
        }
        this.apiLogManagement.formatApiLogs(nodeBusinessVo.getDataServiceCode(), application, params, old, invokeParams[0], obj, FAIL, start, new Throwable(UNKNOWN));
        return obj;
    }

    public Object result(Object obj, NodeBusinessVo nodeBusinessVo, Map<String, Object> params, Object[] invokeParams, Long start) {
        return this.result(obj, null, nodeBusinessVo, params, invokeParams, start);
    }
}

