/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.transform;

import com.jxdinfo.hussar.ds.common.exception.DpExceptionEnum;
import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.TransformRowConfigDto;
import com.jxdinfo.hussar.ds.process.component.model.TransformRowToColumnConfigModel;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.AggregateTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransformRowToColumnWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(TransformRowToColumnWorker.class);

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.TRANSFORM_ROW_TO_COLUMN;
    }

    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        try {
            TransformRowToColumnConfigModel transformRowToColumnConfigModel = (TransformRowToColumnConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), TransformRowToColumnConfigModel.class);
            try (Statement statement = connection.createStatement();){
                String groupFields = transformRowToColumnConfigModel.getGroupFields().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.joining(","));
                String sql = this.prepareSql("_main", groupFields, transformRowToColumnConfigModel.getTransformConfig());
                statement.execute(sql);
            }
            return TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
        }
        catch (Exception e) {
            logger.error("\u884c\u8f6c\u5217\u7ec4\u4ef6\u6267\u884c\u5f02\u5e38", (Throwable)e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.EXECUTION_EXCEPTION_ROW_TRANSFORM_COL_STATEMENT.getCode()), DpExceptionEnum.EXECUTION_EXCEPTION_ROW_TRANSFORM_COL_STATEMENT.getMessage(), (Throwable)e);
        }
    }

    private String prepareSql(String tableName, String groupFields, TransformRowConfigDto transformConfigDto) {
        String sourceField = transformConfigDto.getSourceFieldName();
        String aggregateType = AggregateTypeEnum.getSql((String)transformConfigDto.getAggregateType());
        String targetValue = transformConfigDto.getTargetValueName();
        List targetFields = Optional.ofNullable(transformConfigDto.getTargetFields()).orElse(Collections.emptyList());
        String aggregateFields = targetFields.stream().map(targetField -> this.buildSingleAggregateField(aggregateType, sourceField, targetValue, (ColumnFieldDto)targetField)).collect(Collectors.joining(","));
        return "CREATE OR REPLACE TABLE " + tableName + " AS\n" + "SELECT " + groupFields + "," + aggregateFields + "\n" + "FROM " + tableName + "\n" + "GROUP BY " + groupFields;
    }

    private String buildSingleAggregateField(String aggregateType, String sourceField, String targetValue, ColumnFieldDto targetField) {
        return String.format("%s(CASE WHEN %s = '%s' THEN %s END) AS %s", aggregateType, sourceField, targetField.getComment(), targetValue, targetField.getFieldId());
    }

    public static void main(String[] args) {
        String tableName = "table_name";
        String groupFields = "id,name";
        TransformRowConfigDto transformConfigDto = new TransformRowConfigDto();
        ArrayList<String> sourceFields = new ArrayList<String>();
        sourceFields.add("hussar_2");
        sourceFields.add("\u5b66\u79d1");
        transformConfigDto.setSourceField(sourceFields);
        ColumnFieldDto columnFieldDto = new ColumnFieldDto();
        columnFieldDto.setFieldId("score");
        columnFieldDto.setName("\u8bed\u6587");
        columnFieldDto.setComment("\u8bed\u6587");
        columnFieldDto.setDataType("int");
        transformConfigDto.setAggregateType("sum");
        ArrayList<String> targetValues = new ArrayList<String>();
        targetValues.add("hussar_2");
        targetValues.add("\u6210\u7ee9");
        transformConfigDto.setTargetValue(targetValues);
        ArrayList<ColumnFieldDto> targetFields = new ArrayList<ColumnFieldDto>();
        targetFields.add(columnFieldDto);
        transformConfigDto.setTargetFields(targetFields);
        String sql = new TransformRowToColumnWorker().prepareSql(tableName, groupFields, transformConfigDto);
        System.out.println(sql);
    }
}

