/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.sortedfield;

import com.jxdinfo.hussar.ds.common.exception.DpExceptionEnum;
import com.jxdinfo.hussar.ds.process.component.model.SortedFieldConfigModel;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SortedFieldTaskWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(SortedFieldTaskWorker.class);

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.SORT_FIELD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        List config = JsonUtil.parseArray((String)detailConfig.getConfig(), SortedFieldConfigModel.class);
        try (Statement statement = connection.createStatement();){
            String sql = "CREATE OR REPLACE TABLE _main AS select * from _main ORDER BY ";
            String orderInfo = config.stream().map(action -> String.format(" %s %s ", action.getFieldId(), action.getSort().name())).collect(Collectors.joining(","));
            statement.execute(sql + orderInfo);
            TaskResult taskResult = TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
            return taskResult;
        }
        catch (SQLException e) {
            logger.error("\u6392\u5e8f\u7ec4\u4ef6\u8bed\u53e5\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.EXECUTION_EXCEPTION_SORTED_FIELD_STATEMENT.getCode()), DpExceptionEnum.EXECUTION_EXCEPTION_SORTED_FIELD_STATEMENT.getMessage(), (Throwable)e);
        }
    }
}

