/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetOperationDto;
import com.jxdinfo.hussar.dataset.model.ApiDataContent;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.model.DataSetCondition;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetEngineService;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.ds.process.component.dto.DataSetFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.core.util.ColumnDataUtil;
import com.jxdinfo.hussar.ds.process.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.FieldTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.IDataSetExecuteService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSetIdExecuteServiceImpl
implements IDataSetExecuteService {
    @Autowired
    private IDataSetEngineService dataSetEngineService;
    @Autowired
    private IDataSetService dataSetService;
    private MybatisPlusPluginProperties mybatisPlusPluginProperties;

    public DataSetIdExecuteServiceImpl(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
    }

    @Override
    public List<JSONObject> getDataSetData(DataSetInputConfigModel config) {
        try {
            DataSetCommonParam param = new DataSetCommonParam();
            param.setUnifiedId(config.getDataSetId() + "");
            DataSetCondition dataSetCondition = new DataSetCondition();
            dataSetCondition.setSize(this.mybatisPlusPluginProperties.getPageLimit().intValue());
            param.setDataSetCondition(dataSetCondition);
            dataSetCondition.setDataSetId("" + config.getDataSetId());
            DataSetTypeEnum dataSetTypeEnum = DataSetTypeEnum.valueOfCode((String)config.getDataSetType());
            dataSetCondition.setDataSetFunctionType(config.getDataSetType());
            ApiResponse listApiResponse = this.dataSetEngineService.executeDataSetParam(Collections.singletonList(param));
            List data = (List)listApiResponse.getData();
            for (DataSetExecuteVO datum : data) {
                String returnValue = datum.getReturnValue();
                if (!StringUtil.equals((String)config.getDataSetId(), (String)datum.getDataSetId()) || !HussarUtils.isNotEmpty((Object)returnValue)) continue;
                Map<String, String> id2FieldId = config.getFieldList().stream().collect(Collectors.toMap(DataSetFieldDto::getId, DataSetFieldDto::getFieldId));
                return this.getReturnValueById(dataSetTypeEnum, config.getDataSetId(), returnValue, id2FieldId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HussarException("\u83b7\u53d6\u6570\u636e\u96c6\u6570\u636e\u4fe1\u606f\u5f02\u5e38.");
        }
        return Lists.newArrayListWithCapacity((int)0);
    }

    private List<JSONObject> getReturnValueById(DataSetTypeEnum dataSetTypeEnum, String dataSetId, String data, Map<String, String> id2FieldId) {
        WordDataSetInfo wordDataSetInfo = (WordDataSetInfo)this.dataSetService.getById((Serializable)((Object)dataSetId));
        DataSetConfigInfoDto dataSetDataDto = (DataSetConfigInfoDto)JsonUtil.parse((String)wordDataSetInfo.getData(), DataSetConfigInfoDto.class);
        List operations = dataSetDataDto.getOperations();
        HussarException.throwByNull((Object)operations, (String)"\u83b7\u53d6\u6570\u636e\u5b9a\u4e49\u5f02\u5e38");
        DataSetOperationDto dataSetOperationDto = (DataSetOperationDto)operations.get(0);
        ApiDataContent returnValue = dataSetOperationDto.getReturnValue();
        JSONObject columnDef = ColumnDataUtil.splitColumnInfo((List)returnValue.getProperties(), id2FieldId);
        return ColumnDataUtil.changeValue((String)data, (JSONObject)columnDef, (boolean)FieldTypeEnum.ARRAY.match(returnValue.getObjectType()));
    }

    @Override
    public List<DataSetTypeEnum> getDataSetType() {
        return Arrays.asList(DataSetTypeEnum.API, DataSetTypeEnum.DATA_STREAM);
    }
}

