/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.service;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ds.process.core.util.DuckDBUtil;
import com.jxdinfo.hussar.ds.process.dto.DataStreamDataResponseDto;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.service.DataStreamTaskLogInfoService;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class DataStreamProcessWorker {
    @Resource
    protected ThreadPoolTaskExecutor threadPoolTaskExecutor;
    Logger log = LoggerFactory.getLogger(DataStreamProcessWorker.class);
    @Autowired
    private DataStreamTaskLogInfoService taskLogInfoService;

    public String getTaskDefName() {
        String sign = System.getProperty("sign");
        if (ObjectUtil.isNotEmpty((Object)sign)) {
            return this.getTaskType().name() + sign;
        }
        return this.getTaskType().name();
    }

    public abstract ModuleTypeEnum getTaskType();

    public abstract TaskResult execute(Task var1, CanvasDetailConfigDTO var2, DuckDBConnection var3);

    /*
     * Exception decompiling
     */
    public TaskResult execute(Task task) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveInstanceResult(Task task, boolean isError, String message) {
        DataStreamDataResponseDto result = DataStreamDataResponseDto.success((String)message);
        if (isError) {
            result = DataStreamDataResponseDto.error((String)message);
        }
        HussarFixedCacheUtil.put((String)"ds", (Object)"work_flow_instance:".concat(task.getWorkflowInstanceId()), (Object)result, (long)TimeUnit.HOURS.toSeconds(1L));
        HussarFixedCacheUtil.evict((String)"ds", (Object)"data_set_2_instance:".concat(task.getWorkflowType()));
    }

    public DuckDBConnection getDuckDbConnection(Task task) {
        try {
            String path = DuckDBUtil.getDuckDbPath((Long)task.getStartTime(), (String)task.getWorkflowInstanceId());
            Properties properties = new Properties();
            properties.setProperty("default_collation", "zh_CN");
            return (DuckDBConnection)DriverManager.getConnection(path, properties);
        }
        catch (Exception e) {
            this.log.error("DuckDBConnection\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
            throw new HussarException("DuckDBConnection\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public void rollbackDuckDB(DuckDBConnection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                this.log.error("\u6267\u884c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void closeDuckDB(DuckDBConnection connection, Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                this.log.error("\u6267\u884c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.log.error("\u6267\u884c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.log.error("\u6267\u884c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void showTableData(DuckDBConnection connection, String remark) {
        block53: {
            block52: {
                block51: {
                    String sign = System.getProperty("sign");
                    if (!ObjectUtil.isEmpty((Object)sign)) break block51;
                    try {
                        this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\u5904\u7406\u5b8c\u6bd5", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog()});
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try (Statement statement = connection.createStatement();
                     ResultSet tableResult = statement.executeQuery("SHOW ALL TABLES");){
                    List maps = DuckDBUtil.resultSetToList((ResultSet)tableResult);
                    if (!maps.stream().anyMatch(action -> "_main".equals(action.getString("name")))) break block52;
                    try (ResultSet resultSet = statement.executeQuery("select * from _main");){
                        this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\uff1a{}", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog(), JSONObject.toJSONString((Object)DuckDBUtil.resultSetToList((ResultSet)resultSet))});
                    }
                }
                catch (Exception e) {
                    this.log.error("showTableData \u5904\u7406\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
            try {
                this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\u5904\u7406\u5b8c\u6bd5", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog()});
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            break block53;
            catch (Exception e) {
                try {
                    this.log.error("showTableData \u5904\u7406\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\u5904\u7406\u5b8c\u6bd5", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog()});
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\u5904\u7406\u5b8c\u6bd5", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog()});
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }
}

