/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.input;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ds.common.exception.DpExceptionEnum;
import com.jxdinfo.hussar.ds.process.component.dto.DataSetFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.util.DataTypeUtil;
import com.jxdinfo.hussar.ds.process.util.GroupingListUtil;
import com.jxdinfo.hussar.ds.process.work.factory.DataSetExecuteFactory;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataSetInputTaskWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(DataSetInputTaskWorker.class);

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.DATA_SET_INPUT;
    }

    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        DataSetInputConfigModel config = (DataSetInputConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), DataSetInputConfigModel.class);
        List<JSONObject> result = DataSetExecuteFactory.get(config.getDataSetType()).getDataSetData(config);
        String fieldDefList = config.getFieldList().stream().map(action -> String.format(" %s %s", action.getFieldId(), DataTypeUtil.getDuckDbType((String)action.getDataType()))).collect(Collectors.joining(","));
        List fieldListInfo = config.getFieldList();
        String fieldIdsStr = config.getFieldList().stream().map(DataSetFieldDto::getFieldId).collect(Collectors.joining(","));
        String fieldCount = config.getFieldList().stream().map(action -> "?").collect(Collectors.joining(","));
        try (Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE TABLE _main (%s);", fieldDefList));
            String insertSql = String.format("INSERT INTO  _main (%s) VALUES (%s);", fieldIdsStr, fieldCount);
            List groupingList = GroupingListUtil.groupingList(result);
            groupingList.parallelStream().forEach(list -> {
                DuckDBConnection conn2 = null;
                PreparedStatement stmt = null;
                try {
                    conn2 = this.getDuckDbConnection(task);
                    stmt = conn2.prepareStatement(insertSql);
                    conn2.setAutoCommit(false);
                    for (JSONObject jsonObject : list) {
                        for (int i = 0; i < fieldListInfo.size(); ++i) {
                            DataSetFieldDto dataSetFieldDto = (DataSetFieldDto)fieldListInfo.get(i);
                            Object value = DataTypeUtil.getDataByKeyAndType((JSONObject)jsonObject, (String)dataSetFieldDto.getDataType(), (String)dataSetFieldDto.getFieldId());
                            stmt.setObject(i + 1, value);
                        }
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                    conn2.commit();
                    stmt.clearBatch();
                }
                catch (SQLException e) {
                    try {
                        logger.error("\u8f93\u5165\u7ec4\u4ef6\u6267\u884c\u5e76\u884c\u63d2\u5165\u6570\u636e\u5f02\u5e38:", (Throwable)e);
                        this.rollbackDuckDB(conn2);
                        throw new HussarException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        this.closeDuckDB(conn2, stmt);
                        throw throwable;
                    }
                }
                this.closeDuckDB(conn2, stmt);
            });
        }
        catch (HussarException | SQLException e) {
            logger.error("\u8f93\u5165\u7ec4\u4ef6\u8bed\u53e5\u6267\u884c\u5f02\u5e38:", e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.EXECUTION_EXCEPTION_INPUT_STATEMENT.getCode()), DpExceptionEnum.EXECUTION_EXCEPTION_INPUT_STATEMENT.getMessage(), e);
        }
        return TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
    }
}

