/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.filterfield;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.ds.common.exception.DpExceptionEnum;
import com.jxdinfo.hussar.ds.process.component.model.FilterFieldConfigModel;
import com.jxdinfo.hussar.ds.process.core.util.DuckDBUtil;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.FieldTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.dto.FieldMappingDto;
import com.jxdinfo.hussar.support.mp.base.query.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.mp.base.query.enums.QueryRuleEnum;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FilterFieldTaskWorker
extends DataStreamProcessWorker {
    private static final Logger log = LoggerFactory.getLogger(FilterFieldTaskWorker.class);

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.FILTER_FIELD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        List config = JsonUtil.parseArray((String)detailConfig.getConfig(), FilterFieldConfigModel.class);
        String sql = "CREATE OR REPLACE TABLE _main AS select * from _main where ";
        HashMap<Integer, Object> param = new HashMap<Integer, Object>();
        QueryWrapper wrapper = new QueryWrapper();
        for (FilterFieldConfigModel model : config) {
            this.getSqlByConfig(model, param, wrapper);
        }
        log.info("filterSql={}", (Object)(sql + wrapper.getTargetSql()));
        try (PreparedStatement statement = connection.prepareStatement(sql + wrapper.getTargetSql());){
            for (Integer key : param.keySet()) {
                statement.setObject(key, param.get(key));
            }
            statement.execute();
            TaskResult taskResult = TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
            return taskResult;
        }
        catch (SQLException e) {
            log.error("\u8fc7\u6ee4\u7b5b\u9009\u7ec4\u4ef6\u8bed\u53e5\u6267\u884c\u5f02\u5e38.", (Throwable)e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.EXECUTION_EXCEPTION_FILTER_FIELD_STATEMENT.getCode()), DpExceptionEnum.EXECUTION_EXCEPTION_FILTER_FIELD_STATEMENT.getMessage(), (Throwable)e);
        }
    }

    protected void getSqlByConfig(FilterFieldConfigModel config, Map<Integer, Object> param, QueryWrapper<?> wrapper) {
        FieldMappingDto fieldMappingDto = new FieldMappingDto();
        fieldMappingDto.setFieldValue((Object)config.getValue());
        fieldMappingDto.setColumnName(config.getFieldId());
        fieldMappingDto.setFieldClassType(FieldTypeEnum.fromValue((String)config.getDataType()).getJavaType());
        QueryRuleEnum queryRuleEnum = QueryRuleEnum.getByValue((String)config.getRule());
        queryRuleEnum.getQueryStrategy().transFieldValue(fieldMappingDto);
        queryRuleEnum.getQueryStrategy().joinQueryWrapper(wrapper, fieldMappingDto);
        if (HussarUtils.isNotEmpty((Object)config.getMatch()) && MatchTypeEnum.getByValue((String)config.getMatch().toUpperCase()) == MatchTypeEnum.OR) {
            wrapper.or();
        }
        if (Arrays.asList(QueryRuleEnum.LEFT_LIKE, QueryRuleEnum.RIGHT_LIKE, QueryRuleEnum.NOT_LEFT_LIKE, QueryRuleEnum.NOT_RIGHT_LIKE).contains(queryRuleEnum)) {
            return;
        }
        if (HussarUtils.isNotEmpty((Object)fieldMappingDto.getFieldValues())) {
            for (Object fieldValue : fieldMappingDto.getFieldValues()) {
                int i = param.keySet().stream().mapToInt(a -> a).max().orElse(0);
                if (Arrays.asList(QueryRuleEnum.LIKE, QueryRuleEnum.NOT_LIKE).contains(queryRuleEnum)) {
                    param.put(i + 1, "%" + fieldValue + "%");
                    continue;
                }
                param.put(i + 1, fieldValue);
            }
        } else if (HussarUtils.isNotEmpty((Object)fieldMappingDto.getFieldValue())) {
            int i = param.keySet().stream().mapToInt(a -> a).max().orElse(0);
            if (Arrays.asList(QueryRuleEnum.LIKE, QueryRuleEnum.NOT_LIKE).contains(queryRuleEnum)) {
                param.put(i + 1, "%" + fieldMappingDto.getFieldValue() + "%");
            } else {
                param.put(i + 1, fieldMappingDto.getFieldValue());
            }
        }
    }

    public static void main(String[] args) {
        FilterFieldTaskWorker filterFieldTaskWorker = new FilterFieldTaskWorker();
        Task task = new Task();
        task.setWorkflowInstanceId(UUID.randomUUID().toString());
        try (DuckDBConnection duckDbConnection = filterFieldTaskWorker.getDuckDbConnection(task);
             Statement statement = duckDbConnection.createStatement();){
            statement.execute("create table _main (x integer,y integer,z integer)");
            try (PreparedStatement preparedStatement = duckDbConnection.prepareStatement("insert into _main (x,y,z) values (?,?,?)");){
                for (int i = 1; i < 1000; ++i) {
                    preparedStatement.setInt(1, i);
                    preparedStatement.setInt(2, 1000 - i);
                    preparedStatement.setInt(3, i % 100);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            ArrayList<FilterFieldConfigModel> list = new ArrayList<FilterFieldConfigModel>();
            FilterFieldConfigModel model = new FilterFieldConfigModel();
            list.add(model);
            model.setFieldId("x");
            model.setDataType("int");
            model.setValue("123");
            model.setRule("_lt");
            model.setMatch("and");
            CanvasDetailConfigDTO detail = new CanvasDetailConfigDTO();
            detail.setConfig(list);
            filterFieldTaskWorker.execute(new Task(), detail, duckDbConnection);
            try (ResultSet resultSet = statement.executeQuery("select * from _main");){
                System.out.println(JSONObject.toJSONString((Object)DuckDBUtil.resultSetToList((ResultSet)resultSet)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

