/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.factory;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.hussar.ds.process.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.IDataSetExecuteService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSetExecuteFactory {
    Logger log = LoggerFactory.getLogger(DataSetExecuteFactory.class);
    @Autowired(required=false)
    private List<IDataSetExecuteService> taskParamParserList;
    private static final Map<String, IDataSetExecuteService> taskInputParamMap = new HashMap<String, IDataSetExecuteService>();

    public static void register(IDataSetExecuteService taskParamParser) {
        for (DataSetTypeEnum dataSetTypeEnum : taskParamParser.getDataSetType()) {
            taskInputParamMap.put(dataSetTypeEnum.getCode(), taskParamParser);
        }
    }

    public static IDataSetExecuteService get(String code) {
        return taskInputParamMap.get(code);
    }

    public static Map<String, IDataSetExecuteService> getAll() {
        return taskInputParamMap;
    }

    public static void register(String name, IDataSetExecuteService taskParamParser) {
        taskInputParamMap.put(name, taskParamParser);
    }

    @PostConstruct
    public void init() {
        if (ObjectUtils.isNotEmpty(this.taskParamParserList)) {
            this.taskParamParserList.forEach(DataSetExecuteFactory::register);
        }
        Map<String, IDataSetExecuteService> all = DataSetExecuteFactory.getAll();
        all.forEach((k, v) -> this.log.debug("\u7ec4\u4ef6\uff1a{}, \u5bf9\u5e94\u53c2\u6570\u7ec4\u88c5\u6267\u884c\u5668:{}", k, (Object)v.getClass().getName()));
    }
}

