/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.equationfield;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ds.common.exception.DpExceptionEnum;
import com.jxdinfo.hussar.ds.process.component.model.EquationFieldConfigModel;
import com.jxdinfo.hussar.ds.process.core.util.DuckDBUtil;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.formula.dto.FormulaConfigDTO;
import com.jxdinfo.hussar.ds.process.formula.model.ExprNode;
import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.util.DataTypeUtil;
import com.jxdinfo.hussar.ds.process.util.GroupingListUtil;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EquationFieldTaskWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(EquationFieldTaskWorker.class);

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.EQUATION_FIELD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        EquationFieldConfigModel config = (EquationFieldConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), EquationFieldConfigModel.class);
        String uuid = IdUtil.simpleUUID();
        try (Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE _equation_%s AS select * from _main where 1!=1 ", uuid));
            String addColumnSql = String.format("ALTER TABLE _equation_%s ADD COLUMN %s %s;", uuid, config.getForm().getFieldId(), DataTypeUtil.getDuckDbType((String)config.getForm().getDataType()));
            statement.execute(addColumnSql);
            String sql = "select * from _main";
            try (ResultSet resultSet = statement.executeQuery(sql);){
                List tempList = DuckDBUtil.resultSetToList((ResultSet)resultSet);
                if (HussarUtils.isNotEmpty((Object)tempList)) {
                    FormulaConfigDTO equationFieldConfigModel = (FormulaConfigDTO)HussarUtils.copy((Object)config.getFormula(), FormulaConfigDTO.class);
                    ExprNode exprNode = ExpressionParser.BuildByConfig((FormulaConfigDTO)equationFieldConfigModel);
                    for (JSONObject map : tempList) {
                        Object evaluate = exprNode.evaluate((Map)map);
                        map.put(config.getForm().getFieldId(), evaluate);
                    }
                    JSONObject firstRow = (JSONObject)tempList.get(0);
                    ArrayList keys = new ArrayList(firstRow.keySet());
                    String columns = HussarUtils.join(keys, (String)",");
                    String placeholders = keys.stream().map(key -> "?").collect(Collectors.joining(","));
                    String insertSql = String.format("insert into _equation_%s (%s) values (%s)", uuid, columns, placeholders);
                    List groupingList = GroupingListUtil.groupingList((List)tempList);
                    groupingList.parallelStream().forEach(list -> {
                        DuckDBConnection conn2 = null;
                        PreparedStatement stmt = null;
                        try {
                            conn2 = this.getDuckDbConnection(task);
                            stmt = conn2.prepareStatement(insertSql);
                            conn2.setAutoCommit(false);
                            for (JSONObject map : list) {
                                for (int i = 0; i < keys.size(); ++i) {
                                    String key = (String)keys.get(i);
                                    Object value = map.get((Object)key);
                                    if (value instanceof java.util.Date) {
                                        stmt.setTimestamp(i + 1, new Timestamp(((java.util.Date)value).getTime()));
                                        continue;
                                    }
                                    if (value instanceof LocalDate) {
                                        stmt.setDate(i + 1, Date.valueOf((LocalDate)value));
                                        continue;
                                    }
                                    if (value instanceof LocalDateTime) {
                                        stmt.setTimestamp(i + 1, Timestamp.valueOf((LocalDateTime)value));
                                        continue;
                                    }
                                    stmt.setObject(i + 1, value);
                                }
                                stmt.addBatch();
                            }
                            stmt.executeBatch();
                            conn2.commit();
                            stmt.clearBatch();
                        }
                        catch (SQLException e) {
                            try {
                                logger.error("\u516c\u5f0f\u7ec4\u4ef6\u6267\u884c\u5e76\u884c\u63d2\u5165\u6570\u636e\u5f02\u5e38:", (Throwable)e);
                                this.rollbackDuckDB(conn2);
                                throw new HussarException((Throwable)e);
                            }
                            catch (Throwable throwable) {
                                this.closeDuckDB(conn2, stmt);
                                throw throwable;
                            }
                        }
                        this.closeDuckDB(conn2, stmt);
                    });
                }
            }
            statement.execute("CREATE OR REPLACE TABLE _main AS select * from _equation_" + uuid);
            this.threadPoolTaskExecutor.execute(() -> {
                try (DuckDBConnection connection2 = this.getDuckDbConnection(task);
                     Statement statement2 = connection2.createStatement();){
                    statement2.execute("drop table _equation_" + uuid);
                }
                catch (SQLException e) {
                    logger.error("\u65b0\u589e\u516c\u5f0f\u5217\u7ec4\u4ef6\u5220\u9664\u4e34\u65f6\u8868\u5f02\u5e38:", (Throwable)e);
                }
            });
            TaskResult taskResult = TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
            return taskResult;
        }
        catch (HussarException | SQLException e) {
            logger.error("\u65b0\u589e\u516c\u5f0f\u5217\u7ec4\u4ef6\u8bed\u53e5\u6267\u884c\u5f02\u5e38.", e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.EXECUTION_EXCEPTION_ADD_EQUATION_STATEMENT.getCode()), DpExceptionEnum.EXECUTION_EXCEPTION_ADD_EQUATION_STATEMENT.getMessage(), e);
        }
    }
}

