/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.transform;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.TransformColumnConfigDto;
import com.jxdinfo.hussar.ds.process.component.model.TransformColumnToRowConfigModel;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransformColumnToRowWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(TransformColumnToRowWorker.class);
    private static final int SOURCE_FIELD_ID_INDEX = 1;

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.TRANSFORM_COLUMN_TO_ROW;
    }

    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        try {
            TransformColumnToRowConfigModel transformColumnToRowConfigModel = (TransformColumnToRowConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), TransformColumnToRowConfigModel.class);
            try (Statement statement = connection.createStatement();){
                String fixedFields = transformColumnToRowConfigModel.getFixedFields().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.joining(","));
                TransformColumnConfigDto transformConfig = transformColumnToRowConfigModel.getTransformConfig();
                String sql = this.prepareSql("_main", fixedFields, transformConfig, detailConfig.getParentFieldList());
                statement.execute(sql);
            }
            return TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
        }
        catch (SQLException e) {
            logger.error("\u5217\u8f6c\u884c\u7ec4\u4ef6\u8bed\u53e5\u6267\u884c\u5f02\u5e38");
            throw new HussarException((Throwable)e);
        }
    }

    private String prepareSql(String tableName, String fixedFields, TransformColumnConfigDto transformConfig, List<ColumnFieldDto> parentFieldList) {
        List sourceFields = transformConfig.getSourceFields();
        ColumnFieldDto targetField = transformConfig.getTargetField();
        ColumnFieldDto targetValueField = transformConfig.getTargetValueField();
        String selectFragmentSql = sourceFields.stream().map(sourceFieldList -> this.buildSelectFragment(fixedFields, (List<String>)sourceFieldList, targetField, targetValueField, tableName, parentFieldList)).collect(Collectors.joining("\nUNION ALL\n"));
        return "CREATE OR REPLACE TABLE " + tableName + " AS\n" + selectFragmentSql;
    }

    private String buildSelectFragment(String fixedFields, List<String> sourceFieldList, ColumnFieldDto targetField, ColumnFieldDto targetValueField, String tableName, List<ColumnFieldDto> parentFieldList) {
        String sourceField = sourceFieldList.get(1);
        String fieldComment = this.getFieldComment(sourceField, parentFieldList);
        return String.format("SELECT %s, '%s' AS %s, %s AS %s FROM %s", fixedFields, fieldComment, targetField.getFieldId(), sourceField, targetValueField.getFieldId(), tableName);
    }

    private String getFieldComment(String fieldId, List<ColumnFieldDto> parentFieldList) {
        return Optional.ofNullable(parentFieldList).flatMap(list -> list.stream().filter(field -> fieldId.equals(field.getFieldId())).findFirst()).map(ColumnFieldDto::getComment).orElse("");
    }

    public static void main(String[] args) {
        String tableName = "table_name";
        TransformColumnToRowConfigModel transformColumnToRowConfigModel = new TransformColumnToRowConfigModel();
        ColumnFieldDto fixedField = new ColumnFieldDto();
        fixedField.setFieldId("id");
        fixedField.setName("id");
        fixedField.setComment("id");
        fixedField.setDataType("int");
        fixedField.setDataType("int");
        ColumnFieldDto fixedField2 = new ColumnFieldDto();
        fixedField2.setFieldId("name");
        fixedField2.setName("name");
        fixedField2.setComment("name");
        fixedField2.setDataType("varchar");
        fixedField2.setDataType("varchar");
        transformColumnToRowConfigModel.setFixedFields(Arrays.asList(fixedField, fixedField2));
        TransformColumnConfigDto transformConfig = new TransformColumnConfigDto();
        transformConfig.setSourceFields(Arrays.asList(Arrays.asList("hussar_3", "Chinese"), Arrays.asList("hussar_3", "English")));
        ColumnFieldDto targetField = new ColumnFieldDto();
        targetField.setFieldId("subject");
        targetField.setName("subject");
        targetField.setComment("\u5b66\u79d1");
        targetField.setDataType("varchar");
        transformConfig.setTargetField(targetField);
        ColumnFieldDto targetValueField = new ColumnFieldDto();
        targetValueField.setFieldId("score");
        targetValueField.setName("score");
        targetValueField.setComment("\u6210\u7ee9");
        targetValueField.setDataType("int");
        transformConfig.setTargetValueField(targetValueField);
        String fixedFields = transformColumnToRowConfigModel.getFixedFields().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.joining(","));
        ArrayList<ColumnFieldDto> parentFieldList = new ArrayList<ColumnFieldDto>();
        ColumnFieldDto columnFieldDto = new ColumnFieldDto();
        columnFieldDto.setFieldId("Chinese");
        columnFieldDto.setComment("\u8bed\u6587");
        parentFieldList.add(columnFieldDto);
        columnFieldDto = new ColumnFieldDto();
        columnFieldDto.setFieldId("English");
        columnFieldDto.setComment("\u82f1\u8bed");
        parentFieldList.add(columnFieldDto);
        String sql = new TransformColumnToRowWorker().prepareSql(tableName, fixedFields, transformConfig, parentFieldList);
        System.out.println(sql);
    }
}

