/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.model.DataSetCondition;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetEngineService;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.ds.process.work.dto.DataHandleDto;
import com.jxdinfo.hussar.ds.process.work.service.IDataSetExecuteService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSetDbExecuteServiceImpl
implements IDataSetExecuteService {
    Logger log = LoggerFactory.getLogger(DataSetDbExecuteServiceImpl.class);
    @Autowired
    private IDataSetEngineService dataSetEngineService;
    @Autowired
    private IDataSetService dataSetService;

    @Override
    public List<JSONObject> getDataSetData(DataSetInputConfigModel config) {
        try {
            DataSetCommonParam param = new DataSetCommonParam();
            param.setUnifiedId(config.getDataSetId() + "");
            DataSetCondition dataSetCondition = new DataSetCondition();
            param.setDataSetCondition(dataSetCondition);
            dataSetCondition.setDataSetId("" + config.getDataSetId());
            dataSetCondition.setDataSetFunctionType(config.getDataSetType());
            DataSetTypeEnum dataSetTypeEnum = DataSetTypeEnum.valueOfCode((String)config.getDataSetType());
            ApiResponse listApiResponse = this.dataSetEngineService.executeDataSetParam(Collections.singletonList(param));
            Map<String, String> id2Name = this.getReturnValueByTypeAndId(dataSetTypeEnum, config.getDataSetId());
            List data = (List)listApiResponse.getData();
            for (DataSetExecuteVO datum : data) {
                if (!StringUtil.equals((String)config.getDataSetId(), (String)datum.getDataSetId())) continue;
                List fieldList = config.getFieldList().stream().map(action -> {
                    DataHandleDto dataHandleDto = new DataHandleDto((String)id2Name.get(action.getId()), action.getId());
                    dataHandleDto.setTargetName(action.getFieldId());
                    dataHandleDto.setDataType(action.getDataType());
                    return dataHandleDto;
                }).collect(Collectors.toList());
                List dataSetList = JsonUtil.parseArray((String)datum.getReturnValue(), JSONObject.class);
                return dataSetList.stream().map(jsonObject -> {
                    JSONObject one = new JSONObject();
                    for (DataHandleDto dataHandleDto : fieldList) {
                        one.put(dataHandleDto.getTargetName(), dataHandleDto.getData((JSONObject)jsonObject));
                    }
                    return one;
                }).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            this.log.error("\u6570\u636e\u96c6\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38", (Throwable)e);
            throw new HussarException("\u6570\u636e\u96c6\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38");
        }
        return Lists.newArrayListWithCapacity((int)0);
    }

    private Map<String, String> getReturnValueByTypeAndId(DataSetTypeEnum dataSetTypeEnum, String dataSetId) {
        WordDataSetInfo dataSetInfo = (WordDataSetInfo)this.dataSetService.getById((Serializable)((Object)dataSetId));
        DocumentContext jsonContext = JsonPath.parse((String)dataSetInfo.getData());
        Object read = jsonContext.read("$.dataSetParam.projection", new Predicate[0]);
        List list = JSON.parseArray((String)JSON.toJSONString((Object)read), JSONObject.class);
        return list.stream().collect(Collectors.toMap(k -> {
            String key = k.getString("id");
            if (StringUtil.isEmpty((String)key)) {
                key = k.getString("name");
            }
            return key;
        }, k -> k.getString("name")));
    }

    @Override
    public List<DataSetTypeEnum> getDataSetType() {
        return Arrays.asList(DataSetTypeEnum.DB, DataSetTypeEnum.CUSTOM_SQL);
    }
}

