/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.service;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ds.process.core.util.DuckDBUtil;
import com.jxdinfo.hussar.ds.process.dto.DataStreamDataResponseDto;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.platform.core.utils.date.StopWatch;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public abstract class DataStreamProcessWorker {
    Logger log = LoggerFactory.getLogger(DataStreamProcessWorker.class);
    @Resource
    protected ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static final ConcurrentHashMap<String, Long> INSTANCE_TIME_CACHE = new ConcurrentHashMap();

    public String getTaskDefName() {
        String sign = System.getProperty("sign");
        if (ObjectUtil.isNotEmpty((Object)sign)) {
            return this.getTaskType().name() + sign;
        }
        return this.getTaskType().name();
    }

    public abstract ModuleTypeEnum getTaskType();

    public abstract TaskResult execute(Task var1, CanvasDetailConfigDTO var2, DuckDBConnection var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public TaskResult execute(Task task) {
        Long lastTime;
        String instanceId = task.getWorkflowInstanceId().replace("-", "");
        if (HussarUtils.isNotEmpty((Object)instanceId) && HussarUtils.isNotEmpty((Object)(lastTime = INSTANCE_TIME_CACHE.get(instanceId)))) {
            long currentTime = System.currentTimeMillis();
            this.log.info("\u6267\u884c[{}]\u8c03\u5ea6\u4efb\u52a1\uff0c\u5b9e\u4f8bid[{}]\u4e0e\u4e0a\u4e00\u6267\u884c\u4efb\u52a1\u95f4\u9694\uff1a{}ms", new Object[]{this.getTaskType().getAlias(), instanceId, currentTime - lastTime});
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Map inputData = task.getInputData();
        CanvasDetailConfigDTO detailConfig = (CanvasDetailConfigDTO)JsonUtil.parse((String)JsonUtil.toJson((Object)inputData), CanvasDetailConfigDTO.class);
        try {
            TaskResult taskResult;
            Throwable throwable;
            DuckDBConnection connection;
            block26: {
                block27: {
                    TaskResult result;
                    block23: {
                        TaskResult taskResult2;
                        block24: {
                            block25: {
                                connection = this.getDuckDbConnection(task);
                                throwable = null;
                                result = this.execute(task, detailConfig, connection);
                                if (!Boolean.TRUE.equals(inputData.get("isEndTask"))) break block23;
                                INSTANCE_TIME_CACHE.remove(instanceId);
                                this.saveInstanceResult(task, false, DuckDBUtil.getDuckDbPath((Long)task.getStartTime(), (String)task.getWorkflowInstanceId()));
                                taskResult2 = TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.FAILED_WITH_TERMINAL_ERROR);
                                if (connection == null) break block24;
                                if (throwable == null) break block25;
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block24;
                            }
                            connection.close();
                        }
                        return taskResult2;
                    }
                    if (result.getStatus() == TaskResult.Status.FAILED_WITH_TERMINAL_ERROR) {
                        this.saveInstanceResult(task, true, this.getTaskType().getName());
                    }
                    INSTANCE_TIME_CACHE.put(instanceId, System.currentTimeMillis());
                    taskResult = result;
                    if (connection == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block26;
                }
                connection.close();
            }
            return taskResult;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (connection != null) {
                            if (throwable != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                connection.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Exception e) {
                    this.log.error("\u6267\u884c\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                    this.saveInstanceResult(task, true, e.getMessage());
                    throwable = TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.FAILED_WITH_TERMINAL_ERROR);
                    return throwable;
                }
            }
        }
        finally {
            stopWatch.stop();
            this.log.info("\u6267\u884c{}\u7684\u8c03\u5ea6\u4efb\u52a1,\u8017\u65f6\uff1a{}ms", (Object)this.getTaskType().getAlias(), (Object)stopWatch.getTotalTimeMillis());
        }
    }

    public void saveInstanceResult(Task task, boolean isError, String message) {
        DataStreamDataResponseDto result = DataStreamDataResponseDto.success((String)message);
        if (isError) {
            result = DataStreamDataResponseDto.error((String)message);
        }
        HussarFixedCacheUtil.put((String)"ds", (Object)"work_flow_instance:".concat(task.getWorkflowInstanceId()), (Object)result, (long)TimeUnit.HOURS.toSeconds(1L));
        HussarFixedCacheUtil.evict((String)"ds", (Object)"data_set_2_instance:".concat(task.getWorkflowType()));
    }

    public DuckDBConnection getDuckDbConnection(Task task) {
        try {
            String path = DuckDBUtil.getDuckDbPath((Long)task.getStartTime(), (String)task.getWorkflowInstanceId());
            Properties properties = new Properties();
            properties.setProperty("default_collation", "zh_CN");
            return (DuckDBConnection)DriverManager.getConnection(path, properties);
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void showTableData(DuckDBConnection connection, String remark) {
        block53: {
            block52: {
                block51: {
                    String sign = System.getProperty("sign");
                    if (!ObjectUtil.isEmpty((Object)sign)) break block51;
                    try {
                        this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\u5904\u7406\u5b8c\u6bd5", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog()});
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try (Statement statement = connection.createStatement();
                     ResultSet tableResult = statement.executeQuery("SHOW ALL TABLES");){
                    List maps = DuckDBUtil.resultSetToList((ResultSet)tableResult);
                    if (!maps.stream().anyMatch(action -> "_main".equals(action.getString("name")))) break block52;
                    try (ResultSet resultSet = statement.executeQuery("select * from _main");){
                        this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\uff1a{}", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog(), JSONObject.toJSONString((Object)DuckDBUtil.resultSetToList((ResultSet)resultSet))});
                    }
                }
                catch (Exception e) {
                    this.log.error("showTableData \u5904\u7406\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
            }
            try {
                this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\u5904\u7406\u5b8c\u6bd5", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog()});
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            break block53;
            catch (Exception e) {
                try {
                    this.log.error("showTableData \u5904\u7406\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\u5904\u7406\u5b8c\u6bd5", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog()});
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    this.log.info("\u7c7b\uff1a{},{}_{}\u6570\u636e\u5904\u7406\u5b8c\u6bd5", new Object[]{this.getClass().getSimpleName(), remark, connection.getCatalog()});
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
            }
        }
    }
}

