/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.scheduled;

import com.jxdinfo.hussar.ds.process.core.util.DuckDBUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ProcessScheduledService
implements ApplicationRunner {
    static Logger log = LoggerFactory.getLogger(ProcessScheduledService.class);

    @Scheduled(cron="0 20 3 * * ?")
    public void removeTimeOutFile() throws IOException {
        long step = TimeUnit.DAYS.toMillis(1L);
        for (int i = 1; i < 8; ++i) {
            String path = DuckDBUtil.getDuckDbPath((Long)(System.currentTimeMillis() - step * (long)i));
            ProcessScheduledService.deleteDirectoryNio(path);
        }
        String duckDbPath = DuckDBUtil.getDuckDbPath((Long)(System.currentTimeMillis() + step));
        ProcessScheduledService.createDirectoryIfNotExists(duckDbPath);
    }

    public static void deleteDirectoryNio(String pathName) throws IOException {
        Path path = Paths.get(pathName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Files.walk(path, new FileVisitOption[0]).forEach(p -> {
                try {
                    boolean delFlag;
                    boolean bl = delFlag = p.toString().endsWith(".duckdb") || p.equals(path) && !Files.list(p).findAny().isPresent();
                    if (delFlag) {
                        Files.deleteIfExists(p);
                    }
                }
                catch (IOException e) {
                    log.error("\u65e0\u6cd5\u5220\u9664: " + p + " - " + e.getMessage());
                }
            });
            Files.deleteIfExists(path);
            log.info("\u6587\u4ef6\u5939\u5220\u9664\u5b8c\u6bd5" + pathName);
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        String duckDbPath = DuckDBUtil.getDuckDbPath((Long)System.currentTimeMillis());
        ProcessScheduledService.createDirectoryIfNotExists(duckDbPath);
        long step = TimeUnit.DAYS.toMillis(1L);
        duckDbPath = DuckDBUtil.getDuckDbPath((Long)(System.currentTimeMillis() + step));
        ProcessScheduledService.createDirectoryIfNotExists(duckDbPath);
    }

    public static void createDirectoryIfNotExists(String dirPath) {
        Path path = Paths.get(dirPath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Files.isDirectory(path, new LinkOption[0]);
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u6587\u4ef6\u5939\u5f02\u5e38", (Throwable)e);
        }
    }
}

