/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.output;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.OutPutConfigModel;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutputTaskWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(OutputTaskWorker.class);
    @Autowired
    private DataSource dataSource;

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.OUT_PUT;
    }

    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        OutPutConfigModel config = (OutPutConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), OutPutConfigModel.class);
        if (!HussarUtils.equals((Object)"db", (Object)config.getSaveType())) {
            this.prepareClearTable(config.getTableName());
        } else {
            this.prepareClearTable(config.getTableName());
        }
        List fieldList = detailConfig.getParentFieldList();
        this.migrateData(connection, config.getTableName(), fieldList, "", null, Collections.EMPTY_MAP);
        return TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
    }

    private void prepareClearTable(String tableName) {
        String sql = "DELETE FROM " + tableName;
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            logger.error(String.format("\u6e05\u7a7a\u8868{}\u5931\u8d25", tableName), (Throwable)e);
            throw new HussarException(String.format("\u6e05\u7a7a\u8868{}\u5931\u8d25", tableName), (Throwable)e);
        }
    }

    private void migrateData(DuckDBConnection connection, String tableName, List<ColumnFieldDto> allFieldList, String parentGroupId, Long parentId, Map<String, Object> parentData) {
        List<ColumnFieldDto> currentChildFields = this.filterCurrentChildFields(allFieldList, parentGroupId);
        if (HussarUtils.isEmpty(currentChildFields)) {
            return;
        }
        Set<String> currentGroupIds = this.extractGroupIds(currentChildFields);
        List<ColumnFieldDto> childJoinFields = this.filterCurrentChildJoinFields(allFieldList, currentGroupIds);
        currentChildFields.addAll(childJoinFields);
        List<ColumnFieldDto> remainingFields = this.excludeCurrentChildFields(allFieldList, currentChildFields);
        currentGroupIds = this.extractGroupIds(currentChildFields);
        boolean hasGrandchildren = this.hasGrandchildren(remainingFields, currentGroupIds);
        List<Map<String, Object>> currentData = this.queryCurrentTableData(connection, "_main", currentChildFields, parentId, parentData, hasGrandchildren);
        if (HussarUtils.isEmpty(currentData)) {
            return;
        }
        this.insertCurrentData(tableName, currentChildFields, currentData);
        if (hasGrandchildren) {
            List<Map<String, Object>> dataContexts = this.buildDataContexts(currentData, parentData);
            this.recursiveProcessGrandchildren(connection, tableName, remainingFields, currentGroupIds, dataContexts);
        }
    }

    private List<ColumnFieldDto> filterCurrentChildFields(List<ColumnFieldDto> allFieldList, String parentGroupId) {
        return allFieldList.stream().filter(field -> HussarUtils.equals((Object)parentGroupId, (Object)field.getParentGroupId())).collect(Collectors.toList());
    }

    private List<ColumnFieldDto> filterCurrentChildJoinFields(List<ColumnFieldDto> allFieldList, Set<String> currentGroupIds) {
        return allFieldList.stream().filter(field -> currentGroupIds.contains(field.getParentGroupId()) && ModuleTypeEnum.JOIN_FIELD.getAlias().startsWith(field.getInstanceName())).collect(Collectors.toList());
    }

    private List<ColumnFieldDto> excludeCurrentChildFields(List<ColumnFieldDto> allFieldList, List<ColumnFieldDto> childFieldList) {
        return allFieldList.stream().filter(field -> !childFieldList.contains(field)).collect(Collectors.toList());
    }

    private Set<String> extractGroupIds(List<ColumnFieldDto> childFields) {
        return childFields.stream().map(ColumnFieldDto::getGroupId).collect(Collectors.toSet());
    }

    private boolean hasGrandchildren(List<ColumnFieldDto> remainingFields, Set<String> currentGroupIds) {
        return remainingFields.stream().anyMatch(field -> currentGroupIds.contains(field.getParentGroupId()));
    }

    private List<Map<String, Object>> queryCurrentTableData(DuckDBConnection connection, String tableName, List<ColumnFieldDto> fieldList, Long parentId, Map<String, Object> parentData, boolean hasChildren) {
        ArrayList data = Lists.newArrayListWithCapacity((int)10);
        String sql = this.buildSelectSql(fieldList, tableName, parentData, hasChildren);
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            if (HussarUtils.isNotEmpty(parentData)) {
                int index = 1;
                for (Map.Entry<String, Object> entry : parentData.entrySet()) {
                    ps.setObject(index++, entry.getValue());
                }
            }
            ResultSet rs = ps.executeQuery();
            Object object = null;
            try {
                while (rs.next()) {
                    HashMap row = Maps.newHashMapWithExpectedSize((int)10);
                    for (ColumnFieldDto field : fieldList) {
                        String fieldId = field.getFieldId();
                        Object value = rs.getObject(fieldId);
                        row.put(fieldId, value);
                    }
                    row.put("id", IdUtil.getSnowflakeNextId());
                    row.put("pid", parentId);
                    data.add(row);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (object != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error("\u67e5\u8be2\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new HussarException("\u67e5\u8be2\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return data;
    }

    private String buildSelectSql(List<ColumnFieldDto> fieldList, String tableName, Map<String, Object> parentData, boolean hasChildren) {
        String fieldIdStr = fieldList.stream().map(ColumnFieldDto::getFieldId).collect(Collectors.joining(","));
        List keys = parentData.entrySet().stream().filter(entry -> HussarUtils.isNotEmpty(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        String whereClause = keys.stream().map(key -> key + " = ?").collect(Collectors.joining(" AND "));
        StringBuilder sql = new StringBuilder().append("SELECT ").append(fieldIdStr).append(" FROM ").append(tableName);
        if (HussarUtils.isNotEmpty(keys)) {
            sql.append(" WHERE ").append(whereClause);
        }
        if (hasChildren) {
            sql.append(" GROUP BY ").append(fieldIdStr);
        }
        return sql.toString();
    }

    private void insertCurrentData(String tableName, List<ColumnFieldDto> fieldList, List<Map<String, Object>> data) {
        String sql = this.buildInsertSql(tableName, fieldList);
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            long batchSize = 0L;
            for (Map<String, Object> row : data) {
                ++batchSize;
                for (int i = 0; i < fieldList.size(); ++i) {
                    ColumnFieldDto field = fieldList.get(i);
                    Object value = row.get(field.getFieldId());
                    stmt.setObject(i + 1, value);
                }
                stmt.setObject(fieldList.size() + 1, row.get("id"));
                stmt.setObject(fieldList.size() + 2, row.get("pid"));
                stmt.addBatch();
                if (batchSize % 1000L != 0L) continue;
                stmt.executeBatch();
                stmt.clearBatch();
            }
            if (batchSize % 1000L > 0L) {
                stmt.executeBatch();
                stmt.clearBatch();
            }
        }
        catch (SQLException e) {
            logger.error("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new HussarException("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private String buildInsertSql(String tableName, List<ColumnFieldDto> fieldList) {
        List allFields = fieldList.stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toList());
        allFields.add("id");
        allFields.add("pid");
        String fieldsStr = HussarUtils.join(allFields, (String)",");
        String placeholdersStr = allFields.stream().map(field -> "?").collect(Collectors.joining(","));
        return "INSERT INTO " + tableName + "(" + fieldsStr + ")" + " VALUES(" + placeholdersStr + ")";
    }

    private List<Map<String, Object>> buildDataContexts(List<Map<String, Object>> currentData, Map<String, Object> parentData) {
        ArrayList contexts = Lists.newArrayListWithCapacity((int)currentData.size());
        currentData.forEach(dataMap -> {
            HashMap contextMap = Maps.newHashMap((Map)dataMap);
            contextMap.putAll(parentData);
            contexts.add(contextMap);
        });
        return contexts;
    }

    private void recursiveProcessGrandchildren(DuckDBConnection connection, String tableName, List<ColumnFieldDto> remainingFields, Set<String> currentGroupIds, List<Map<String, Object>> dataContexts) {
        for (String groupId : currentGroupIds) {
            for (Map<String, Object> contextMap : dataContexts) {
                Long currentId;
                Object pkObj = contextMap.get("id");
                if (pkObj == null) continue;
                try {
                    currentId = Long.valueOf(pkObj.toString());
                }
                catch (NumberFormatException e) {
                    continue;
                }
                Map<String, Object> newContextMap = contextMap.entrySet().stream().filter(entry -> !"id".equals(entry.getKey()) && !"pid".equals(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                this.migrateData(connection, tableName, remainingFields, groupId, currentId, newContextMap);
            }
        }
    }
}

