/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.input;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ds.process.component.dto.DataSetFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.util.DataTypeUtil;
import com.jxdinfo.hussar.ds.process.work.factory.DataSetExecuteFactory;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataSetInputTaskWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(DataSetInputTaskWorker.class);

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.DATA_SET_INPUT;
    }

    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        DataSetInputConfigModel config = (DataSetInputConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), DataSetInputConfigModel.class);
        List<JSONObject> result = DataSetExecuteFactory.get(config.getDataSetType()).getDataSetData(config);
        String fieldDefList = config.getFieldList().stream().map(action -> String.format(" %s %s", action.getFieldId(), DataTypeUtil.getDuckDbType((String)action.getDataType()))).collect(Collectors.joining(","));
        List fieldListInfo = config.getFieldList();
        String fieldIdsStr = config.getFieldList().stream().map(DataSetFieldDto::getFieldId).collect(Collectors.joining(","));
        String fieldCount = config.getFieldList().stream().map(action -> "?").collect(Collectors.joining(","));
        try (Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE TABLE _main (%s);", fieldDefList));
            try (PreparedStatement stmt = connection.prepareStatement(String.format("INSERT INTO  _main (%s) VALUES (%s);", fieldIdsStr, fieldCount));){
                long batchSize = 0L;
                for (JSONObject jsonObject : result) {
                    ++batchSize;
                    for (int i = 0; i < fieldListInfo.size(); ++i) {
                        DataSetFieldDto dataSetFieldDto = (DataSetFieldDto)fieldListInfo.get(i);
                        Object value = DataTypeUtil.getDataByKeyAndType((JSONObject)jsonObject, (String)dataSetFieldDto.getDataType(), (String)dataSetFieldDto.getFieldId());
                        stmt.setObject(i + 1, value);
                    }
                    stmt.addBatch();
                    if (batchSize % 1000L != 0L) continue;
                    stmt.executeBatch();
                    stmt.clearBatch();
                }
                if (batchSize % 1000L > 0L) {
                    stmt.executeBatch();
                    stmt.clearBatch();
                }
            }
        }
        catch (SQLException e) {
            logger.error("\u6267\u884c\u6570\u636e\u96c6\u5f55\u5165\u5f02\u5e38:", (Throwable)e);
            throw new HussarException((Throwable)e);
        }
        return TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
    }
}

