/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.groupfield;

import com.jxdinfo.hussar.ds.process.component.dto.AggregateFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.GroupFieldConfigModel;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.AggregateTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GroupFieldTaskWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(GroupFieldTaskWorker.class);

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.GROUP_FIELD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        GroupFieldConfigModel config = (GroupFieldConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), GroupFieldConfigModel.class);
        try (Statement statement = connection.createStatement();){
            String groupFields = config.getGroupFields().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.joining(","));
            String aggregateList = config.getAggregateList().stream().map(action -> String.format(" %s(%s) as %s ", AggregateTypeEnum.getSql((String)action.getAggregateType()), action.getOperateFieldId(), action.getFieldId())).collect(Collectors.joining(","));
            List targetList = config.getAggregateList().stream().map(AggregateFieldDto::getFieldId).collect(Collectors.toList());
            String selectList = config.getGroupFields().stream().map(ColumnFieldDto::getFieldId).filter(action -> !targetList.contains(action)).collect(Collectors.joining(","));
            String sql = String.format("CREATE OR REPLACE TABLE _main AS\nSELECT %s,%s \nFROM _main \nGROUP BY %s", selectList, aggregateList, groupFields);
            statement.execute(sql);
            TaskResult taskResult = TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
            return taskResult;
        }
        catch (SQLException e) {
            logger.error("\u5206\u7ec4\u6c47\u603b\u7ec4\u4ef6\u8bed\u53e5\u6267\u884c\u5f02\u5e38\uff0c", (Throwable)e);
            throw new HussarException((Throwable)e);
        }
    }
}

