/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.factory;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataStreamProcessWorkerFactory {
    private static final Logger log = LoggerFactory.getLogger(DataStreamProcessWorkerFactory.class);
    private List<DataStreamProcessWorker> workerList;
    private static final Map<String, DataStreamProcessWorker> workerMap = new HashMap<String, DataStreamProcessWorker>();

    public DataStreamProcessWorkerFactory(List<DataStreamProcessWorker> workerList) {
        this.workerList = workerList;
    }

    public static void register(DataStreamProcessWorker dataStreamProcessWorker) {
        workerMap.put(dataStreamProcessWorker.getTaskType().getName(), dataStreamProcessWorker);
    }

    public static DataStreamProcessWorker get(String name) {
        return workerMap.get(name);
    }

    public static Map<String, DataStreamProcessWorker> getAll() {
        return workerMap;
    }

    public static void register(String name, DataStreamProcessWorker dataStreamProcessWorker) {
        workerMap.put(name, dataStreamProcessWorker);
    }

    @PostConstruct
    public void init() {
        if (ObjectUtils.isNotEmpty(this.workerList)) {
            this.workerList.forEach(DataStreamProcessWorkerFactory::register);
        }
        Map<String, DataStreamProcessWorker> all = DataStreamProcessWorkerFactory.getAll();
        all.forEach((k, v) -> log.debug("\u7ec4\u4ef6\uff1a{}, \u5bf9\u5e94\u53c2\u6570\u7ec4\u88c5\u6267\u884c\u5668:{}", k, (Object)v.getClass().getName()));
    }
}

