/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.controller;

import com.jxdinfo.hussar.ds.process.work.factory.DataStreamProcessWorkerFactory;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.netflix.conductor.common.metadata.tasks.Task;
import io.swagger.annotations.Api;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8c03\u5ea6\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/ds/process/worker"})
public class WorkerController {
    private static final Logger log = LoggerFactory.getLogger(WorkerController.class);

    @Inner
    @PostMapping(value={"/start/{taskType}"})
    public ApiResponse<Object> startTask(@PathVariable String taskType, @RequestBody Map<String, Object> inputMap) {
        DataStreamProcessWorker worker = DataStreamProcessWorkerFactory.get(taskType);
        Long startTime = (Long)inputMap.get("startTime");
        String workflowInstanceId = (String)inputMap.get("workflowInstanceId");
        String workflowType = (String)inputMap.get("workflowType");
        Task task = new Task();
        task.setStartTime(startTime.longValue());
        task.setWorkflowInstanceId(workflowInstanceId);
        task.setWorkflowType(workflowType);
        task.setInputData(inputMap);
        return ApiResponse.success((Object)worker.execute(task));
    }
}

