/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.work.addConstant;

import com.jxdinfo.hussar.ds.process.component.model.AddConstantConfigModel;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.work.service.DataStreamProcessWorker;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.netflix.conductor.common.metadata.tasks.Task;
import com.netflix.conductor.common.metadata.tasks.TaskResult;
import java.sql.SQLException;
import java.sql.Statement;
import org.duckdb.DuckDBConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AddConstantTaskWorker
extends DataStreamProcessWorker {
    private static final Logger logger = LoggerFactory.getLogger(AddConstantTaskWorker.class);

    @Override
    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.ADD_CONSTANT;
    }

    @Override
    public TaskResult execute(Task task, CanvasDetailConfigDTO detailConfig, DuckDBConnection connection) {
        AddConstantConfigModel addConstantConfigModel = (AddConstantConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), AddConstantConfigModel.class);
        try (Statement statement = connection.createStatement();){
            String sql = String.format("ALTER TABLE _main ADD COLUMN %s %s DEFAULT '%s';", addConstantConfigModel.getFieldId(), addConstantConfigModel.getFieldType(), addConstantConfigModel.getFieldValue());
            statement.execute(sql);
        }
        catch (SQLException e) {
            logger.error("\u65b0\u589e\u5e38\u91cf\u5217\u8bed\u53e5\u6267\u884c\u5f02\u5e38", (Throwable)e);
            throw new HussarException((Throwable)e);
        }
        return TaskResult.newTaskResult((TaskResult.Status)TaskResult.Status.COMPLETED);
    }
}

