/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jxdinfo.hussar.ds.process.enums.TaskStatus;
import com.jxdinfo.hussar.ds.process.enums.TaskTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.WorkflowStatus;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class LogParseUtil {
    public static String parseWorkFlow(String str) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map workflowInstance = (Map)mapper.readValue(str, (TypeReference)new TypeReference<Map<String, Object>>(){});
            StringBuilder log = new StringBuilder();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Long createTime = (Long)workflowInstance.get("createTime");
            Long startTime = workflowInstance.containsKey("startTime") ? (Long)workflowInstance.get("startTime") : null;
            Object updateTimeObj = workflowInstance.get("updateTime");
            Object endTimeObj = workflowInstance.get("endTime");
            Long updateTime = null;
            Long endTime = null;
            if (updateTimeObj instanceof Long) {
                updateTime = (Long)updateTimeObj;
            } else if (updateTimeObj instanceof Integer && (Integer)updateTimeObj != 0) {
                updateTime = ((Integer)updateTimeObj).longValue();
            }
            if (endTimeObj instanceof Long) {
                endTime = (Long)endTimeObj;
            } else if (endTimeObj instanceof Integer && (Integer)endTimeObj != 0) {
                endTime = ((Integer)endTimeObj).longValue();
            }
            String status = (String)workflowInstance.get("status");
            WorkflowStatus workflowStatus = WorkflowStatus.valueOf((String)status);
            String statusChinese = workflowStatus.getChinese();
            log.append(dateFormat.format(new Date(createTime))).append(" INFO - ").append("\u5de5\u4f5c\u6d41\u5b9e\u4f8bID: ").append(workflowInstance.get("workflowId")).append("\n");
            log.append(dateFormat.format(new Date(createTime))).append(" INFO - ").append("\u5de5\u4f5c\u6d41ID: ").append(workflowInstance.get("workflowName")).append("\n");
            log.append(dateFormat.format(new Date(createTime))).append(" INFO - ").append("\u72b6\u6001: ").append(statusChinese).append("\n");
            log.append(dateFormat.format(new Date(createTime))).append(" INFO - ").append("\u521b\u5efa\u65f6\u95f4: ").append(dateFormat.format(new Date(createTime))).append("\n");
            if (updateTime != null) {
                log.append(dateFormat.format(new Date(updateTime))).append(" INFO - ").append("\u66f4\u65b0\u65f6\u95f4: ").append(dateFormat.format(new Date(updateTime))).append("\n");
            }
            if (startTime != null) {
                log.append(dateFormat.format(new Date(startTime))).append(" INFO - ").append("\u5f00\u59cb\u65f6\u95f4: ").append(dateFormat.format(new Date(startTime))).append("\n");
            }
            log.append(dateFormat.format(new Date(createTime))).append(" INFO - ").append("\u5b9e\u4f8b\u540d\u79f0: ").append(workflowInstance.get("instanceName")).append("\n");
            log.append(dateFormat.format(new Date(createTime))).append(" INFO - ").append("\u5de5\u4f5c\u6d41\u7248\u672c: ").append(workflowInstance.get("workflowVersion")).append("\n");
            Object input = ((Map)workflowInstance.get("input")).get("input");
            Map output = (Map)workflowInstance.get("output");
            log.append(dateFormat.format(new Date(createTime))).append(" INFO - ").append("\u8f93\u5165\u53c2\u6570: ").append(input).append("\n");
            log.append(dateFormat.format(new Date(createTime))).append(" INFO - ").append("\u8f93\u51fa\u53c2\u6570: ").append(output).append("\n");
            if (status.equals("FAILED")) {
                String reasonForIncompletion = (String)workflowInstance.get("reasonForIncompletion");
                log.append(dateFormat.format(new Date(createTime))).append(" ERROR - ").append("\u9519\u8bef\u539f\u56e0: ").append(reasonForIncompletion).append("\n");
            }
            if (endTime != null) {
                log.append(dateFormat.format(new Date(endTime))).append(" INFO - ").append("\u7ed3\u675f\u65f6\u95f4: ").append(dateFormat.format(new Date(endTime))).append("\n");
            }
            return log.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static String parseTask(String str) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map taskInstance = (Map)mapper.readValue(str, (TypeReference)new TypeReference<Map<String, Object>>(){});
            StringBuilder log = new StringBuilder();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            TaskTypeEnum taskType = TaskTypeEnum.valueOf((String)((String)taskInstance.get("taskType")));
            if (taskType.isSys()) {
                return "";
            }
            Long scheduledTime = (Long)taskInstance.get("scheduledTime");
            Object startTimeObj = taskInstance.get("startTime");
            Long startTime = null;
            if (startTimeObj instanceof Long) {
                startTime = (Long)startTimeObj;
            } else if (startTimeObj instanceof Integer && (Integer)startTimeObj != 0) {
                startTime = ((Integer)startTimeObj).longValue();
            }
            Object updateTimeObj = taskInstance.get("updateTime");
            Long updateTime = null;
            if (updateTimeObj instanceof Long) {
                updateTime = (Long)updateTimeObj;
            } else if (updateTimeObj instanceof Integer && (Integer)updateTimeObj != 0) {
                updateTime = ((Integer)updateTimeObj).longValue();
            }
            Object endTimeObj = taskInstance.get("updateTime");
            Long endTime = null;
            if (endTimeObj instanceof Long) {
                endTime = (Long)endTimeObj;
            } else if (endTimeObj instanceof Integer && (Integer)endTimeObj != 0) {
                endTime = ((Integer)endTimeObj).longValue();
            }
            String status = (String)taskInstance.get("status");
            TaskStatus taskStatus = TaskStatus.valueOf((String)status);
            String statusChinese = taskStatus.getChinese();
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u4efb\u52a1\u5b9e\u4f8bID: ").append(taskInstance.get("taskId")).append("\n");
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u4efb\u52a1\u540d\u79f0: ").append(taskInstance.get("taskDefName")).append("\n");
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u4efb\u52a1\u6807\u8bc6: ").append(taskInstance.get("referenceTaskName")).append("\n");
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u72b6\u6001: ").append(statusChinese).append("\n");
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u91cd\u8bd5\u6b21\u6570: ").append(taskInstance.get("retryCount")).append("\n");
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u8f6e\u8be2\u6b21\u6570: ").append(taskInstance.get("pollCount")).append("\n");
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u653e\u5165\u961f\u5217\u65f6\u95f4: ").append(dateFormat.format(new Date(scheduledTime))).append("\n");
            if (startTime != null) {
                log.append(dateFormat.format(new Date(startTime))).append(" INFO - ").append("\u5f00\u59cb\u65f6\u95f4: ").append(dateFormat.format(new Date(startTime))).append("\n");
            }
            if (updateTime != null) {
                log.append(dateFormat.format(new Date(updateTime))).append(" INFO - ").append("\u66f4\u65b0\u65f6\u95f4: ").append(dateFormat.format(new Date(updateTime))).append("\n");
            }
            if (endTime != null) {
                log.append(dateFormat.format(new Date(endTime))).append(" INFO - ").append("\u7ed3\u675f\u65f6\u95f4: ").append(dateFormat.format(new Date(endTime))).append("\n");
            }
            Configuration configuration = Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
            DocumentContext jsonContext = JsonPath.parse((Object)taskInstance, (Configuration)configuration);
            String input = taskType.getInput();
            if (input.startsWith("$.")) {
                input = (String)jsonContext.read(input, new Predicate[0]);
            }
            Object inputData = jsonContext.read(input, new Predicate[0]);
            Object outputData = null;
            outputData = taskStatus == TaskStatus.COMPLETED ? jsonContext.read(taskType.getOutPut(), new Predicate[0]) : jsonContext.read("$.outputData", new Predicate[0]);
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u8f93\u5165\u53c2\u6570: ").append(inputData).append("\n");
            log.append(dateFormat.format(new Date(scheduledTime))).append(" INFO - ").append("\u8f93\u51fa\u53c2\u6570: ").append(outputData).append("\n");
            if (taskStatus != TaskStatus.COMPLETED && taskStatus != TaskStatus.IN_PROGRESS && taskStatus != TaskStatus.SCHEDULED) {
                String reasonForIncompletion = (String)taskInstance.get("reasonForIncompletion");
                log.append(dateFormat.format(new Date(scheduledTime))).append(" ERROR - ").append("\u9519\u8bef\u539f\u56e0: ").append(reasonForIncompletion).append("\n");
            }
            return log.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "{}";
        }
    }
}

