/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetOperationDto;
import com.jxdinfo.hussar.dataset.enums.FrontTypeEnum;
import com.jxdinfo.hussar.dataset.model.ApiDataContent;
import com.jxdinfo.hussar.dataset.model.ApiProperty;
import com.jxdinfo.hussar.dataset.model.SqlConfigSchema1;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetProcessor;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.DatasourceDataService;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.ds.common.exception.DpException;
import com.jxdinfo.hussar.ds.common.exception.DpExceptionEnum;
import com.jxdinfo.hussar.ds.common.util.HttpUtil;
import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.component.model.JoinFieldConfigModel;
import com.jxdinfo.hussar.ds.process.component.model.OutPutConfigModel;
import com.jxdinfo.hussar.ds.process.constant.DataStreamConstant;
import com.jxdinfo.hussar.ds.process.constant.FlowEngineConstant;
import com.jxdinfo.hussar.ds.process.converter.DataStreamCanvasContentConverter;
import com.jxdinfo.hussar.ds.process.core.util.DuckDBUtil;
import com.jxdinfo.hussar.ds.process.core.util.WorkFlowUtil;
import com.jxdinfo.hussar.ds.process.ctx.ProcessCtx;
import com.jxdinfo.hussar.ds.process.dao.DataStreamDataSetMapper;
import com.jxdinfo.hussar.ds.process.dto.DataStreamDataResponseDto;
import com.jxdinfo.hussar.ds.process.dto.DataStreamInfoResponseDto;
import com.jxdinfo.hussar.ds.process.dto.DataStreamPreViewRequestDto;
import com.jxdinfo.hussar.ds.process.dto.DataStreamSaveRequestDto;
import com.jxdinfo.hussar.ds.process.dto.DataStreamSaveResponseDto;
import com.jxdinfo.hussar.ds.process.dto.DpApiFlowTaskDto;
import com.jxdinfo.hussar.ds.process.dto.DpApiWorkflowDefDto;
import com.jxdinfo.hussar.ds.process.dto.DpCheckTableNameDto;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasPropsDTO;
import com.jxdinfo.hussar.ds.process.dto.widget.DpApiBaseWidget;
import com.jxdinfo.hussar.ds.process.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.FieldTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.model.DataStreamCanvas;
import com.jxdinfo.hussar.ds.process.model.DataStreamDataSet;
import com.jxdinfo.hussar.ds.process.model.DpJobInfo;
import com.jxdinfo.hussar.ds.process.properties.DataStreamProperties;
import com.jxdinfo.hussar.ds.process.service.DataStreamCanvasService;
import com.jxdinfo.hussar.ds.process.service.DataStreamDataSetService;
import com.jxdinfo.hussar.ds.process.service.DpJobInfoService;
import com.jxdinfo.hussar.mail.core.util.ObjectUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.date.LocalDateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.date.StopWatch;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.IOException;
import java.io.Serializable;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DataStreamDataSetServiceImpl
extends HussarServiceImpl<DataStreamDataSetMapper, DataStreamDataSet>
implements DataStreamDataSetService {
    private static final Logger log = LoggerFactory.getLogger(DataStreamDataSetServiceImpl.class);
    @Autowired
    private DataStreamCanvasService dataStreamCanvasService;
    @Autowired
    private IDataSetService dataSetService;
    @Autowired
    @Qualifier(value="com.jxdinfo.hussar.dataset.strategy.DataStreamRrocessor")
    private IDataSetProcessor dataSetProcessor;
    private DataStreamProperties dataStreamProperties;
    @Autowired
    private DpJobInfoService dpJobInfoService;
    @Autowired
    private HussarDdlService hussarDdlService;
    @Autowired
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private DatasourceDataService datasourceDataService;

    public DataStreamDataSetServiceImpl(DataStreamProperties dataStreamProperties) {
        this.dataStreamProperties = dataStreamProperties;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public DataStreamSaveResponseDto dataStreamSave(DataStreamSaveRequestDto dataStreamSaveRequestDto) throws DpException {
        List<ColumnFieldDto> resultColumnFieldList = this.init(dataStreamSaveRequestDto);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        OutPutConfigModel outPutConfigModel = this.createTable(dataStreamSaveRequestDto, resultColumnFieldList);
        stopWatch.stop();
        log.info("\u521b\u5efa\u8868\u8017\u65f6:{}", (Object)stopWatch.getTotalTimeMillis());
        stopWatch = new StopWatch();
        stopWatch.start();
        Long dataSetId = this.saveDataToDataSet(dataStreamSaveRequestDto, resultColumnFieldList, outPutConfigModel);
        Integer newVersion = this.saveCanvasInfo(dataStreamSaveRequestDto);
        this.saveDataStreamInfo(dataStreamSaveRequestDto, newVersion, outPutConfigModel);
        stopWatch.stop();
        log.info("\u6570\u636e\u96c6\u4fdd\u5b58\u8017\u65f6:{}", (Object)stopWatch.getTotalTimeMillis());
        stopWatch = new StopWatch();
        stopWatch.start();
        ProcessCtx ctx = new ProcessCtx();
        ctx.setDataSetId(dataStreamSaveRequestDto.getDataSetId());
        ctx.setCanvasContent(dataStreamSaveRequestDto.getCanvasContent());
        ctx.setName(dataStreamSaveRequestDto.getDataSetName());
        ctx.setVersion(newVersion);
        this.conductorMetadataWorkFlow(ctx);
        stopWatch.stop();
        log.info("\u8c03\u7528\u6d41\u7a0b\u5f15\u64ceconductor\u8017\u65f6:{}", (Object)stopWatch.getTotalTimeMillis());
        stopWatch = new StopWatch();
        stopWatch.start();
        this.createJob(dataStreamSaveRequestDto);
        stopWatch.stop();
        log.info("\u4efb\u52a1\u542f\u52a8\u8017\u65f6:{}", (Object)stopWatch.getTotalTimeMillis());
        return new DataStreamSaveResponseDto(dataSetId, dataStreamSaveRequestDto.getCanvasId());
    }

    public String dataStreamPreView(DataStreamPreViewRequestDto preViewRequestDto) throws DpException {
        Integer newVersion = (int)System.currentTimeMillis() % Integer.MAX_VALUE;
        Long dataSetId = DataStreamConstant.PRE_VIEW_ID;
        ProcessCtx ctx = new ProcessCtx();
        ctx.setCanvasContent(preViewRequestDto.getCanvasContent());
        ctx.setStartModule(preViewRequestDto.getStartModule());
        ctx.setEndModule(preViewRequestDto.getEndModule());
        ctx.setDataSetId(dataSetId);
        ctx.setName("\u6570\u636e\u9884\u89c8");
        ctx.setVersion(newVersion);
        String instanceId = this.conductorPreviewWorkFlow(ctx);
        if (!HussarFixedCacheUtil.containKey((String)"ds", (Object)"work_flow_instance:".concat(instanceId))) {
            HussarFixedCacheUtil.put((String)"ds", (Object)"work_flow_instance:".concat(instanceId), (Object)new DataStreamDataResponseDto(DataStreamDataResponseDto.DataStreamDataResponseDtoEnum.WAITING), (long)TimeUnit.HOURS.toSeconds(1L));
        }
        return instanceId;
    }

    public DataStreamDataResponseDto dataStreamGetDataByInstanceId(String instanceId) {
        DataStreamDataResponseDto workFlowInstanceResult = (DataStreamDataResponseDto)HussarFixedCacheUtil.get((String)"ds", (Object)"work_flow_instance:".concat(instanceId), DataStreamDataResponseDto.class);
        if (ObjectUtil.isEmpty((Object)workFlowInstanceResult)) {
            return new DataStreamDataResponseDto(DataStreamDataResponseDto.DataStreamDataResponseDtoEnum.WAITING);
        }
        if (workFlowInstanceResult.isSuccess() && ObjectUtil.isNotEmpty((Object)workFlowInstanceResult.getPath())) {
            List result = DuckDBUtil.readDataByPath((String)workFlowInstanceResult.getPath());
            return DataStreamDataResponseDto.success((List)result);
        }
        return workFlowInstanceResult;
    }

    public DataStreamInfoResponseDto dataStreamGetById(Long dataSetId) {
        DataStreamInfoResponseDto result = new DataStreamInfoResponseDto();
        result.setDataSetId(dataSetId);
        WordDataSetInfo wordDataSetInfo = (WordDataSetInfo)this.dataSetService.getById((Serializable)dataSetId);
        HussarException.throwByNull((Object)wordDataSetInfo, (Integer)DpExceptionEnum.FAILED_TO_GET_DATASET_INFO.getCode(), (String)DpExceptionEnum.FAILED_TO_GET_DATASET_INFO.getMessage());
        result.setDataSetName(wordDataSetInfo.getDataSetName());
        DataStreamDataSet dataStreamDataSet = (DataStreamDataSet)this.getById(dataSetId);
        if (ObjectUtil.isNotEmpty((Object)dataStreamDataSet)) {
            DataStreamCanvas dataStreamCanvas = this.dataStreamCanvasService.getByDataSetIdAndVersion(dataSetId, dataStreamDataSet.getLastVersion());
            result.setCanvasId(dataStreamCanvas.getCanvasId());
            result.setCanvasDesc(dataStreamCanvas.getCanvasDesc());
            String canvasContent = DataStreamCanvasContentConverter.convert(dataStreamCanvas.getCanvasContent());
            result.setCanvasContent((Object)canvasContent);
        }
        return result;
    }

    @Deprecated
    private void conductorDeleteWorkFlow(Long dataSetId, Integer newVersion) {
        String url = this.dataStreamProperties.getConductorUrl() + FlowEngineConstant.getDeleteMetaData((Long)dataSetId, (Integer)newVersion);
        HttpUtil.sendDelete((String)url, new HashMap(), new HashMap());
    }

    private String conductorPreviewWorkFlow(ProcessCtx ctx) throws DpException {
        String url = this.dataStreamProperties.getConductorUrl() + "/api/workflow";
        DpApiWorkflowDefDto workflowDefDto = WorkFlowUtil.convertEngine((ProcessCtx)ctx);
        workflowDefDto.setName(HussarUtils.toStr((Object)ctx.getDataSetId()));
        workflowDefDto.setComment(ctx.getName());
        if (ObjectUtil.isNotEmpty((Object)ctx.getVersion())) {
            workflowDefDto.setVersion(ctx.getVersion().intValue());
        }
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("workflowDef", workflowDefDto);
        requestBody.put("name", ctx.getDataSetId());
        String instanceId = HttpUtil.sendPostErrorNotReturn((String)url, requestBody, new HashMap(), new HashMap());
        log.info("\u8c03\u7528\u6d41\u7a0b\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)instanceId);
        HussarException.throwByNull((Object)instanceId, (Integer)DpExceptionEnum.EXCEPTION_START_WORKFLOW.getCode(), (String)DpExceptionEnum.EXCEPTION_START_WORKFLOW.getMessage());
        return instanceId;
    }

    public String conductorStartWorkFlow(@NotNull Long dataSetId, @Nullable Integer newVersion, @Nullable Map<String, Object> param) {
        String url = this.dataStreamProperties.getConductorUrl() + "/api/workflow";
        if (null == param) {
            param = Maps.newHashMapWithExpectedSize((int)2);
        }
        param.put("version", newVersion);
        param.put("name", dataSetId);
        String instanceId = HttpUtil.sendPostErrorNotReturn((String)url, (Object)param, new HashMap(), new HashMap());
        HussarException.throwByNull((Object)instanceId, (Integer)DpExceptionEnum.EXCEPTION_START_WORKFLOW.getCode(), (String)DpExceptionEnum.EXCEPTION_START_WORKFLOW.getMessage());
        return instanceId;
    }

    public List<JSONObject> dataStreamGetJobDataByDataSetId(String dataSetId) {
        return null;
    }

    public Boolean checkTableName(DpCheckTableNameDto checkTableNameDto) {
        return this.checkTableName(checkTableNameDto.getDataSetId(), checkTableNameDto.getTableName(), "master");
    }

    private Boolean checkTableName(Long dataSetId, String tableName, String datasourceName) {
        HussarException.throwByNull((Object)dataSetId, (Integer)DpExceptionEnum.NOT_EMPTY_DATASET_ID.getCode(), (String)DpExceptionEnum.NOT_EMPTY_DATASET_ID.getMessage());
        HussarException.throwByNull((Object)tableName, (Integer)DpExceptionEnum.NOT_EMPTY_TABLE_NAME.getCode(), (String)DpExceptionEnum.NOT_EMPTY_TABLE_NAME.getMessage());
        HussarException.throwByNull((Object)datasourceName, (Integer)DpExceptionEnum.NOT_EMPTY_DATASOURCE_NAME.getCode(), (String)DpExceptionEnum.NOT_EMPTY_DATASOURCE_NAME.getMessage());
        DataStreamDataSet dataStreamDataSet = (DataStreamDataSet)this.getById(dataSetId);
        if (HussarUtils.isNotEmpty((Object)dataStreamDataSet) && HussarUtils.equals((Object)tableName, (Object)dataStreamDataSet.getTableName())) {
            return Boolean.TRUE;
        }
        return !this.existsTable(datasourceName, tableName);
    }

    private void createJob(DataStreamSaveRequestDto dataStreamSaveRequestDto) {
        Long dataSetId = dataStreamSaveRequestDto.getDataSetId();
        OutPutConfigModel config = this.getOutputConfig(dataStreamSaveRequestDto);
        DpJobInfo dpJobInfo = this.dpJobInfoService.getByDataSetId(dataSetId);
        if (HussarUtils.isNotEmpty((Object)config) && HussarUtils.equals((Object)"db", (Object)config.getSaveType()) && config.getAutoTask().booleanValue()) {
            if (HussarUtils.isEmpty((Object)dpJobInfo)) {
                dpJobInfo = new DpJobInfo();
            }
            dpJobInfo.setDataSetId(dataSetId);
            dpJobInfo.setFirstExecuteTime(config.getFirstExecuteTime());
            LocalDateTime nextTime = dpJobInfo.getNextTime();
            if (HussarUtils.isEmpty((Object)dpJobInfo.getNextTime())) {
                nextTime = LocalDateTimeUtil.parse((CharSequence)config.getFirstExecuteTime(), (String)"yyyy-MM-dd HH:mm:ss");
            }
            while (nextTime.isBefore(LocalDateTime.now())) {
                dpJobInfo.setNextTime(nextTime);
                nextTime = this.calcNextTime(dpJobInfo);
            }
            dpJobInfo.setPeriodType(config.getPeriodType());
            dpJobInfo.setWeek(config.getWeek());
            dpJobInfo.setHours(config.getHours());
            dpJobInfo.setMinutes(config.getMinutes());
            dpJobInfo.setTime(config.getTime());
            this.dpJobInfoService.saveOrUpdate((Object)dpJobInfo);
        } else if (HussarUtils.isNotEmpty((Object)dpJobInfo)) {
            this.dpJobInfoService.removeById((Object)dpJobInfo);
        }
    }

    private LocalDateTime calcNextTime(DpJobInfo config) {
        LocalDateTime current = LocalDateTime.now();
        LocalDateTime nextTime = config.getNextTime();
        switch (config.getPeriodType()) {
            case "MINUTES": {
                nextTime = nextTime.plusMinutes(config.getMinutes().intValue());
                break;
            }
            case "HOURS": {
                nextTime = nextTime.plusHours(config.getHours().intValue());
                break;
            }
            case "DAYS": {
                LocalTime localTime = LocalTime.parse(config.getTime());
                nextTime = current.toLocalDate().atTime(localTime);
                if (!nextTime.isBefore(current)) break;
                nextTime = nextTime.plusDays(1L);
                break;
            }
            case "WEEK": {
                Integer week = config.getWeek();
                LocalDateTime candidateDate = current.plusDays(week + 1 - current.getDayOfWeek().getValue());
                nextTime = candidateDate.toLocalDate().atTime(LocalTime.parse(config.getTime()));
                if (!nextTime.isBefore(current)) break;
                nextTime = nextTime.plusWeeks(1L);
                break;
            }
            default: {
                throw new HussarException(Integer.valueOf(DpExceptionEnum.UNSUPPORTED_UPDATE_CYCLE_TYPE.getCode()), DpExceptionEnum.UNSUPPORTED_UPDATE_CYCLE_TYPE.getMessage());
            }
        }
        return nextTime;
    }

    private OutPutConfigModel createTable(DataStreamSaveRequestDto dataStreamSaveRequestDto, List<ColumnFieldDto> columnFieldList) {
        OutPutConfigModel config = this.getOutputConfig(dataStreamSaveRequestDto);
        if (HussarUtils.isNotEmpty((Object)config) && HussarUtils.equals((Object)"db", (Object)config.getSaveType())) {
            Boolean canCreateTable = this.checkTableName(dataStreamSaveRequestDto.getDataSetId(), config.getTableName(), config.getDataSourceName());
            HussarException.throwBy((canCreateTable == false ? 1 : 0) != 0, (Integer)DpExceptionEnum.EXIST_DB_TABLE.getCode(), (String)DpExceptionEnum.EXIST_DB_TABLE.getMessage());
        }
        if (this.existsTable(config.getDataSourceName(), config.getTableName())) {
            List<DsTableField> oldTableFields = this.getColumnsByTableName(config.getDataSourceId(), config.getTableName());
            this.editTableField(config.getDataSourceName(), config.getTableName(), oldTableFields, columnFieldList);
        } else {
            this.buildNewTable(config.getDataSourceName(), config.getTableName(), config.getTableComment(), columnFieldList);
        }
        return config;
    }

    private boolean existsTable(String datasourceName, String tableName) {
        List metadataTables = this.hussarDdlService.selectTablesByTableNames(Collections.singletonList(tableName), datasourceName);
        return metadataTables.size() > 0;
    }

    private List<DsTableField> getColumnsByTableName(Long dataSourceId, String tableName) {
        try {
            List tableFields = this.datasourceDataService.getTableFieldByTableName(dataSourceId, tableName.toUpperCase());
            HussarException.throwByNull((Object)tableFields, (String)"\u67e5\u8be2\u8868\u7ed3\u6784\u5931\u8d25");
            return tableFields;
        }
        catch (DataSourceException | HussarException | IOException e) {
            log.error("\u67e5\u8be2\u8868\u662f\u5426\u5b58\u5728\u5931\u8d25", e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.FAILED_TO_QUERY_TABLE_STRUCTURE.getCode()), DpExceptionEnum.FAILED_TO_QUERY_TABLE_STRUCTURE.getMessage(), e);
        }
    }

    private void editTableField(String datasourceName, String tableName, List<DsTableField> oldTableFields, List<ColumnFieldDto> newTableFields) {
        HussarException.throwByNull(oldTableFields, (Integer)DpExceptionEnum.NOT_EMPTY_PREVIOUS_TABLE_FIELD.getCode(), (String)DpExceptionEnum.NOT_EMPTY_PREVIOUS_TABLE_FIELD.getMessage());
        HussarException.throwByNull(newTableFields, (Integer)DpExceptionEnum.NOT_EMPTY_CURRENT_TABLE_FIELD.getCode(), (String)DpExceptionEnum.NOT_EMPTY_CURRENT_TABLE_FIELD.getMessage());
        List<ColumnInfoDto> oldColumns = this.convertTableField(oldTableFields);
        MetadataParam metadataParam = new MetadataParam();
        metadataParam.setSchemaName(datasourceName);
        TableInfoDto tableInfoDto = new TableInfoDto();
        metadataParam.setTableInfo(tableInfoDto);
        tableInfoDto.setTableName(tableName);
        List tableFieldNames = oldTableFields.stream().map(DsTableField::getName).collect(Collectors.toList());
        ArrayList addFields = Lists.newArrayListWithCapacity((int)10);
        for (ColumnFieldDto newField : newTableFields) {
            if (tableFieldNames.contains(newField.getFieldId())) continue;
            ColumnInfoDto column = this.buildColumnField(newField);
            column.setOperation("add");
            addFields.add(column);
        }
        metadataParam.setColumnInfo((List)addFields);
        try {
            this.hussarDdlService.editTable(metadataParam, oldColumns, tableName);
        }
        catch (SQLException e) {
            log.error("\u8868\u5b57\u6bb5\u65b0\u589e\u5931\u8d25", (Throwable)e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.FAILED_TO_ADD_TABLE_FIELD.getCode()), DpExceptionEnum.FAILED_TO_ADD_TABLE_FIELD.getMessage(), (Throwable)e);
        }
    }

    private List<ColumnInfoDto> convertTableField(List<DsTableField> tableFields) {
        return tableFields.stream().map(field -> {
            ColumnInfoDto columnInfoDto = new ColumnInfoDto();
            columnInfoDto.setColumnName(field.getName());
            columnInfoDto.setColumnComment(field.getComment());
            columnInfoDto.setPk(field.getPrimarys());
            columnInfoDto.setDataType(field.getType());
            columnInfoDto.setDataLength(Long.valueOf(field.getDataLength()));
            columnInfoDto.setDataDot(Integer.valueOf(field.getDataDot()));
            columnInfoDto.setDataIsEmpty(Integer.valueOf(field.getDataIsEmpty() ? 1 : 0));
            columnInfoDto.setDefaultValue(field.getDataDefaultValue());
            return columnInfoDto;
        }).collect(Collectors.toList());
    }

    private void buildNewTable(String datasourceName, String tableName, String tableComment, List<ColumnFieldDto> fieldList) {
        MetadataParam metadataParam = new MetadataParam();
        TableInfoDto tableInfoDto = new TableInfoDto();
        tableInfoDto.setTableDec(tableComment);
        tableInfoDto.setPollName(datasourceName);
        tableInfoDto.setTableName(tableName);
        metadataParam.setTableInfo(tableInfoDto);
        ArrayList columnInfoList = Lists.newArrayListWithCapacity((int)fieldList.size());
        for (ColumnFieldDto field : fieldList) {
            ColumnInfoDto columnInfoDto = this.buildColumnField(field);
            columnInfoList.add(columnInfoDto);
        }
        ColumnInfoDto columnInfoDto = new ColumnInfoDto();
        columnInfoDto.setPk("1");
        columnInfoDto.setRequired("1");
        columnInfoDto.setColumnName("id");
        columnInfoDto.setJdbcType(JDBCType.BIGINT.name());
        columnInfoDto.setDataType("BIGINT");
        columnInfoDto.setDataDot(Integer.valueOf(0));
        columnInfoDto.setDataLength(Long.valueOf(20L));
        columnInfoList.add(columnInfoDto);
        columnInfoDto = new ColumnInfoDto();
        columnInfoDto.setPk("0");
        columnInfoDto.setRequired("0");
        columnInfoDto.setColumnName("pid");
        columnInfoDto.setJdbcType(JDBCType.BIGINT.name());
        columnInfoDto.setDataType("BIGINT");
        columnInfoDto.setDataDot(Integer.valueOf(0));
        columnInfoDto.setDataLength(Long.valueOf(20L));
        columnInfoList.add(columnInfoDto);
        metadataParam.setColumnInfo((List)columnInfoList);
        metadataParam.setHavePk(true);
        this.hussarDdlService.createTable(metadataParam);
    }

    private ColumnInfoDto buildColumnField(ColumnFieldDto field) {
        ColumnInfoDto columnInfoDto = new ColumnInfoDto();
        columnInfoDto.setPk("0");
        columnInfoDto.setRequired("0");
        columnInfoDto.setColumnName(field.getFieldId());
        columnInfoDto.setColumnComment(field.getComment());
        FrontTypeEnum frontType = FrontTypeEnum.fromValue((String)field.getDataType());
        columnInfoDto.setJdbcType(frontType.getJdbcType());
        columnInfoDto.setDataLength(Long.valueOf(JDBCType.VARCHAR.name().equals(frontType.getJdbcType()) ? 255L : (JDBCType.BIGINT.name().equals(frontType.getJdbcType()) ? 20L : (JDBCType.INTEGER.name().equals(frontType.getJdbcType()) ? 11L : 20L))));
        columnInfoDto.setDataType(JDBCType.VARCHAR.name().equals(frontType.getJdbcType()) ? "varchar" : (JDBCType.TIMESTAMP.name().equals(frontType.getJdbcType()) ? "datetime" : (JDBCType.INTEGER.name().equals(frontType.getJdbcType()) ? "INT" : (JDBCType.BIGINT.name().equals(frontType.getJdbcType()) ? "BIGINT" : "varchar"))));
        if (JDBCType.BIGINT.name().equals(frontType.getJdbcType()) || JDBCType.INTEGER.name().equals(frontType.getJdbcType())) {
            columnInfoDto.setDataDot(Integer.valueOf(0));
        }
        return columnInfoDto;
    }

    private void conductorMetadataWorkFlow(ProcessCtx ctx) throws DpException {
        DpApiWorkflowDefDto workflowDefDto = WorkFlowUtil.convertEngine((ProcessCtx)ctx);
        workflowDefDto.setName(HussarUtils.toStr((Object)ctx.getDataSetId()));
        workflowDefDto.setComment(ctx.getName());
        if (ObjectUtil.isNotEmpty((Object)ctx.getVersion())) {
            workflowDefDto.setVersion(ctx.getVersion().intValue());
        }
        String url = this.dataStreamProperties.getConductorUrl() + "/api/metadata/workflow";
        Map requestBody = (Map)JSON.parseObject((String)JSON.toJSONString((Object)workflowDefDto), HashMap.class);
        ArrayList<Map> bodyList = new ArrayList<Map>();
        bodyList.add(requestBody);
        String response = HttpUtil.sendPut((String)url, bodyList, new HashMap(), new HashMap());
        log.info("\u8c03\u7528\u6d41\u7a0b\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)response);
    }

    private void saveDataStreamInfo(DataStreamSaveRequestDto dataStreamSaveRequestDto, Integer newVersion, OutPutConfigModel outPutConfigModel) {
        Long dataSetId = dataStreamSaveRequestDto.getDataSetId();
        DataStreamDataSet dataStreamDataSet = (DataStreamDataSet)this.getById(dataSetId);
        if (ObjectUtil.isEmpty((Object)dataStreamDataSet)) {
            dataStreamDataSet = new DataStreamDataSet();
            dataStreamDataSet.setDataSetId(dataSetId);
        }
        dataStreamDataSet.setCanvasId(dataStreamSaveRequestDto.getCanvasId());
        dataStreamDataSet.setLastVersion(newVersion);
        dataStreamDataSet.setTableName(outPutConfigModel.getTableName());
        dataStreamDataSet.setDataSetName(dataStreamSaveRequestDto.getDataSetName());
        this.saveOrUpdate((BaseEntity)dataStreamDataSet);
    }

    private Integer saveCanvasInfo(DataStreamSaveRequestDto dataStreamSaveRequestDto) {
        boolean newVersion;
        Long dataSetId = dataStreamSaveRequestDto.getDataSetId();
        DataStreamCanvas dataStreamCanvas = new DataStreamCanvas();
        dataStreamCanvas.setCanvasContent(dataStreamSaveRequestDto.getCanvasContent());
        dataStreamCanvas.setCanvasDesc(dataStreamSaveRequestDto.getCanvasDesc());
        dataStreamCanvas.setDataSetId(dataSetId);
        boolean bl = newVersion = !"1".equals(dataStreamSaveRequestDto.getCanvasVersionCurrent());
        if (newVersion) {
            int currentVersion = this.dataStreamCanvasService.getMaxVersionByDataSetId(dataSetId);
            dataStreamCanvas.setCanvasVersion(Integer.valueOf(currentVersion + 1));
            dataStreamCanvas.setCanvasId(null);
            boolean save = this.dataStreamCanvasService.save((Object)dataStreamCanvas);
            HussarException.throwBy((!save ? 1 : 0) != 0, (Integer)DpExceptionEnum.FAILED_TO_SAVE_CANVAS_INFO.getCode(), (String)DpExceptionEnum.FAILED_TO_SAVE_CANVAS_INFO.getMessage());
        } else {
            DataStreamCanvas dataStreamCanvasOld = (DataStreamCanvas)this.dataStreamCanvasService.getById((Serializable)dataStreamSaveRequestDto.getCanvasId());
            dataStreamCanvas.setCanvasVersion(dataStreamCanvasOld.getCanvasVersion());
            dataStreamCanvas.setCanvasId(dataStreamCanvasOld.getCanvasId());
            dataStreamCanvas.setDelFlag("0");
            boolean save = this.dataStreamCanvasService.updateById((Object)dataStreamCanvas);
            HussarException.throwBy((!save ? 1 : 0) != 0, (Integer)DpExceptionEnum.FAILED_TO_UPDATE_CANVAS_INFO.getCode(), (String)DpExceptionEnum.FAILED_TO_UPDATE_CANVAS_INFO.getMessage());
        }
        Long canvasId = dataStreamCanvas.getCanvasId();
        HussarException.throwByNull((Object)canvasId, (Integer)DpExceptionEnum.FAILED_TO_GET_CANVAS_ID.getCode(), (String)DpExceptionEnum.FAILED_TO_GET_CANVAS_ID.getMessage());
        dataStreamSaveRequestDto.setCanvasId(canvasId);
        return dataStreamCanvas.getCanvasVersion();
    }

    private Long saveDataToDataSet(DataStreamSaveRequestDto dataStreamSaveRequestDto, List<ColumnFieldDto> resultColumnFieldList1, OutPutConfigModel outPutConfigModel) {
        Long dataSetId = dataStreamSaveRequestDto.getDataSetId();
        DataSetConfigInfoDto dataSetDataDto = new DataSetConfigInfoDto();
        final DataSetOperationDto dataSetOperationDto = new DataSetOperationDto();
        dataSetDataDto.setOperations((List)new ArrayList<DataSetOperationDto>(){
            {
                this.add(dataSetOperationDto);
            }
        });
        ApiDataContent apiDataContent = new ApiDataContent();
        dataSetOperationDto.setReturnValue(apiDataContent);
        apiDataContent.setObjectType(FieldTypeEnum.ARRAY.getValue());
        ArrayList<ApiProperty> topProperties = new ArrayList<ApiProperty>();
        apiDataContent.setProperties(topProperties);
        ArrayList<ColumnFieldDto> resultColumnFieldList = new ArrayList<ColumnFieldDto>(resultColumnFieldList1);
        Set<String> groupIdSet = resultColumnFieldList.stream().filter(action -> HussarUtils.isEmpty((Object)action.getParentGroupId())).peek(action -> {
            ApiProperty oneColumn = new ApiProperty();
            oneColumn.setId(action.getFieldId());
            oneColumn.setComment(action.getComment());
            oneColumn.setName(action.getName());
            oneColumn.setDataType(action.getDataType());
            oneColumn.setProperties(new ArrayList());
            topProperties.add(oneColumn);
        }).map(ColumnFieldDto::getGroupId).collect(Collectors.toSet());
        resultColumnFieldList.removeIf(action -> ObjectUtil.isEmpty((Object)action.getParentGroupId()));
        this.addColumnFieldByGroupId(resultColumnFieldList, topProperties, groupIdSet);
        DsTableInfo dsTableInfo = new DsTableInfo();
        dsTableInfo.setName(outPutConfigModel.getTableName());
        SqlConfigSchema1 sqlConfigSchema1 = this.dataSetProcessor.packageDataSetParam(dsTableInfo, outPutConfigModel.getDataSourceId(), outPutConfigModel.getDataSourceName());
        dataSetDataDto.setDataSetParam(sqlConfigSchema1);
        WordDataSetInfo wordDataSetInfo = (WordDataSetInfo)this.dataSetService.getById((Serializable)dataSetId);
        wordDataSetInfo.setData(JsonUtil.toJson((Object)dataSetDataDto));
        wordDataSetInfo.setDataSetType(DataSetTypeEnum.DATA_STREAM.getCode());
        wordDataSetInfo.setDataSourceName(outPutConfigModel.getDataSourceName());
        wordDataSetInfo.setDataSourceId(outPutConfigModel.getDataSourceId());
        wordDataSetInfo.setDataSetName(dataStreamSaveRequestDto.getDataSetName());
        wordDataSetInfo.setDataSetId(dataSetId);
        this.dataSetService.editDataSetInfo((DataSetInfoDto)JsonUtil.parse((String)JsonUtil.toJson((Object)wordDataSetInfo), DataSetInfoDto.class));
        dataStreamSaveRequestDto.setDataSetId(wordDataSetInfo.getDataSetId());
        return wordDataSetInfo.getDataSetId();
    }

    private void addColumnFieldByGroupId(List<ColumnFieldDto> resultColumnFieldList, List<ApiProperty> topColumn, Collection<String> groupIdSet) {
        for (String parentGroupId : groupIdSet) {
            Map<String, List<ColumnFieldDto>> groupId2ColumnInfo = resultColumnFieldList.stream().filter(action -> ObjectUtils.isNotEmpty((Object)action.getParentGroupId()) && action.getParentGroupId().equals(parentGroupId)).collect(Collectors.groupingBy(ColumnFieldDto::getGroupId));
            resultColumnFieldList.removeIf(action -> ObjectUtils.isNotEmpty((Object)action.getParentGroupId()) && action.getParentGroupId().equals(parentGroupId));
            groupId2ColumnInfo.forEach((groupId, list) -> {
                ArrayList<ApiProperty> one = new ArrayList<ApiProperty>();
                for (ColumnFieldDto action : list) {
                    ApiProperty oneColumn = new ApiProperty();
                    oneColumn.setId(action.getFieldId());
                    oneColumn.setComment(action.getComment());
                    oneColumn.setName(action.getName());
                    oneColumn.setDataType(action.getDataType());
                    oneColumn.setProperties(new ArrayList());
                    one.add(oneColumn);
                }
                ApiProperty objectColumnFieldDto = new ApiProperty();
                objectColumnFieldDto.setId(groupId);
                objectColumnFieldDto.setName("list_" + groupId);
                objectColumnFieldDto.setDataType(FieldTypeEnum.ARRAY.getValue());
                objectColumnFieldDto.setProperties(one);
                topColumn.add(objectColumnFieldDto);
                this.addColumnFieldByGroupId(resultColumnFieldList, one, Collections.singletonList(groupId));
            });
        }
    }

    private List<ColumnFieldDto> init(DataStreamSaveRequestDto dataStreamSaveRequestDto) throws DpException {
        ProcessCtx ctx = new ProcessCtx();
        ctx.setCanvasContent(dataStreamSaveRequestDto.getCanvasContent());
        ctx.setDataSetId(dataStreamSaveRequestDto.getDataSetId());
        ctx.setName(dataStreamSaveRequestDto.getDataSetName());
        ctx.setVersion(Integer.valueOf(0));
        DpApiWorkflowDefDto dpApiWorkflowDefDto = WorkFlowUtil.convertEngine((ProcessCtx)ctx);
        List outPutTask = dpApiWorkflowDefDto.getTasks().stream().filter(action -> action.getName().startsWith(ModuleTypeEnum.OUT_PUT.name())).collect(Collectors.toList());
        HussarException.throwByNull(outPutTask, (Integer)DpExceptionEnum.NOT_EMPTY_OUTPUT_NODE.getCode(), (String)DpExceptionEnum.NOT_EMPTY_OUTPUT_NODE.getMessage());
        Map inputParameters = ((DpApiFlowTaskDto)outPutTask.get(0)).getInputParameters();
        ArrayList o = inputParameters.getOrDefault("parentFieldList", Lists.newArrayListWithCapacity((int)0));
        List columnFieldList = JsonUtil.parseArray((String)JsonUtil.toJson((Object)o), ColumnFieldDto.class);
        HussarException.throwByNull((Object)columnFieldList, (Integer)DpExceptionEnum.NOT_EMPTY_PARAMS_LIST.getCode(), (String)DpExceptionEnum.NOT_EMPTY_PARAMS_LIST.getMessage());
        return columnFieldList;
    }

    private OutPutConfigModel getOutputConfig(DataStreamSaveRequestDto dataStreamSaveRequestDto) {
        DocumentContext jsonContext = JsonPath.parse((String)dataStreamSaveRequestDto.getCanvasContent());
        Object read = jsonContext.read("$.nodes", new Predicate[0]);
        List dpApiBaseWidgets = JSON.parseArray((String)JSON.toJSONString((Object)read), DpApiBaseWidget.class);
        Optional<DpApiBaseWidget> any = dpApiBaseWidgets.stream().filter(x -> HussarUtils.equals((Object)x.getName(), (Object)ModuleTypeEnum.OUT_PUT.getName())).findAny();
        if (any.isPresent()) {
            CanvasPropsDTO props = any.get().getProps();
            CanvasDetailConfigDTO detailConfig = props.getDetailConfig();
            OutPutConfigModel outPutConfigModel = (OutPutConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), OutPutConfigModel.class);
            if (HussarUtils.isNotEmpty((Object)outPutConfigModel) && HussarUtils.isNotEmpty((Object)outPutConfigModel.getSaveType()) && !HussarUtils.equals((Object)"db", (Object)outPutConfigModel.getSaveType())) {
                outPutConfigModel.setTableName(String.format("DATA_STREAM_TMP_%s", dataStreamSaveRequestDto.getDataSetId()));
                outPutConfigModel.setTableComment(String.format("\u4e34\u65f6\u8868_%s", dataStreamSaveRequestDto.getDataSetId()));
            }
            if (HussarUtils.isEmpty((Object)outPutConfigModel.getDataSourceId())) {
                outPutConfigModel.setDataSourceName("master");
                SysDataSource dataSource = this.sysDataSourceService.getByConnName(outPutConfigModel.getDataSourceName());
                outPutConfigModel.setDataSourceId(dataSource.getId());
            }
            return outPutConfigModel;
        }
        return null;
    }

    public Map<String, Object> exportDataStreamAndCanvas(List<Long> dataSetIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<DataStreamSaveRequestDto> dataStreamSaveRequestDtos = new ArrayList<DataStreamSaveRequestDto>();
        HashSet<Long> visited = new HashSet<Long>();
        try {
            for (Long dataSetId : dataSetIds) {
                this.processDataSetRecursive(dataSetId, visited, dataStreamSaveRequestDtos);
            }
            result.put("dataSetIds", new ArrayList(visited));
            result.put("dataStream", dataStreamSaveRequestDtos);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5d4c\u5957\u6570\u636e\u6d41\u5931\u8d25", (Throwable)e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.EXPORT_DATA_STREAM_ERROR.getCode()), DpExceptionEnum.EXPORT_DATA_STREAM_ERROR.getMessage());
        }
        return result;
    }

    public List<Long> extractEntryIds(String json) {
        Set<Object> dataSetIds = new HashSet();
        try {
            JSONObject rootNode = (JSONObject)JsonUtil.parse((String)json, JSONObject.class);
            JSONObject resultNode = new JSONObject();
            resultNode.put("nodes", rootNode.get((Object)"nodes"));
            dataSetIds = this.findDataSetIds(resultNode);
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u5d4c\u5957\u6570\u636e\u96c6id\u5f02\u5e38", (Throwable)e);
            throw new HussarException(Integer.valueOf(DpExceptionEnum.EXPORT_DATA_STREAM_SEARCH_ID_ERROR.getCode()), DpExceptionEnum.EXPORT_DATA_STREAM_SEARCH_ID_ERROR.getMessage());
        }
        return new ArrayList<Long>(dataSetIds);
    }

    private Set<Long> findDataSetIds(JSONObject node) {
        HashSet<Long> dataSetIds = new HashSet<Long>();
        JSONArray nodes = node.getJSONArray("nodes");
        for (int i = 0; i < nodes.size(); ++i) {
            DataSetInputConfigModel config;
            JSONObject nodeObject = nodes.getJSONObject(i);
            if (!nodeObject.containsKey((Object)"data")) continue;
            JSONObject data = nodeObject.getJSONObject("data");
            String componentKey = data.getString("componentKey");
            CanvasDetailConfigDTO detailConfig = (CanvasDetailConfigDTO)JsonUtil.parse((String)data.getJSONObject("detailConfig").toJSONString(), CanvasDetailConfigDTO.class);
            if (HussarUtils.isEmpty((Object)detailConfig)) continue;
            if (HussarUtils.equals((Object)ModuleTypeEnum.DATA_SET_INPUT.getName(), (Object)componentKey)) {
                config = (DataSetInputConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), DataSetInputConfigModel.class);
                String dataSetId2 = config.getDataSetId();
                dataSetIds.add(Long.valueOf(dataSetId2));
                continue;
            }
            if (!HussarUtils.equals((Object)ModuleTypeEnum.MASTER_FIELD.getName(), (Object)componentKey) && !HussarUtils.equals((Object)ModuleTypeEnum.JOIN_FIELD.getName(), (Object)componentKey)) continue;
            config = (JoinFieldConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), JoinFieldConfigModel.class);
            config.getDataSetList().stream().map(DataSetInputConfigModel::getDataSetId).forEach(dataSetId -> dataSetIds.add(Long.valueOf(dataSetId)));
        }
        return dataSetIds;
    }

    private void processDataSetRecursive(Long dataSetId, Set<Long> visited, List<DataStreamSaveRequestDto> dataStreamSaveRequestDtos) {
        if (visited.contains(dataSetId)) {
            return;
        }
        visited.add(dataSetId);
        DataStreamDataSet dataStreamDataSet = (DataStreamDataSet)this.getById(dataSetId);
        if (HussarUtils.isEmpty((Object)dataStreamDataSet)) {
            return;
        }
        DataStreamSaveRequestDto dataStreamSaveRequestDto = new DataStreamSaveRequestDto();
        dataStreamSaveRequestDto.setDataSetId(dataStreamDataSet.getDataSetId());
        dataStreamSaveRequestDto.setCanvasId(dataStreamDataSet.getCanvasId());
        DataStreamCanvas dataStreamCanvas = (DataStreamCanvas)this.dataStreamCanvasService.getById((Serializable)dataStreamDataSet.getCanvasId());
        dataStreamCanvas.setCanvasContent(DataStreamCanvasContentConverter.convert(dataStreamCanvas.getCanvasContent()));
        dataStreamSaveRequestDto.setCanvasContent((Object)dataStreamCanvas.getCanvasContent());
        dataStreamSaveRequestDto.setCanvasDesc(dataStreamCanvas.getCanvasDesc());
        dataStreamSaveRequestDto.setDataSetName(dataStreamDataSet.getDataSetName());
        dataStreamSaveRequestDtos.add(dataStreamSaveRequestDto);
        List<Long> newdataSetIds = this.extractEntryIds(dataStreamCanvas.getCanvasContent());
        if (HussarUtils.isNotEmpty(newdataSetIds)) {
            newdataSetIds.stream().forEach(id -> this.processDataSetRecursive((Long)id, visited, dataStreamSaveRequestDtos));
        }
    }
}

