/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.http.util;

import com.jxdinfo.hussar.ds.process.dto.ApiType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class HttpsClientWithCertUtil {
    public static HttpComponentsClientHttpRequestFactory getFactory(ApiType apiType) throws Exception {
        KeyManager[] keyManagers = null;
        FileInputStream certInput = null;
        FileInputStream keyInput = null;
        if (apiType.getType() == ApiType.Type.HTTP) {
            return new HttpComponentsClientHttpRequestFactory();
        }
        ApiType.CertType type = apiType.getCertType();
        String certPath = apiType.getCertPath();
        String keyPath = apiType.getKeyPath();
        String password = apiType.getPassword();
        if (type == ApiType.CertType.PFX) {
            try {
                certInput = new FileInputStream(certPath);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("PFX\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(certInput, password.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, password.toCharArray());
            keyManagers = kmf.getKeyManagers();
        } else if (type == ApiType.CertType.CRT_KEY) {
            PrivateKey privateKey;
            try {
                certInput = new FileInputStream(certPath);
                keyInput = new FileInputStream(keyPath);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("CRT\u6216KEY\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(certInput);
            PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(keyInput));
            Object object = pemParser.readObject();
            pemParser.close();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof PEMKeyPair) {
                privateKey = converter.getPrivateKey(((PEMKeyPair)object).getPrivateKeyInfo());
            } else if (object instanceof PrivateKeyInfo) {
                privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
            } else {
                throw new IllegalArgumentException("Unsupported private key format: " + object.getClass().getName());
            }
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null);
            keyStore.setKeyEntry("client", privateKey, password.toCharArray(), new Certificate[]{cert});
            for (Certificate certificate : keyStore.getCertificateChain("client")) {
                System.out.println(((X509Certificate)certificate).getSubjectDN());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, password.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        TrustManager[] trustAllManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustAllManagers, new SecureRandom());
        SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslContext);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)factory).build();
        return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

