/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.http.encrypt;

import com.jxdinfo.hussar.ds.process.http.factory.EncryptFactory;
import com.jxdinfo.hussar.ds.process.http.serve.EncryptParser;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import javax.annotation.PostConstruct;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.stereotype.Component;

@Component
public class SM4ECBParser
implements EncryptParser {
    private static final String ALGORITHM = "SM4";
    private static final String TYPE = "SM4";
    private static final String ECB_CIPHER = "SM4/ECB/PKCS5Padding";
    private static final String CBC_CIPHER = "SM4/CBC/PKCS5Padding";

    @PostConstruct
    public void register() {
        EncryptFactory.register("SM4", this);
    }

    public static String generateKey() {
        try {
            byte[] keyBytes = new byte[16];
            new SecureRandom().nextBytes(keyBytes);
            return Hex.toHexString((byte[])keyBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210SM4\u5bc6\u94a5\u5931\u8d25", e);
        }
    }

    @Override
    public String encrypt(String plainText, byte[] keyBytes) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "SM4");
            Cipher cipher = Cipher.getInstance(ECB_CIPHER, "BC");
            cipher.init(1, secretKeySpec);
            byte[] cipherBytes = cipher.doFinal(plainText.getBytes());
            return Base64.getEncoder().encodeToString(cipherBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("SM4\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    @Override
    public String decrypt(String cipherText, byte[] keyBytes) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "SM4");
            Cipher cipher = Cipher.getInstance(ECB_CIPHER, "BC");
            cipher.init(2, secretKeySpec);
            byte[] cipherBytes = Base64.getDecoder().decode(cipherText);
            return new String(cipher.doFinal(cipherBytes));
        }
        catch (Exception e) {
            throw new RuntimeException("SM4\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static String encryptCBC(String plainText, byte[] keyBytes, String iv) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "SM4");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(Hex.decode((String)iv));
            Cipher cipher = Cipher.getInstance(CBC_CIPHER, "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byte[] cipherBytes = cipher.doFinal(plainText.getBytes());
            return Base64.getEncoder().encodeToString(cipherBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("SM4\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static String decryptCBC(String cipherText, byte[] keyBytes, String iv) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "SM4");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(Hex.decode((String)iv));
            Cipher cipher = Cipher.getInstance(CBC_CIPHER, "BC");
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] cipherBytes = Base64.getDecoder().decode(cipherText);
            return new String(cipher.doFinal(cipherBytes));
        }
        catch (Exception e) {
            throw new RuntimeException("SM4\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static void main(String[] args) {
        try {
            String plainText = "Hello, SM4!";
            String key = SM4ECBParser.generateKey();
            String iv = "499474f95c540442c0f541b77bf28736";
            SM4ECBParser sm4ECBParser = new SM4ECBParser();
            String encryptedECB = sm4ECBParser.encrypt(plainText, Hex.decode((String)key));
            String decryptedECB = sm4ECBParser.decrypt(encryptedECB, Hex.decode((String)key));
            System.out.println("ECB\u52a0\u5bc6: " + encryptedECB);
            System.out.println("ECB\u89e3\u5bc6: " + decryptedECB);
            String encryptedCBC = SM4ECBParser.encryptCBC(plainText, Hex.decode((String)key), iv);
            String decryptedCBC = SM4ECBParser.decryptCBC(encryptedCBC, Hex.decode((String)key), iv);
            System.out.println("CBC\u52a0\u5bc6: " + encryptedCBC);
            System.out.println("CBC\u89e3\u5bc6: " + decryptedCBC);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

