/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.converter;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jxdinfo.hussar.ds.process.converter.po.DsCanvasEdgePo;
import com.jxdinfo.hussar.ds.process.converter.po.DsCanvasNodeDataPo;
import com.jxdinfo.hussar.ds.process.converter.po.DsCanvasNodePo;
import com.jxdinfo.hussar.ds.process.converter.po.DsCanvasPositionPo;
import com.jxdinfo.hussar.ds.process.converter.po.DsCanvasRootPo;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataStreamCanvasContentConverter {
    private static final String DATA_FLOW_CANVAS_VERSION = "2";

    public static String convert(String content) {
        DocumentContext jsonContext = JsonPath.parse((String)content);
        Map map = (Map)jsonContext.read("$", new Predicate[0]);
        if (map.containsKey("dataFlowCanvasVersion") && HussarUtils.equals(map.get("dataFlowCanvasVersion"), (Object)DATA_FLOW_CANVAS_VERSION)) {
            return content;
        }
        Object read = jsonContext.read("$.data.slots.default", new Predicate[0]);
        List oldNodeList = JsonUtil.parseArray((String)JsonUtil.toJson((Object)read), JSONObject.class);
        List<DsCanvasNodePo> newNodeList = oldNodeList.stream().map(oldNode -> {
            DsCanvasNodePo dsCanvasNodePo = new DsCanvasNodePo();
            dsCanvasNodePo.setId(oldNode.getString("instanceKey"));
            String nodeName = oldNode.getString("name").replace("com.jxdinfo.dsUi.", "");
            ModuleTypeEnum moduleTypeEnum = ModuleTypeEnum.getByName((String)nodeName);
            dsCanvasNodePo.setType(moduleTypeEnum.getNodeHandleType());
            DsCanvasPositionPo dsCanvasPositionPo = new DsCanvasPositionPo();
            dsCanvasPositionPo.setX(oldNode.getInteger("x"));
            dsCanvasPositionPo.setY(oldNode.getInteger("y"));
            dsCanvasNodePo.setPosition(dsCanvasPositionPo);
            DsCanvasNodeDataPo dsCanvasNodeDataPo = new DsCanvasNodeDataPo();
            dsCanvasNodePo.setData(dsCanvasNodeDataPo);
            dsCanvasNodeDataPo.setLabel(oldNode.getString("label"));
            dsCanvasNodeDataPo.setClassName(moduleTypeEnum.getClassName());
            dsCanvasNodeDataPo.setIconCard(moduleTypeEnum.getIconCard());
            dsCanvasNodeDataPo.setComponentKey(oldNode.getString("name").replace("com.jxdinfo.dsUi.", ""));
            dsCanvasNodeDataPo.setDetailConfig(oldNode.getJSONObject("props").get((Object)"detailConfig"));
            return dsCanvasNodePo;
        }).collect(Collectors.toList());
        List lineObjectList = (List)jsonContext.read("$.data.slots.path[*]", new Predicate[0]);
        ArrayList newLineList = Lists.newArrayListWithCapacity((int)10);
        if (HussarUtils.isNotEmpty((Object)lineObjectList)) {
            for (Object obj : lineObjectList) {
                JSONObject jsonObject = (JSONObject)JsonUtil.parse((String)JsonUtil.toJson(obj), JSONObject.class);
                DsCanvasEdgePo dsCanvasEdgePo = new DsCanvasEdgePo();
                dsCanvasEdgePo.setId(String.format("vueflow__edge-%s", IdUtil.simpleUUID()));
                String source = jsonObject.getJSONObject("start").getString("key");
                dsCanvasEdgePo.setSource(source);
                dsCanvasEdgePo.setSourceX(jsonObject.getJSONObject("start").getJSONObject("point").getDouble("x"));
                dsCanvasEdgePo.setSourceY(jsonObject.getJSONObject("start").getJSONObject("point").getDouble("y"));
                String target = jsonObject.getJSONObject("end").getString("key");
                dsCanvasEdgePo.setTarget(target);
                dsCanvasEdgePo.setTargetX(jsonObject.getJSONObject("end").getJSONObject("point").getDouble("x"));
                dsCanvasEdgePo.setTargetY(jsonObject.getJSONObject("end").getJSONObject("point").getDouble("y"));
                newLineList.add(dsCanvasEdgePo);
            }
        }
        DsCanvasRootPo dsCanvasRootPo = new DsCanvasRootPo().setNodes(newNodeList).setEdges(newLineList).setDataFlowCanvasVersion(DATA_FLOW_CANVAS_VERSION);
        return JsonUtil.toJson((Object)dsCanvasRootPo);
    }
}

