// 定义 MD5 加密函数
function md5(str) {
    if (!str || typeof str !== 'string') {
        return str;
    }
    // 引入 Java 的 MessageDigest 类
    var MessageDigest = Java.type("java.security.MessageDigest");

    // 引入 Java 的 Integer 类
    var Integer = Java.type("java.lang.Integer");

    // 引入 Java 的 StringBuffer 类
    var StringBuffer = Java.type("java.lang.StringBuffer");

    // 获取 MD5 摘要实例
    var digest = MessageDigest.getInstance("MD5");

    // 将字符串转换为字节数组，并进行摘要
    var bytes = digest.digest(str.getBytes("UTF-8"));

    // 将字节数组转换为十六进制字符串
    var hexString = new StringBuffer();
    for (var i = 0; i < bytes.length; i++) {
        var hex = Integer.toHexString(0xff & bytes[i]);
        if (hex.length === 1) {
            hexString.append('0');
        }
        hexString.append(hex);
    }

    // 返回 MD5 摘要结果
    return hexString.toString();
}