function httpPostFormData(url, formData, headers) {
    var URL = Java.type("java.net.URL");
    var HttpURLConnection = Java.type("java.net.HttpURLConnection");
    var ByteArrayOutputStream = Java.type("java.io.ByteArrayOutputStream");
    var DataOutputStream = Java.type("java.io.DataOutputStream");
    var Scanner = Java.type("java.util.Scanner");
    var StringBuilder = Java.type("java.lang.StringBuilder");

    var connection = null;
    var result = null;

    try {
        // 创建 URL 对象
        var connectionUrl = new URL(url);
        connection = connectionUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");

        // 定义边界字符串
        var boundary = "----WebKitFormBoundary7MA4YWxkTrZu0gW";

        // 设置自定义请求头
        if (headers) {
            for (var key in headers) {
                if (headers.hasOwnProperty(key)) {
                    connection.setRequestProperty(key, headers[key]);
                }
            }
        }

        // 使用 StringBuilder 构建请求体
        var sb = new StringBuilder();
        for (var key in formData) {
            if (formData.hasOwnProperty(key)) {
                sb.append("--").append(boundary).append("\r\n");
                sb.append("Content-Disposition: form-data; name=\"").append(key).append("\"\r\n\r\n");
                sb.append(formData[key]).append("\r\n");
            }
        }
        sb.append("--").append(boundary).append("--\r\n");

        // 将 StringBuilder 转换为字节数组
        var requestBytes = sb.toString().getBytes("UTF-8");

        // 设置请求体长度
        connection.setRequestProperty("Content-Length", "" + requestBytes.length);

        // 写入请求体
        var dos = new DataOutputStream(connection.getOutputStream());
        dos.write(requestBytes);
        dos.flush();
        dos.close();

        // 获取响应
        var responseCode = connection.getResponseCode();
        if (responseCode == HttpURLConnection.HTTP_OK) {
            var inputStream = connection.getInputStream();
            var scanner = new Scanner(inputStream).useDelimiter("\\A");
            result = scanner.hasNext() ? scanner.next() : "";
            scanner.close();
            inputStream.close();
        } else {
            print("Failed to get a successful response. Response Code: " + responseCode);
        }
    } catch (e) {
        print("Error: " + e.message);
    } finally {
        if (connection) {
            connection.disconnect(); // 确保连接被关闭
        }
    }

    return result;
}

// 示例调用
// var url = "http://localhost:8087/wzt/submitForm";
// var formData = {
//     "name": "张三",
//     "age": "18"
// };
// var headers = {
//     "Accept": "application/json"
// };
//
// postFormData(url, formData, headers);