// 定义发送 POST 请求的方法
function httpPost(url, body, headers) {
    // 引入 Java 类
    var URL = Java.type("java.net.URL");
    var HttpURLConnection = Java.type("java.net.HttpURLConnection");
    var OutputStreamWriter = Java.type("java.io.OutputStreamWriter");
    var BufferedReader = Java.type("java.io.BufferedReader");
    var InputStreamReader = Java.type("java.io.InputStreamReader");
    try {
        // 创建 URL 对象
        var urlObj = new URL(url);
        var connection = urlObj.openConnection();

        // 设置请求方法为 POST
        connection.setRequestMethod("POST");
        connection.setDoOutput(true); // 设置可以发送数据

        // 设置请求头
        if (headers) {
            for (var key in headers) {
                if (headers.hasOwnProperty(key)) {
                    connection.setRequestProperty(key, headers[key]);
                }
            }
        }

        // 写入请求体
        var writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(body);
        writer.flush();
        writer.close();

        // 获取响应码
        var responseCode = connection.getResponseCode();
        if (responseCode === HttpURLConnection.HTTP_OK) {
            // 读取响应内容
            var inputStream = connection.getInputStream();
            var reader = new BufferedReader(new InputStreamReader(inputStream));
            var response = "";
            var line;
            while ((line = reader.readLine()) !== null) {
                response += line + "\n";
            }
            reader.close();
            inputStream.close();
            return response; // 返回响应内容
        } else {
            print("Failed to get a successful response. Response Code: " + responseCode);
            return null; // 请求失败返回 null
        }
    } catch (e) {
        print("Error: " + e.message);
        return null; // 发生异常返回 null
    } finally {
        if (connection) {
            connection.disconnect(); // 断开连接
        }
    }
}