// 定义 HTTP GET 方法
function httpGet(url, headers) {
    var URL = Java.type("java.net.URL");
    var HttpURLConnection = Java.type("java.net.HttpURLConnection");

    try {
        var urlObj = new URL(url);
        var connection = urlObj.openConnection();

        // 设置请求方法为 GET
        connection.setRequestMethod("GET");

        // 设置请求头
        if (headers) {
            for (var key in headers) {
                if (headers.hasOwnProperty(key)) {
                    connection.setRequestProperty(key, headers[key]);
                }
            }
        }

        // 获取响应码
        var responseCode = connection.getResponseCode();
        print("Response Code: " + responseCode);

        if (responseCode === 200) {
            var inputStream = connection.getInputStream();
            var reader = new java.io.BufferedReader(new java.io.InputStreamReader(inputStream));
            var response = "";
            var line;
            while ((line = reader.readLine()) !== null) {
                response += line + "\n";
            }
            reader.close();
            inputStream.close();
            return response;
        } else {
            print("请求失败");
            return null;
        }
    } catch (e) {
        print("Error: " + e.message);
        return null;
    }
}