function isISO8601Format(str) {
    // 定义正则表达式
    var iso8601Regex = /^(\d{4})-(\d{2})-(\d{2})(T(\d{2}):(\d{2}):(\d{2})(\.(\d{1,}))?((Z)|([+-](\d{2}):(\d{2})))?)?$/;

    // 测试字符串是否符合正则表达式
    return iso8601Regex.test(str);
}

// 定义将时间戳转换为 yyyy-MM-dd HH:mm:ss 格式的函数
function formatDate(timestamp) {
    if (!timestamp) {
        return timestamp;
    }
    timestamp = '' + timestamp;
    timestamp = parseInt(timestamp);
    var date = new Date(timestamp);
    print(date.getTime());
    var year = date.getFullYear();
    var month = ("0" + (date.getMonth() + 1)).slice(-2); // 月份从 0 开始，需要加 1
    var day = ("0" + date.getDate()).slice(-2);
    var hours = ("0" + date.getHours()).slice(-2);
    var minutes = ("0" + date.getMinutes()).slice(-2);
    var seconds = ("0" + date.getSeconds()).slice(-2);

    return year + "-" + month + "-" + day + " " + hours + ":" + minutes + ":" + seconds;
}

// 定义将 yyyy-MM-dd HH:mm:ss 格式的字符串转换为时间戳的函数
function parseDate(str) {
    <#include "/templete/function/common/returnNotString.ftl">
    var dateTimeParts = str.split(" ");
    if (dateTimeParts.length !== 2) {
        if (isISO8601Format(str)) {
            var date = new Date(str);
            return date.getTime();
        }
        return str;
    }
    var dateParts = dateTimeParts[0].split("-");
    var timeParts = dateTimeParts[1].split(":");
    if (dateParts.length !== 3 || timeParts.length !== 3) {
        return str;
    }

    var year = parseInt(dateParts[0], 10);
    var month = parseInt(dateParts[1], 10) - 1; // 月份从 0 开始
    var day = parseInt(dateParts[2], 10);
    var hours = parseInt(timeParts[0], 10);
    var minutes = parseInt(timeParts[1], 10);
    var seconds = parseInt(timeParts[2], 10);

    var date = new Date(year, month, day, hours, minutes, seconds);
    return date.getTime();
}

function dataFormat(value, param1, param2) {
    if (!value) {
        return value;
    }
    if (param1 == 0 && param2 == 1) {
        return formatDate(value);
    }
    if (param1 == 1 && param2 == 0) {
        return parseDate(value);
    }
    return value;
}