// 定义一个方法来解析 JSON 数据并提取指定路径的数据
function extractDataFromPath(data, path) {
    var pathParts = path.split('.').slice(1); // 去掉第一个符号
    var current = data;

    for (var i = 0; i < pathParts.length; i++) {
        if (current[pathParts[i]] === undefined) {
            print("Path not found: " + path);
            return null;
        }
        current = current[pathParts[i]];
    }

    return current;
}

// 定义一个方法来处理提取的数据并返回结果
function processExtractedData(extractedData, valueField, labelField) {
    var result = {};

    if (Array.isArray(extractedData)) {
        // 如果是数组，提取每个对象中的 value 和 label 字段
        for (var i = 0; i < extractedData.length; i++) {
            var item = extractedData[i];
            if (item[valueField] !== undefined && item[labelField] !== undefined) {
                result[item[valueField]] = item[labelField];
            }
        }
    } else if (typeof extractedData === 'object') {
        // 如果是对象，提取 value 和 label 字段
        if (extractedData[valueField] !== undefined && extractedData[labelField] !== undefined) {
            result[extractedData[valueField]] = extractedData[labelField];
        }
    } else {
        print("Extracted data is neither an object nor an array.");
        return null;
    }

    return result;
}

// 定义一个方法来调用 HTTP 请求并处理结果
function getApiDict(url, method, body, headers, path, valueField, labelField) {
    var response = null;
    // 调用 HTTP GET 方法获取数据
    if (method == 'get') {
        response = httpGet(url, headers);
    } else if (method == 'post') {
        response = httpPost(url, body, headers);
    } else if (method == 'postFormData') {
        response = httpPostFormData(url, body, headers);
    }

    if (response === null) {
        print("Failed to fetch data.");
        return null;
    }

    // 解析 JSON 数据
    var data = JSON.parse(response);
    print(JSON.stringify(data));

    // 提取指定路径的数据
    var extractedData = extractDataFromPath(data, path);

    if (extractedData === null) {
        print("Failed to extract data from path: " + path);
        return null;
    }

    // 处理提取的数据并返回结果
    var result = processExtractedData(extractedData, valueField, labelField);

    return result;
}