// 定义数字和单位的映射
var digits = ['零', '一', '二', '三', '四', '五', '六', '七', '八', '九'];
var units = ['', '十', '百', '千', '万', '十', '百', '千', '亿', '十', '百', '千'];

// 定义金额单位
var currencyUnits = ['', '元', '角', '分'];

// 定义金额转大写的函数
function amountUpper(amount) {
    if (isNaN(amount) || amount < 0 || amount === '') {
      return amount;
    }
    // 将金额转换为整数和小数部分
    var integerPart = Math.floor(amount);
    var decimalPart = Math.round((amount - integerPart) * 100);

    // 将整数部分转换为字符串
    var integerStr = integerPart.toString();

    // 将整数部分转换为中文大写
    var result = '';
    for (var i = 0; i < integerStr.length; i++) {
        var digit = integerStr[integerStr.length - 1 - i];
        var digitChinese = digits[digit];
        var unit = units[i];
        result = digitChinese + unit + result;
    }

    // 处理小数部分
    var decimalStr = '';
    if (decimalPart > 0) {
        decimalStr += digits[Math.floor(decimalPart / 10)] + currencyUnits[1]; // 角
        decimalStr += digits[decimalPart % 10] + currencyUnits[2]; // 分
    }

    // 组合结果
    return result + currencyUnits[0] + decimalStr;
}