/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.util;

import com.jxdinfo.hussar.ds.common.enums.ParamTypeEnums;
import com.jxdinfo.hussar.ds.process.component.parser.dataFilter.model.ConditionDto;
import com.jxdinfo.hussar.ds.process.component.parser.dataFilter.model.FiledTreeData;
import com.jxdinfo.hussar.ds.process.component.parser.dataFilter.model.ParamListDto;
import com.jxdinfo.hussar.ds.process.component.parser.dataFilter.model.Path;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.ObjectUtils;

public class ParamUtil {
    private static final String FUNCTION = "function scriptFun() {\nvar resultList = [];\n${body}return JSON.stringify(resultList);\n} scriptFun();";
    private static final String SET_PARAM = "${name} = ${parentName};\n";
    private static final String SET_PARAM_NULL = "var ${name} = null;\n";
    private static final String RESULT = "var result = {${params}};\n";
    private static final String ADD_RESULT_LIST = "resultList.push(result);\n";
    private static final String FOR_EACH = "if (${paramName}) {\nfor (var i${index} = 0; i${index} < ${paramName}.length; i${index}++) {\n var items${index} = ${paramName}[i${index}];\n${body}}\n}\n";
    private static final String MAP_FOR_EACH = "if (${paramName}) {\nfor (var key${index} in ${paramName}) {\n var value${index} = ${paramName}[key${index}];\n${body}}\n}\n";
    private static final String QUERY = "if (${query}){\n${set}}\n";

    public static String parseFunction(Map<String, Path> filedMap, String parentParam, List<FiledTreeData> treeData, String[] params, List<ConditionDto> conditions, String name) {
        return FUNCTION.replace("${body}", ParamUtil.parseParam(0, filedMap, parentParam, treeData, params, "", conditions, name));
    }

    public static void addPath(StringBuilder sb, String name, String paramSuf) {
        if (sb.length() == 0) {
            sb.append(name).append(paramSuf);
        } else {
            sb.append("[\"").append(name).append("\"]");
        }
    }

    public static String parseParam(int index, Map<String, Path> filedMap, String parentParam, List<FiledTreeData> treeData, String[] params, String paramSuf, List<ConditionDto> conditions, String name) {
        Object body;
        HashMap<String, Path> map;
        String forEach;
        ParamListDto paramListDto;
        StringBuilder sb = new StringBuilder();
        ArrayList<ParamListDto> paramListDtoList = new ArrayList<ParamListDto>();
        ArrayList<ParamListDto> paramMapDtoList = new ArrayList<ParamListDto>();
        String listId = null;
        block0: for (Map.Entry<String, Path> stringPathEntry : filedMap.entrySet()) {
            String key = stringPathEntry.getKey();
            Path values = filedMap.get(key);
            List<FiledTreeData> treeDataItem = treeData;
            StringBuilder sbItem = new StringBuilder(parentParam);
            List<String> paths = values.getPaths();
            for (int i = 0; i < paths.size(); ++i) {
                String value = paths.get(i);
                Optional<FiledTreeData> dataOptional = treeDataItem.stream().filter(data -> data.getLabel().equals(value)).findFirst();
                if (dataOptional.isPresent()) {
                    ParamListDto paramListDto2;
                    FiledTreeData data2 = dataOptional.get();
                    if (data2.getType() == ParamTypeEnums.OBJECT.getType()) {
                        if (!ObjectUtils.isEmpty(data2.getChildren())) {
                            treeDataItem = data2.getChildren();
                            if (i == 0 && !ObjectUtils.isEmpty((Object)name)) {
                                ParamUtil.addPath(sbItem, name, paramSuf);
                                continue;
                            }
                            ParamUtil.addPath(sbItem, data2.getLabel(), paramSuf);
                            continue;
                        }
                        throw new RuntimeException("\u6570\u636e\u8fc7\u6ee4\u8282\u70b9\u53c2\u6570\u89e3\u6790\u5f02\u5e38");
                    }
                    if (data2.getType() == ParamTypeEnums.LIST.getType()) {
                        paramListDto2 = new ParamListDto();
                        if (i == 0 && !ObjectUtils.isEmpty((Object)name)) {
                            ParamUtil.addPath(sbItem, name, paramSuf);
                        } else {
                            ParamUtil.addPath(sbItem, data2.getLabel(), paramSuf);
                        }
                        paramListDto2.setParamName(sbItem.toString());
                        paramListDto2.setPath(new Path(values.getIndex(), paths.subList(i + 1, paths.size())));
                        paramListDto2.setFiledName(key);
                        paramListDto2.setTreeData(data2.getChildren());
                        if (listId != null && !Objects.equals(listId, data2.getId())) {
                            throw new RuntimeException("\u6570\u636e\u8fc7\u6ee4\u4e0d\u80fd\u9009\u62e9\u4e24\u4e2a\u4e0d\u4e3a\u5305\u542b\u5173\u7cfb\u7684\u6570\u7ec4/map");
                        }
                        listId = data2.getId();
                        paramListDtoList.add(paramListDto2);
                        continue block0;
                    }
                    if (data2.getType() == ParamTypeEnums.MAP.getType()) {
                        paramListDto2 = new ParamListDto();
                        if (i == 0 && !ObjectUtils.isEmpty((Object)name)) {
                            ParamUtil.addPath(sbItem, name, paramSuf);
                        } else {
                            ParamUtil.addPath(sbItem, data2.getLabel(), paramSuf);
                        }
                        paramListDto2.setParamName(sbItem.toString());
                        paramListDto2.setPath(new Path(values.getIndex(), paths.subList(i + 1, paths.size())));
                        paramListDto2.setFiledName(key);
                        paramListDto2.setTreeData(data2.getChildren());
                        if (listId != null && !Objects.equals(listId, data2.getId())) {
                            throw new RuntimeException("\u6570\u636e\u8fc7\u6ee4\u4e0d\u80fd\u9009\u62e9\u4e24\u4e2a\u4e0d\u4e3a\u5305\u542b\u5173\u7cfb\u7684\u6570\u7ec4/map");
                        }
                        listId = data2.getId();
                        paramMapDtoList.add(paramListDto2);
                        continue block0;
                    }
                    if (i == 0 && !ObjectUtils.isEmpty((Object)name)) {
                        ParamUtil.addPath(sbItem, name, paramSuf);
                    } else {
                        ParamUtil.addPath(sbItem, data2.getLabel(), paramSuf);
                    }
                    String param = SET_PARAM.replace("${name}", key).replace("${parentName}", sbItem.toString());
                    params[values.getIndex() - 1] = key;
                    sb.append(SET_PARAM_NULL.replace("${name}", key)).append(ParamUtil.parsePathNotNull(sbItem.toString()).replace("${set}", param));
                    continue block0;
                }
                throw new RuntimeException("\u6570\u636e\u8fc7\u6ee4\u8282\u70b9\u53c2\u6570\u89e3\u6790\u5f02\u5e38");
            }
        }
        if (!paramListDtoList.isEmpty()) {
            paramListDto = (ParamListDto)paramListDtoList.get(0);
            forEach = FOR_EACH.replace("${paramName}", paramListDto.getParamName()).replace("${index}", String.valueOf(index));
            map = new HashMap<String, Path>();
            for (ParamListDto listDto : paramListDtoList) {
                map.put(listDto.getFiledName(), listDto.getPath());
            }
            body = ParamUtil.parseParam(index + 1, map, "", paramListDto.getTreeData(), params, String.valueOf(index), conditions, null);
            sb.append(forEach.replace("${body}", (CharSequence)body));
        } else if (!paramMapDtoList.isEmpty()) {
            paramListDto = (ParamListDto)paramMapDtoList.get(0);
            forEach = MAP_FOR_EACH.replace("${paramName}", paramListDto.getParamName()).replace("${index}", String.valueOf(index));
            map = new HashMap();
            for (ParamListDto listDto : paramMapDtoList) {
                map.put(listDto.getFiledName(), listDto.getPath());
            }
            body = ParamUtil.parseParam(index + 1, map, "", paramListDto.getTreeData(), params, String.valueOf(index), conditions, null);
            sb.append(forEach.replace("${body}", (CharSequence)body));
        } else {
            StringBuilder paramSb = new StringBuilder();
            if (!ObjectUtils.isEmpty((Object[])params)) {
                paramSb.append(params[0]).append(": ").append(params[0]);
                for (int i = 1; i < params.length; ++i) {
                    paramSb.append(", ").append(params[i]).append(": ").append(params[i]);
                }
            }
            String set = RESULT.replace("${params}", paramSb.toString()) + ADD_RESULT_LIST;
            StringBuilder query = new StringBuilder();
            for (ConditionDto condition : conditions) {
                query.append(condition.getConditionStr());
            }
            if (HussarUtils.isEmpty((Object)query.toString())) {
                sb.append(set);
            } else {
                sb.append(QUERY.replace("${query}", query.toString()).replace("${set}", set));
            }
        }
        return sb.toString();
    }

    private static String parsePathNotNull(String path) {
        String[] split = path.split("\\[\"");
        if (split.length <= 1) {
            return "${set}\n";
        }
        for (int i = 0; i < split.length; ++i) {
            if (!split[i].endsWith("\"]")) continue;
            split[i] = split[i].substring(0, split[i].length() - 2);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("if (");
        StringBuilder pathSb = new StringBuilder();
        for (int i = 0; i < split.length - 1; ++i) {
            if (i == 0 && Objects.equals(split[0], "$")) {
                pathSb.append("$");
                continue;
            }
            if (i != 0) {
                pathSb.append("[\"");
            }
            pathSb.append(split[i]);
            if (i != 0) {
                pathSb.append("\"]");
            }
            if (i > 1 || i == 1 && !Objects.equals(split[0], "$")) {
                sb.append(" && ");
            }
            sb.append((CharSequence)pathSb);
        }
        sb.append(") {\n${set}}\n");
        return sb.toString();
    }
}

