/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.transform;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.TransformRowConfigDto;
import com.jxdinfo.hussar.ds.process.component.model.TransformRowToColumnConfigModel;
import com.jxdinfo.hussar.ds.process.constant.DataStreamConstant;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.util.DsPatternUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransformRowToColumnTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(TransformRowToColumnTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.TRANSFORM_ROW_TO_COLUMN;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        TransformRowToColumnConfigModel transformRowToColumnConfigModel = (TransformRowToColumnConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), TransformRowToColumnConfigModel.class);
        HussarException.throwByNull((Object)transformRowToColumnConfigModel, (String)"\u83b7\u53d6\u53c2\u6570\u76f8\u5173\u914d\u7f6e\u5931\u8d25");
        this.checkParams(detailConfig, transformRowToColumnConfigModel);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParams(CanvasDetailConfigDTO detailConfig, TransformRowToColumnConfigModel config) {
        HussarException.throwByNull((Object)config.getGroupFields(), (String)"\u5206\u7ec4\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        List parentFieldList = detailConfig.getParentFieldList();
        List groupFieldIds = config.getGroupFields().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toList());
        List parentFieldIds = parentFieldList.stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toList());
        HussarException.throwBy((!parentFieldIds.containsAll(groupFieldIds) ? 1 : 0) != 0, (String)"\u5206\u7ec4\u5b57\u6bb5\u4e0d\u5b58\u5728");
        HussarException.throwByNull((Object)config.getTransformConfig(), (String)"\u8f6c\u6362\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        TransformRowConfigDto transformConfig = config.getTransformConfig();
        boolean sourceFieldFlag = HussarUtils.isEmpty((Object)transformConfig.getSourceField()) || transformConfig.getSourceField().size() != 2 || HussarUtils.isEmpty((Object)transformConfig.getSourceFieldName());
        HussarException.throwBy((boolean)sourceFieldFlag, (String)"\u8f6c\u6362\u884c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)transformConfig.getTargetFields(), (String)"\u8f6c\u6362\u4e3a\u65b0\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        boolean targetValueFlag = HussarUtils.isEmpty((Object)transformConfig.getTargetValue()) || transformConfig.getTargetValue().size() != 2 || HussarUtils.isEmpty((Object)transformConfig.getTargetValueName());
        HussarException.throwBy((boolean)targetValueFlag, (String)"\u65b0\u5217\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)transformConfig.getAggregateType(), (String)"\u805a\u5408\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        transformConfig.getTargetFields().stream().forEach(targetField -> {
            HussarException.throwBy((!DsPatternUtil.matchesColumnName((String)targetField.getName()) ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
            HussarException.throwBy((targetField.getComment().length() > DataStreamConstant.DEFAULT_COLUMN_COMMEN_LENGTH ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u540d\u79f0\u957f\u5ea6\u8fc7\u957f");
        });
        List addColumnNames = detailConfig.getParentFieldList().stream().filter(field -> HussarUtils.isEmpty((Object)field.getGroupId())).map(ColumnFieldDto::getName).collect(Collectors.toList());
        List targetFieldNames = transformConfig.getTargetFields().stream().map(ColumnFieldDto::getName).collect(Collectors.toList());
        for (String targetFieldName : targetFieldNames) {
            HussarException.throwBy((boolean)addColumnNames.contains(targetFieldName), (String)"\u5b57\u6bb5\u7f16\u7801\u91cd\u590d");
            addColumnNames.add(targetFieldName);
        }
        boolean hasSourceField = parentFieldList.stream().anyMatch(field -> HussarUtils.equals((Object)field.getFieldId(), (Object)transformConfig.getSourceFieldName()));
        HussarException.throwBy((!hasSourceField ? 1 : 0) != 0, (String)"\u8f6c\u6362\u884c\u5b57\u6bb5\u4e0d\u5b58\u5728");
        boolean hasTargetValue = parentFieldList.stream().anyMatch(field -> HussarUtils.equals((Object)field.getFieldId(), (Object)transformConfig.getTargetValueName()));
        HussarException.throwBy((!hasTargetValue ? 1 : 0) != 0, (String)"\u65b0\u5217\u7684\u503c\u5b57\u6bb5\u4e0d\u5b58\u5728");
        HashSet paramSet = new HashSet(groupFieldIds);
        Set addFields = transformConfig.getTargetFields().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        paramSet.addAll(addFields);
        Set resultSet = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        HussarException.throwBy((!paramSet.equals(resultSet) ? 1 : 0) != 0, (String)"\u884c\u8f6c\u5217\u7ed3\u679c\u96c6\u5b57\u6bb5\u4e0e\u8f6c\u6362\u540e\u5b57\u6bb5\u4e0d\u7b26");
    }
}

