/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.parser.transform;

import com.jxdinfo.hussar.ds.process.component.dto.ColumnFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.TransformColumnToRowConfigModel;
import com.jxdinfo.hussar.ds.process.constant.DataStreamConstant;
import com.jxdinfo.hussar.ds.process.core.dto.InputParamDto;
import com.jxdinfo.hussar.ds.process.core.dto.TaskParamParser;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.util.DsPatternUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TransformColumnToRowTaskParamParser
implements TaskParamParser {
    private static final Logger logger = LoggerFactory.getLogger(TransformColumnToRowTaskParamParser.class);

    public ModuleTypeEnum getTaskType() {
        return ModuleTypeEnum.TRANSFORM_COLUMN_TO_ROW;
    }

    public String parseInputParams(InputParamDto inputParamDto, CanvasDetailConfigDTO detailConfig) {
        TransformColumnToRowConfigModel transformColumnToRowConfigModel = (TransformColumnToRowConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), TransformColumnToRowConfigModel.class);
        HussarException.throwByNull((Object)transformColumnToRowConfigModel, (String)"\u83b7\u53d6\u53c2\u6570\u76f8\u5173\u914d\u7f6e\u5931\u8d25");
        this.checkParams(detailConfig, transformColumnToRowConfigModel);
        return super.parseInputParams(inputParamDto, detailConfig);
    }

    private void checkParams(CanvasDetailConfigDTO detailConfig, TransformColumnToRowConfigModel config) {
        HussarException.throwByNull((Object)config.getFixedFields(), (String)"\u56fa\u5b9a\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        List parentFieldList = detailConfig.getParentFieldList();
        List fixedFieldIds = config.getFixedFields().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toList());
        List parentFieldIds = parentFieldList.stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toList());
        HussarException.throwBy((!parentFieldIds.containsAll(fixedFieldIds) ? 1 : 0) != 0, (String)"\u56fa\u5b9a\u5b57\u6bb5\u4e0d\u5b58\u5728");
        HussarException.throwByNull((Object)config.getTransformConfig(), (String)"\u5217\u8f6c\u884c\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        List sourceFields = config.getTransformConfig().getSourceFields();
        HussarException.throwByNull((Object)sourceFields, (String)"\u5217\u8f6c\u884c\u6e90\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        ColumnFieldDto targetField = config.getTransformConfig().getTargetField();
        HussarException.throwByNull((Object)targetField, (String)"\u5217\u8f6c\u884c\u76ee\u6807\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)targetField.getName(), (String)"\u5217\u8f6c\u884c\u65b0\u5217\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)targetField.getComment(), (String)"\u5217\u8f6c\u884c\u65b0\u5217\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((!DsPatternUtil.matchesColumnName((String)targetField.getName()) ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
        HussarException.throwBy((targetField.getComment().length() > DataStreamConstant.DEFAULT_COLUMN_COMMEN_LENGTH ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u540d\u79f0\u957f\u5ea6\u8fc7\u957f");
        ColumnFieldDto targetValueField = config.getTransformConfig().getTargetValueField();
        HussarException.throwByNull((Object)targetValueField, (String)"\u5217\u8f6c\u884c\u76ee\u6807\u503c\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)targetValueField.getName(), (String)"\u5217\u8f6c\u884c\u65b0\u5217\u503c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)targetValueField.getComment(), (String)"\u5217\u8f6c\u884c\u65b0\u5217\u503c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((!DsPatternUtil.matchesColumnName((String)targetValueField.getName()) ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
        HussarException.throwBy((targetValueField.getComment().length() > DataStreamConstant.DEFAULT_COLUMN_COMMEN_LENGTH ? 1 : 0) != 0, (String)"\u5b57\u6bb5\u540d\u79f0\u957f\u5ea6\u8fc7\u957f");
        HussarException.throwBy((boolean)HussarUtils.equals((Object)targetField.getName(), (Object)targetValueField.getName()), (String)"\u5217\u8f6c\u884c\u65b0\u5217\u7f16\u7801\u4e0e\u65b0\u5217\u503c\u7f16\u7801\u91cd\u590d");
        List addColumnNames = detailConfig.getParentFieldList().stream().filter(field -> HussarUtils.isEmpty((Object)field.getGroupId())).map(ColumnFieldDto::getName).collect(Collectors.toList());
        HussarException.throwBy((boolean)addColumnNames.contains(targetField.getName()), (String)"\u5b57\u6bb5\u7f16\u7801\u91cd\u590d");
        HussarException.throwBy((boolean)addColumnNames.contains(targetValueField.getName()), (String)"\u5b57\u6bb5\u7f16\u7801\u91cd\u590d");
        HashSet paramSet = new HashSet(fixedFieldIds);
        paramSet.add(targetField.getFieldId());
        paramSet.add(targetValueField.getFieldId());
        Set resultSet = detailConfig.getFieldList().stream().map(ColumnFieldDto::getFieldId).collect(Collectors.toSet());
        HussarException.throwBy((!paramSet.equals(resultSet) ? 1 : 0) != 0, (String)"\u5217\u8f6c\u884c\u7ed3\u679c\u96c6\u5b57\u6bb5\u4e0e\u8f6c\u6362\u540e\u5b57\u6bb5\u4e0d\u7b26");
    }
}

